/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;

public class LineMarkerDash
extends LineMarker {
    protected static final double ANGLE = 60.0;
    protected static final double OFFSET = 7.5;
    protected static final double LENGTH = 10.0;

    public LineMarkerDash() {
        this.setName("Dash");
    }

    @Override
    public double arcLength(double lineThickness) {
        return 0.1;
    }

    @Override
    public void draw(Device device, Point p, Color lineColor, double lineThickness, FillColor fillColor, double angle, double coronaWidth) {
        Direction lineDirection = Direction.valueOf(angle).turn180();
        GeoVector intersectionPointOffset = new GeoVector(7.5 * lineThickness, lineDirection);
        Point intersectionPoint = p.movePoint(intersectionPointOffset);
        Direction dashDirection = lineDirection.turn(60.0);
        GeoVector dashStartOffset = new GeoVector(5.0 * lineThickness, dashDirection);
        Point dashStartPoint = intersectionPoint.movePoint(dashStartOffset);
        GeoVector dashEndOffset = dashStartOffset.turn180();
        Point dashEndPoint = intersectionPoint.movePoint(dashEndOffset);
        Corners line1 = new Corners();
        line1.add(new Corner(dashStartPoint, 0.0));
        line1.add(new Corner(dashEndPoint, 0.0));
        device.polyline(line1, lineThickness + 2.0 * coronaWidth, lineColor, LineStyle.SOLID);
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public boolean usesFillColor() {
        return false;
    }
}

