/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.linemarkers.LineMarkerPolygon;

public class LineMarkerArrow
extends LineMarkerPolygon {
    protected static final double SCALE = 2.0;
    protected static final Point HOTSPOT = new Point(1.2, 0.0);
    protected static final Point LINESPOT = new Point(LineMarkerArrow.HOTSPOT.x - 2.6, 0.0);
    protected static final double ANGLE = 30.0;
    protected static final double LENGTH = 10.0;
    protected static final double WIDTH = new GeoVector(HOTSPOT, LINESPOT).abs() * Math.sin(Math.toRadians(30.0));
    protected static final double ARC_LENGTH_UNSCALED = new GeoVector(Point.ORIGIN, LINESPOT).abs();

    public LineMarkerArrow() {
        this.setName("Arrow");
        GeoVector lengthUp = new GeoVector(-Math.cos(Math.toRadians(30.0)), -Math.sin(Math.toRadians(30.0))).scaleToLength(10.0);
        GeoVector widthUp = lengthUp.turn(-90.0).scaleToLength(WIDTH);
        GeoVector lengthDown = new GeoVector(-Math.cos(Math.toRadians(30.0)), Math.sin(Math.toRadians(30.0))).scaleToLength(10.0);
        GeoVector widthDown = lengthDown.turn(90.0).scaleToLength(WIDTH);
        double r = WIDTH / 2.0;
        this.corners = new Corner[]{new Corner(HOTSPOT, r), new Corner(LINESPOT.movePoint(lengthUp).movePoint(widthUp), r), new Corner(LINESPOT.movePoint(lengthUp), r), new Corner(LINESPOT, r), new Corner(LINESPOT.movePoint(lengthDown), r), new Corner(LINESPOT.movePoint(lengthDown).movePoint(widthDown), r)};
    }

    @Override
    public double arcLength(double lineThickness) {
        return ARC_LENGTH_UNSCALED * lineThickness;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public boolean drawWithOutline() {
        return false;
    }
}

