/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.linemarkers;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.linemarkers.LineMarkerArrow;
import com.arcway.lib.graphics.linemarkers.LineMarkerBobble;
import com.arcway.lib.graphics.linemarkers.LineMarkerCircle;
import com.arcway.lib.graphics.linemarkers.LineMarkerCross;
import com.arcway.lib.graphics.linemarkers.LineMarkerDash;
import com.arcway.lib.graphics.linemarkers.LineMarkerDiamond;
import com.arcway.lib.graphics.linemarkers.LineMarkerDot;
import com.arcway.lib.graphics.linemarkers.LineMarkerNone;
import com.arcway.lib.graphics.linemarkers.LineMarkerPeakedArc;
import com.arcway.lib.graphics.linemarkers.LineMarkerPeakedArcFilled;
import com.arcway.lib.graphics.linemarkers.LineMarkerRhombus;
import com.arcway.lib.graphics.linemarkers.LineMarkerRoundedArc;
import com.arcway.lib.graphics.linemarkers.LineMarkerRoundedArcFilled;
import com.arcway.lib.graphics.linemarkers.LineMarkerTriangle;
import java.util.ArrayList;

public abstract class LineMarker {
    public static final int TYPE_NONE = 1;
    public static final int TYPE_DIRECTED_TO_LINE = 2;
    public static final int TYPE_DIRECTED_FROM_LINE = 3;
    public static final int TYPE_DIRECTED_BOTH = 4;
    public static ArrayList<LineMarker> lineMarkersDefault = new ArrayList();
    public static final LineMarker NONE = new LineMarkerNone();
    public static final LineMarker CROSS;
    public static final LineMarker DOT;
    public static final LineMarker BOBBLE;
    public static final LineMarker DASH;
    public static final LineMarker CIRCLE;
    public static final LineMarker DIAMOND;
    public static final LineMarker RHOMBUS;
    public static final LineMarker TRIANGLE;
    public static final LineMarker ROUNDED_ARC;
    public static final LineMarker ROUNDED_ARC_FILLED;
    public static final LineMarker PEAKED_ARC;
    public static final LineMarker PEAKED_ARC_FILLED;
    public static final LineMarker ARROW;
    protected String markerName = "unknown";

    static {
        lineMarkersDefault.add(NONE);
        CROSS = new LineMarkerCross();
        lineMarkersDefault.add(CROSS);
        DOT = new LineMarkerDot();
        lineMarkersDefault.add(DOT);
        BOBBLE = new LineMarkerBobble();
        lineMarkersDefault.add(BOBBLE);
        DASH = new LineMarkerDash();
        lineMarkersDefault.add(DASH);
        CIRCLE = new LineMarkerCircle();
        lineMarkersDefault.add(CIRCLE);
        DIAMOND = new LineMarkerDiamond();
        lineMarkersDefault.add(DIAMOND);
        RHOMBUS = new LineMarkerRhombus();
        lineMarkersDefault.add(RHOMBUS);
        TRIANGLE = new LineMarkerTriangle();
        lineMarkersDefault.add(TRIANGLE);
        ROUNDED_ARC = new LineMarkerRoundedArc();
        lineMarkersDefault.add(ROUNDED_ARC);
        ROUNDED_ARC_FILLED = new LineMarkerRoundedArcFilled();
        lineMarkersDefault.add(ROUNDED_ARC_FILLED);
        PEAKED_ARC = new LineMarkerPeakedArc();
        lineMarkersDefault.add(PEAKED_ARC);
        PEAKED_ARC_FILLED = new LineMarkerPeakedArcFilled();
        lineMarkersDefault.add(PEAKED_ARC_FILLED);
        ARROW = new LineMarkerArrow();
        lineMarkersDefault.add(ARROW);
    }

    public static LineMarker lineMarkerDefaultGetByName(String lineMarkerName) {
        for (LineMarker lineMarker2 : lineMarkersDefault) {
            LineMarker lineMarker = lineMarker2;
            if (!lineMarker.getName().equals(lineMarkerName)) continue;
            return lineMarker;
        }
        return null;
    }

    protected void setName(String lineMarkerName) {
        this.markerName = lineMarkerName;
    }

    public String getName() {
        return this.markerName;
    }

    public abstract double arcLength(double var1);

    public abstract void draw(Device var1, Point var2, Color var3, double var4, FillColor var6, double var7, double var9);

    public abstract boolean usesFillColor();

    public abstract int getType();
}

