/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.image;

import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.IImageProcessor;
import com.arcway.lib.graphics.image.IImageProxy;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.util.HashSet;
import java.util.Set;

public class ImageProxy
implements IImageProxy {
    private static final ILogger LOGGER = Logger.getLogger(ImageProxy.class);
    private final IStreamResource imageAsByteArrayStreamResource;
    private Image image;
    private final Set<Object> clients = new HashSet<Object>();

    public ImageProxy(IStreamResource imageAsByteArrayStreamResource) {
        this.imageAsByteArrayStreamResource = imageAsByteArrayStreamResource;
    }

    @Override
    public IStreamResource getPNGOrJPGByteArrayAsStreamResource() {
        return this.imageAsByteArrayStreamResource;
    }

    @Override
    public synchronized void getImage(IImageProcessor imageProcessor) throws EXUnsupportedColorDepth, EXNoMoreHandles, EXImageTooBig, EXImageDataTypeNotSupported, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        if (this.image == null) {
            this.image = ImageCoDec.decodeIntoImage(this.imageAsByteArrayStreamResource);
            LOGGER.debug("Image " + this.image + " converted from byte stream.");
        }
        try {
            imageProcessor.run(this.image);
        }
        finally {
            if (this.clients.size() == 0) {
                LOGGER.debug("Accessing the image proxy with no registered client (caching is inactive, the image will be disposed immediatly).");
                if (this.image != null) {
                    this.disposeImage();
                }
            }
        }
    }

    @Override
    public synchronized void registerClient(Object client) {
        boolean added = this.clients.add(client);
        if (!added) {
            LOGGER.warn("Tried to add a client twice.");
        }
    }

    @Override
    public synchronized void deregisterClient(Object client) {
        boolean removed = this.clients.remove(client);
        if (!removed) {
            LOGGER.warn("Tried to remove a non registered client.");
        }
        if (this.clients.isEmpty() && this.image != null) {
            this.disposeImage();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.clients.isEmpty()) {
            LOGGER.error("Image Proxy with registered clients was finalized.");
        }
        if (this.image != null && !this.image.isDisposed()) {
            LOGGER.error("Image Proxy with undisposed Image was finalized.");
            this.image.dispose();
            this.image = null;
        }
    }

    private void disposeImage() {
        final Image imageToDispose = this.image;
        imageToDispose.getRenderer().processInEventLoop(0L, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ImageProxy imageProxy = ImageProxy.this;
                synchronized (imageProxy) {
                    if (ImageProxy.this.clients.isEmpty()) {
                        if (!imageToDispose.isDisposed()) {
                            LOGGER.debug("Image " + imageToDispose + " disposed.");
                            imageToDispose.dispose();
                        }
                        if (ImageProxy.this.image == imageToDispose) {
                            ImageProxy.this.image = null;
                        }
                    }
                }
            }
        });
    }
}

