/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.image;

import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;
import com.arcway.lib.graphics.saveimage.ByteBuffer;
import com.arcway.lib.graphics.saveimage.ImageIO;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class ImageCoDec {
    public static final ImageFileType PNG = new ImageFileType("png", false);
    public static final ImageFileType JPG = new ImageFileType("jpg", true);

    public static final ImageFileType getPreferredImageFileType(boolean isLossyImage) {
        ImageFileType imageFileType = isLossyImage ? JPG : PNG;
        return imageFileType;
    }

    public static boolean isLossyImage(String fileNameOrExtension) {
        String extension = FileHelper.getFileExtension((String)fileNameOrExtension);
        if (extension.length() == 0) {
            extension = fileNameOrExtension;
        }
        boolean isLossyImage = (extension = extension.toLowerCase()).equals("jpg") || extension.equals("jpeg");
        return isLossyImage;
    }

    public static byte[] loadIntoPNGOrJPGByteArray(IStreamResource streamResource) throws EXImageDataTypeNotSupported, EXUnsupportedColorDepth, EXNoMoreHandles, EXImageTooBig, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        Image image = ImageCoDec.decodeIntoImage(streamResource);
        try {
            byte[] byArray = ImageCoDec.encodeIntoByteArray(image, ImageCoDec.determineFileType(image.isLossyImage()));
            return byArray;
        }
        finally {
            image.dispose();
        }
    }

    public static ImageFileType determineFileType(IStreamResource streamResource) {
        return ImageCoDec.determineFileType(streamResource.getName());
    }

    public static ImageFileType determineFileType(String fileName) {
        return ImageCoDec.determineFileType(ImageCoDec.isLossyImage(fileName));
    }

    public static ImageFileType determineFileType(boolean isLossyImage) {
        return isLossyImage ? JPG : PNG;
    }

    public static void encodeIntoFile(Image image, File file, ImageFileType format) throws EXImageDataTypeNotSupported, JvmExternalResourceInteractionException, EXImageTooBig {
        ImageCoDec.encodeIntoFile(image.getSnapshot(), image.getPixelPerMeterX(), image.getPixelPerMeterY(), file, format);
    }

    public static void encodeIntoFile(IOffscreenBitmap offscreenBitmap, double pixelsPerMeterX, double pixelsPerMeterY, File file, ImageFileType format) throws JvmExternalResourceInteractionException, EXImageDataTypeNotSupported, EXImageTooBig {
        ImageCoDec.encodeIntoFile(offscreenBitmap.getSnapshot(), pixelsPerMeterX, pixelsPerMeterY, file, format);
    }

    public static void encodeIntoFile(IImageData imageData, double pixelsPerMeterX, double pixelsPerMeterY, File file, ImageFileType format) throws JvmExternalResourceInteractionException, EXImageDataTypeNotSupported {
        if (format != PNG) {
            throw new EXImageDataTypeNotSupported();
        }
        ImageIO.write(imageData, file, (int)pixelsPerMeterX, (int)pixelsPerMeterY);
    }

    public static byte[] encodeIntoByteArray(Image image, ImageFileType format) throws EXImageTooBig, EXNoMoreHandles {
        return ImageCoDec.encodeIntoByteArray(image.getSnapshot(), image.getPixelPerMeterX(), image.getPixelPerMeterY(), format);
    }

    public static byte[] encodeIntoByteArray(IOffscreenBitmap offscreenBitmap, double pixelsPerMeterX, double pixelsPerMeterY, ImageFileType format) throws EXImageTooBig, EXNoMoreHandles {
        return ImageCoDec.encodeIntoByteArray(offscreenBitmap.getSnapshot(), pixelsPerMeterX, pixelsPerMeterY, format);
    }

    public static byte[] encodeIntoByteArray(IImageData imageData, double pixelsPerMeterX, double pixelsPerMeterY, ImageFileType format) throws EXImageTooBig, EXNoMoreHandles {
        byte[] data = format.isLossy() ? ImageCoDec.encodeIntoJPGByteArray(imageData, pixelsPerMeterX, pixelsPerMeterY) : ImageCoDec.encodeIntoPNGByteArray(imageData, pixelsPerMeterX, pixelsPerMeterY);
        return data;
    }

    private static byte[] encodeIntoJPGByteArray(IImageData imageData, double pixelsPerMeterX, double pixelsPerMeterY) throws EXImageTooBig, EXNoMoreHandles {
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        return renderer.encodeIntoJPGByteArray(imageData, pixelsPerMeterX, pixelsPerMeterY);
    }

    private static byte[] encodeIntoPNGByteArray(IImageData imageData, double pixelsPerMeterX, double pixelsPerMeterY) throws EXImageTooBig {
        ByteBuffer buffer = new ByteBuffer();
        ImageIO.write(imageData, buffer, (int)pixelsPerMeterX, (int)pixelsPerMeterY);
        return buffer.toByteArray();
    }

    public static Image decodeIntoImage(IRenderer renderer, IStreamResource imageResource) throws EXImageDataTypeNotSupported, EXUnsupportedColorDepth, EXNoMoreHandles, EXImageTooBig, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        return renderer.loadImage(imageResource);
    }

    public static Image decodeIntoImage(IRenderer renderer, final byte[] byteArray) throws EXImageDataTypeNotSupported, EXUnsupportedColorDepth, EXNoMoreHandles, EXImageTooBig, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        IStreamResource pngFileResource = new IStreamResource(){

            public String getName() {
                return "image." + PNG.getFileExtension();
            }

            public InputStream toInputStream() {
                return new ByteArrayInputStream(byteArray);
            }
        };
        return renderer.loadImage(pngFileResource);
    }

    public static Image decodeIntoImage(IStreamResource imageResource) throws EXImageDataTypeNotSupported, EXUnsupportedColorDepth, EXNoMoreHandles, EXImageTooBig, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        return ImageCoDec.decodeIntoImage(renderer, imageResource);
    }

    public static Image decodeIntoImage(byte[] byteArray) throws EXImageDataTypeNotSupported, EXUnsupportedColorDepth, EXNoMoreHandles, EXImageTooBig, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        return ImageCoDec.decodeIntoImage(renderer, byteArray);
    }

    public static IImageData decodeIntoImageData(IRenderer renderer, IStreamResource imageResource) throws EXImageDataTypeNotSupported, EXImageTooBig, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        return renderer.loadImageData(imageResource);
    }

    public static IImageData decodeIntoImageData(final byte[] byteArray) throws EXImageDataTypeNotSupported, EXImageTooBig, EXCorruptImageFileContent, JvmExternalResourceInteractionException, EXUnspecifiedImageLoadingError {
        IStreamResource pngFileResource = new IStreamResource(){

            public String getName() {
                return "image." + PNG.getFileExtension();
            }

            public InputStream toInputStream() {
                return new ByteArrayInputStream(byteArray);
            }
        };
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        return renderer.loadImageData(pngFileResource);
    }

    private ImageCoDec() {
    }
}

