/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.image;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverOffscreenBitmap;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.plugin.DefaultRendererExtensionPoint;

public class Image {
    public static final long IMAGESIZE_1_MEGAPIXELS = 995328L;
    public static final long IMAGESIZE_2_MEGAPIXELS = 1920000L;
    public static final long IMAGESIZE_3_MEGAPIXELS = 3048192L;
    public static final long IMAGESIZE_5_MEGAPIXELS = 5038848L;
    public static final long IMAGESIZE_8_MEGAPIXELS = 7990272L;
    private final double pixelPerMeterX;
    private final double pixelPerMeterY;
    private final IOffscreenBitmap wrappedOffscreenBitmap;
    private Transformation transformationMmToPixels;
    private Transformation transformationPixelsToMm;

    public static Image scaleImage(Image imageToScale, long maxNrOfPixels) throws EXImageTooBig, EXNoMoreHandles {
        double oldHeightInPixels;
        double oldWidthInPixels = imageToScale.getWidthInPixels();
        double ratio = oldWidthInPixels / (oldHeightInPixels = (double)imageToScale.getHeightInPixels());
        int newHeightInPixels = (int)Math.sqrt((double)maxNrOfPixels / ratio);
        int newWidthInPixels = (int)((double)newHeightInPixels * ratio);
        if (newWidthInPixels < 1) {
            newWidthInPixels = 1;
            newHeightInPixels = (int)Math.min((long)newHeightInPixels, maxNrOfPixels);
        } else if (newHeightInPixels < 1) {
            newHeightInPixels = 1;
            newWidthInPixels = (int)Math.min((long)newWidthInPixels, maxNrOfPixels);
        }
        Image scaledImage = Image.scaleImage(imageToScale, newWidthInPixels, newHeightInPixels);
        assert ((long)(scaledImage.getHeightInPixels() * scaledImage.getWidthInPixels()) < maxNrOfPixels) : "Image is still to big after resizing.";
        return scaledImage;
    }

    public static Image scaleImage(Image imageToScale, int newWidthInPixels, int newHeightInPixels) throws EXImageTooBig, EXNoMoreHandles {
        double newPixelPerMeterX = imageToScale.getPixelPerMeterX() * (double)newWidthInPixels / (double)imageToScale.getWidthInPixels();
        double newPixelPerMeterY = imageToScale.getPixelPerMeterY() * (double)newHeightInPixels / (double)imageToScale.getHeightInPixels();
        Image scaledImage = new Image(newWidthInPixels, newHeightInPixels, Color.TRANSPARENT, newPixelPerMeterX, newPixelPerMeterY, imageToScale.isLossyImage());
        IOffscreenBitmap offscreenBitmapToScale = imageToScale.getOffscreenBitmap();
        IOffscreenBitmap scaledOffsceenBitmap = scaledImage.getOffscreenBitmap();
        IDeviceDriverOffscreenBitmap deviceDriver = scaledOffsceenBitmap.createDeviceDriver();
        try {
            deviceDriver.drawImage(offscreenBitmapToScale, 0, 0, offscreenBitmapToScale.getWidthInPixels(), offscreenBitmapToScale.getHeightInPixels(), new TurnedRectangle(new Rectangle(0.0, 0.0, new Dimension(newWidthInPixels, newHeightInPixels))), 255);
        }
        finally {
            deviceDriver.dispose();
        }
        return scaledImage;
    }

    public static Image centerImage(Image imageToCenter, int newWidthInPixels, int newHeightInPixels) throws EXImageTooBig, EXNoMoreHandles {
        Image centeredImage = new Image(newWidthInPixels, newHeightInPixels, Color.TRANSPARENT, imageToCenter.getPixelPerMeterX(), imageToCenter.getPixelPerMeterY(), false);
        IOffscreenBitmap offscreenBitmapToCenter = imageToCenter.getOffscreenBitmap();
        IOffscreenBitmap centeredOffsceenBitmap = centeredImage.getOffscreenBitmap();
        IDeviceDriverOffscreenBitmap deviceDriver = centeredOffsceenBitmap.createDeviceDriver();
        int offsetX = (newWidthInPixels - imageToCenter.getWidthInPixels()) / 2;
        int offsetY = (newHeightInPixels - imageToCenter.getHeightInPixels()) / 2;
        try {
            deviceDriver.drawImage(offscreenBitmapToCenter, 0, 0, offscreenBitmapToCenter.getWidthInPixels(), offscreenBitmapToCenter.getHeightInPixels(), new TurnedRectangle(new Rectangle(offsetX, offsetY, new Dimension(offscreenBitmapToCenter.getWidthInPixels(), offscreenBitmapToCenter.getHeightInPixels()))), 255);
        }
        finally {
            deviceDriver.dispose();
        }
        return centeredImage;
    }

    public static Image wrapImage(IOffscreenBitmap offscreenBitmap, double pixelPerMeterX, double pixelPerMeterY) throws EXImageTooBig, EXNoMoreHandles {
        return new Image(offscreenBitmap, pixelPerMeterX, pixelPerMeterY, true);
    }

    public Image(int w, int h, Color backgroundColor, double pixelPerMeterX, double pixelPerMeterY, boolean isLossyImage) throws EXImageTooBig, EXNoMoreHandles {
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        this.wrappedOffscreenBitmap = renderer.createOffscreenBitmap(w, h, backgroundColor, isLossyImage);
        this.pixelPerMeterX = pixelPerMeterX;
        this.pixelPerMeterY = pixelPerMeterY;
        this.setup();
    }

    public Image(IImageData imageData, double pixelPerMeterX, double pixelPerMeterY) throws EXImageTooBig, EXNoMoreHandles, EXImageDataTypeNotSupported {
        IRenderer renderer = DefaultRendererExtensionPoint.getInstance().getDefaultRendererManager().getDefaultRendererOfCurrentThread();
        IOffscreenBitmap offscreenBitmap = renderer.createOffscreenBitmap(imageData);
        this.pixelPerMeterX = pixelPerMeterX;
        this.pixelPerMeterY = pixelPerMeterY;
        this.wrappedOffscreenBitmap = offscreenBitmap;
    }

    public Image(IOffscreenBitmap offscreenBitmap, double pixelPerMeterX, double pixelPerMeterY) throws EXImageTooBig, EXNoMoreHandles {
        this(offscreenBitmap, pixelPerMeterX, pixelPerMeterY, false);
    }

    private Image(IOffscreenBitmap offscreenBitmap, double pixelPerMeterX, double pixelPerMeterY, boolean wrap) throws EXImageTooBig, EXNoMoreHandles {
        assert (offscreenBitmap != null);
        this.pixelPerMeterX = pixelPerMeterX;
        this.pixelPerMeterY = pixelPerMeterY;
        if (wrap) {
            this.wrappedOffscreenBitmap = offscreenBitmap;
        } else {
            try {
                this.wrappedOffscreenBitmap = offscreenBitmap.getRenderer().createOffscreenBitmap(offscreenBitmap);
            }
            catch (EXImageDataTypeNotSupported e) {
                throw new RuntimeException(e);
            }
        }
        this.setup();
    }

    public Image(Image image) throws EXImageTooBig, EXNoMoreHandles {
        assert (image != null);
        this.pixelPerMeterX = image.pixelPerMeterX;
        this.pixelPerMeterY = image.pixelPerMeterY;
        IOffscreenBitmap sourceOffscreenBitmap = image.wrappedOffscreenBitmap;
        try {
            this.wrappedOffscreenBitmap = sourceOffscreenBitmap.getRenderer().createOffscreenBitmap(sourceOffscreenBitmap);
        }
        catch (EXImageDataTypeNotSupported e) {
            throw new RuntimeException(e);
        }
        this.setup();
    }

    private void setup() {
        double fx = this.pixelPerMeterX / 1000.0;
        double fy = this.pixelPerMeterY / 1000.0;
        this.transformationMmToPixels = TransformationAffiliate.newTransformationScaling(new GeoVector(fx, fy));
        this.transformationPixelsToMm = this.transformationMmToPixels.getInverse();
    }

    public double getPixelPerMeterX() {
        return this.pixelPerMeterX;
    }

    public double getPixelPerMeterY() {
        return this.pixelPerMeterY;
    }

    public IOffscreenBitmap getOffscreenBitmap() {
        return this.wrappedOffscreenBitmap;
    }

    public IDeviceDriverOffscreenBitmap createDeviceDriver() {
        return this.wrappedOffscreenBitmap.createDeviceDriver();
    }

    public void dispose() {
        this.wrappedOffscreenBitmap.dispose();
    }

    public IRenderer getRenderer() {
        return this.wrappedOffscreenBitmap.getRenderer();
    }

    public IImageData getSnapshot() throws EXImageTooBig {
        return this.wrappedOffscreenBitmap.getSnapshot();
    }

    public int getWidthInPixels() {
        return this.wrappedOffscreenBitmap.getWidthInPixels();
    }

    public int getHeightInPixels() {
        return this.wrappedOffscreenBitmap.getHeightInPixels();
    }

    public Transformation getTransformationMmToPixels() {
        return this.transformationMmToPixels;
    }

    public Transformation getTransformationPixelsToMm() {
        return this.transformationPixelsToMm;
    }

    public Dimension getDimensionInMM() {
        return new Dimension(this.getWidthInPixels(), this.getHeightInPixels()).transform(this.transformationPixelsToMm);
    }

    public boolean isLossyImage() {
        return this.wrappedOffscreenBitmap.isLossyImage();
    }

    public boolean isDisposed() {
        return this.wrappedOffscreenBitmap.isDisposed();
    }
}

