/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.fillstyles;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.graphics.fillstyles.FillStyleHatching;

public class FillStyleDashes
extends FillStyleHatching {
    private static final double LINEWIDTH = 0.75;
    private static final double SPACING = 2.0;
    private static final double ANGLE = 42.0;

    @Override
    protected void drawHatching(Rectangle area, FillStyleHatching.HatchingContext hatchingContext) {
        double height = area.h();
        double hangover = height * Math.tan(Math.toRadians(42.0));
        double xStart = area.upperLeft.x - 1.0;
        double xEnd = area.lowerRight.x + hangover + 2.02;
        Point p1 = new Point(xStart, area.upperLeft.y);
        Point p2 = new Point(xStart - hangover, area.lowerRight.y);
        while (p1.x <= xEnd) {
            StraightLine even = new StraightLine(p1, p2);
            this.drawEven(even, 0.75, hatchingContext);
            p1 = new Point(p1.x + 2.0, p1.y);
            p2 = new Point(p2.x + 2.0, p2.y);
        }
    }
}

