/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.device.PolygonProcessorPolygonDraw;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverAttributeStorage;
import com.arcway.lib.graphics.linestyles.ILineDrawProcessor;
import com.arcway.lib.graphics.linestyles.LineStyle;

public abstract class DeviceDriverLineDrawing
extends DeviceDriverAttributeStorage
implements ILineDrawProcessor {
    @Override
    public void polygon(Polygon polygon) {
        this.polyline(polygon, 0.0, 0.0);
    }

    @Override
    public void polyline(Polygon polyline, double skipAtBeginning, double skipAtEnd) {
        this.drawPolygon(polyline, this.getLineScale(), this.getLineStyle(), skipAtBeginning, skipAtEnd);
    }

    private void drawPolygon(Polygon polygon, double lineScale, LineStyle lineStyle, double skipAtBeginning, double skipAtEnd) {
        double eraseWidth;
        assert (polygon != null) : "polygon is null";
        assert (lineStyle != null) : "lineStyle is null";
        assert (lineScale > 1.0E-10) : "lineScale <= 0";
        assert (skipAtBeginning > -1.0E-10) : "skipAtBeginning < 0";
        assert (skipAtEnd > -1.0E-10) : "skipAtEnd < 0";
        if (polygon.isClosed() && (eraseWidth = lineStyle.getEraseWidth()) > 1.0E-10) {
            Color lineColorBackup = this.getLineColor();
            double lineWidthBackup = this.getLineWidth();
            this.setLineColor(Color.WHITE);
            this.setLineWidth(eraseWidth * lineWidthBackup);
            PolygonProcessorPolygonDraw pieceProcessor = new PolygonProcessorPolygonDraw(polygon, this, LineStyle.SOLID, lineScale, skipAtBeginning, skipAtEnd);
            polygon.process(pieceProcessor);
            this.setLineWidth(lineWidthBackup);
            this.setLineColor(lineColorBackup);
        }
        PolygonProcessorPolygonDraw pieceProcessor = new PolygonProcessorPolygonDraw(polygon, this, lineStyle, lineScale, skipAtBeginning, skipAtEnd);
        polygon.process(pieceProcessor);
    }
}

