/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverAttributeStub;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverFitter;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.linestyles.LineStyle;

public class DeviceDriverHitTest
extends DeviceDriverAttributeStub {
    protected DeviceDriverFitter fitter;
    private final Point pointToTest;
    private final double tolerance;
    private boolean isPointHitted = false;
    private double lineWidth = 1.0;
    private double lineWidthFactor = 1.0;
    private final double exactHitTestThreshold;
    private TransformationAffiliate currentTransformation = TransformationAffiliate.newTransformationNOP();

    public DeviceDriverHitTest(DeviceDriverFitter fitter, Point pointToTest, double tolerance) {
        assert (pointToTest != null);
        this.fitter = fitter;
        this.pointToTest = pointToTest;
        this.tolerance = tolerance;
        this.exactHitTestThreshold = 2.0 * tolerance;
    }

    @Override
    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        if (optionalTransformation != null) {
            TransformationAffiliate currentTrafo = this.currentTransformation;
            this.currentTransformation = optionalTransformation.transform(currentTrafo);
            try {
                runnable.run();
            }
            finally {
                this.currentTransformation = currentTrafo;
            }
        } else {
            runnable.run();
        }
    }

    public boolean isPointHit() {
        return this.isPointHitted;
    }

    @Override
    public void setLineWidth(double lineWidth) {
        assert (Geo.isZeroOrGreaterThanZero(lineWidth));
        this.lineWidth = lineWidth;
    }

    @Override
    public void setLineStyle(LineStyle lineStyle) {
        this.lineWidthFactor = lineStyle.getWidthFactor();
    }

    @Override
    public void polyline(Polygon polyline, double skipAtBeginning, double skipAtEnd) {
        if (!this.isPointHitted) {
            this.isPointHitted = polyline.hasBeenHit(this.pointToTest, Math.max(this.tolerance, this.lineWidth * this.lineWidthFactor / 2.0), this.currentTransformation);
        }
    }

    @Override
    public void polygon(Polygon polygon) {
        assert (polygon != null);
        if (!this.isPointHitted) {
            this.isPointHitted = polygon.isNearBorder(this.pointToTest, Math.max(this.tolerance, this.lineWidth * this.lineWidthFactor / 2.0), this.currentTransformation);
        }
    }

    @Override
    public void fill(Polygon polygon) {
        assert (polygon != null);
        this.doHitTest(polygon, 0.0);
    }

    @Override
    public boolean isNotInterestedInRealTextDrawing() {
        return true;
    }

    @Override
    public void text(Point p, double textLength, String text, TurnedRectangle clippingHint) {
        assert (p != null);
        assert (text != null);
        assert (clippingHint != null);
        if (!this.isPointHitted) {
            this.isPointHitted = clippingHint.toPoints().transform(this.currentTransformation).isInside(this.pointToTest);
        }
    }

    private void doHitTest(Polygon polygon, double lineThickness) {
        if (!this.isPointHitted) {
            Points pointsApproximated = polygon.getPointsApproximated().transform(this.currentTransformation);
            Rectangle r = pointsApproximated.getBounds();
            this.isPointHitted = r.w() > this.exactHitTestThreshold && r.h() > this.exactHitTestThreshold ? polygon.hasBeenHit(this.pointToTest, lineThickness / 2.0, this.currentTransformation) : (r.w() > this.exactHitTestThreshold || r.h() > this.exactHitTestThreshold ? polygon.hasBeenHit(this.pointToTest, this.tolerance, this.currentTransformation) : new Rectangle(r.upperLeft.x - this.exactHitTestThreshold / 2.0, r.upperLeft.y - this.exactHitTestThreshold / 2.0, r.lowerRight.x + this.exactHitTestThreshold / 2.0, r.lowerRight.y + this.exactHitTestThreshold / 2.0).isInside(this.pointToTest));
        }
    }

    @Override
    public void drawImage(IOffscreenBitmap image, int sourceX, int sourceY, int sourceW, int sourceH, TurnedRectangle scaleToRectangle, int alpha) {
        if (!this.isPointHitted) {
            this.isPointHitted = scaleToRectangle.toPoints().transform(this.currentTransformation).isInside(this.pointToTest);
        }
    }

    @Override
    public boolean supportsNullImage() {
        return true;
    }
}

