/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.geometry.polygon.PolygonProcessor;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverAttributeStorage;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverFitter;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.linestyles.LineStyle;

public class DeviceDriverGetBounds
extends DeviceDriverAttributeStorage {
    private final DeviceDriverFitter fitter;
    private Rectangle bounds = null;
    private TransformationAffiliate currentTransformation = TransformationAffiliate.newTransformationNOP();

    public DeviceDriverGetBounds() {
        this(null);
    }

    public DeviceDriverGetBounds(DeviceDriverFitter fitter) {
        this.fitter = fitter;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        if (optionalTransformation != null) {
            TransformationAffiliate currentTrafo = this.currentTransformation;
            this.currentTransformation = optionalTransformation.transform(currentTrafo);
            try {
                runnable.run();
            }
            finally {
                this.currentTransformation = currentTrafo;
            }
        } else {
            runnable.run();
        }
    }

    private void addPoint(double x, double y) {
        Point ps = new Point(x, y);
        Point pm = ps.transform(this.currentTransformation);
        Point p = this.fitter != null ? new Point(this.fitter.pointFitX(pm.x), this.fitter.pointFitY(pm.y)) : pm;
        this.bounds = this.bounds == null ? new Rectangle(p, p) : this.bounds.union(p);
    }

    private void addPoint(Point p) {
        if (p != null) {
            Point pm = p.transform(this.currentTransformation);
            this.addPoint(pm.x, pm.y);
        }
    }

    private void addPoint(double x, double y, double rx, double ry, double angle) {
        double angleRad = Math.toRadians(angle);
        this.addPoint(x + rx * Math.cos(angleRad), y - ry * Math.sin(angleRad));
    }

    private void addPlot(double x, double y) {
        double lineWidthFitted;
        Point pFitted;
        if (this.fitter != null) {
            pFitted = new Point(this.fitter.pointFitX(x), this.fitter.pointFitY(y));
            lineWidthFitted = this.fitter.lineWidthFit(this.getLineWidth());
        } else {
            pFitted = new Point(x, y);
            lineWidthFitted = this.getLineWidth();
        }
        LineStyle lineStyle = this.getLineStyle();
        double widthFactor = lineStyle.getWidthFactor();
        double realLineWidth = lineWidthFitted * widthFactor;
        this.addPoint(pFitted.x - realLineWidth / 2.0 + 1.0E-10, pFitted.y - realLineWidth / 2.0 + 1.0E-10);
        this.addPoint(pFitted.x + realLineWidth / 2.0 - 1.0E-10, pFitted.y + realLineWidth / 2.0 - 1.0E-10);
    }

    private void addPlot(double x, double y, double rx, double ry, double angle) {
        double angleRad = Math.toRadians(angle);
        this.addPlot(x + rx * Math.cos(angleRad), y - ry * Math.sin(angleRad));
    }

    @Override
    public void polyline(Polygon polyline, double skipAtBeginning, double skipAtEnd) {
        assert (polyline != null) : "polygon = null";
        PolygonDrawPolygonProcessor pieceProcessor = new PolygonDrawPolygonProcessor(true);
        polyline.process(pieceProcessor);
    }

    @Override
    public void polygon(Polygon polygon) {
        assert (polygon != null) : "polygon = null";
        PolygonDrawPolygonProcessor pieceProcessor = new PolygonDrawPolygonProcessor(true);
        polygon.process(pieceProcessor);
    }

    @Override
    public void fill(Polygon polygon) {
        assert (polygon != null) : "polygon = null";
        PolygonDrawPolygonProcessor pieceProcessor = new PolygonDrawPolygonProcessor(false);
        polygon.process(pieceProcessor);
    }

    @Override
    public boolean isNotInterestedInRealTextDrawing() {
        return true;
    }

    @Override
    public void text(Point p, double textLength, String text, TurnedRectangle clippingHint) {
        this.addPoint(clippingHint.getUpperLeft());
        this.addPoint(clippingHint.getUpperRight());
        this.addPoint(clippingHint.getLowerLeft());
        this.addPoint(clippingHint.getLowerRight());
    }

    @Override
    public void drawImage(IOffscreenBitmap image, int sourceX, int sourceY, int sourceW, int sourceH, TurnedRectangle scaleToRectangle, int alpha) {
        this.addPoint(scaleToRectangle.getUpperLeft());
        this.addPoint(scaleToRectangle.getUpperRight());
        this.addPoint(scaleToRectangle.getLowerLeft());
        this.addPoint(scaleToRectangle.getLowerRight());
    }

    @Override
    public boolean supportsNullImage() {
        return true;
    }

    class PolygonDrawPolygonProcessor
    extends PolygonProcessor {
        boolean plot;

        public PolygonDrawPolygonProcessor(boolean plot) {
            this.plot = plot;
        }

        @Override
        public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
            this.arc(arc.center.x, arc.center.y, arc.rx, arc.ry, arc.angleStart, arc.angleEnd, this.plot);
        }

        @Override
        public void processLine(Direction comingFrom, Line line, Direction goingTo) {
            this.line(line.start.x, line.start.y, line.end.x, line.end.y, this.plot);
        }

        @Override
        public void processPoint(Point point) {
            if (this.plot) {
                DeviceDriverGetBounds.this.addPlot(point.x, point.y);
            } else {
                DeviceDriverGetBounds.this.addPoint(point.x, point.y);
            }
        }

        private void line(double x1, double y1, double x2, double y2, boolean isPlot) {
            if (isPlot) {
                DeviceDriverGetBounds.this.addPlot(x1, y1);
                DeviceDriverGetBounds.this.addPlot(x2, y2);
            } else {
                DeviceDriverGetBounds.this.addPoint(x1, y1);
                DeviceDriverGetBounds.this.addPoint(x2, y2);
            }
        }

        private void arc(double x, double y, double rx, double ry, double angleStart, double angleEnd, boolean isPlot) {
            assert (rx >= -1.0E-10) : "rx < null";
            assert (ry >= -1.0E-10) : "ry < null";
            if (isPlot) {
                DeviceDriverGetBounds.this.addPlot(x, y, rx, ry, angleStart);
            } else {
                DeviceDriverGetBounds.this.addPoint(x, y, rx, ry, angleStart);
            }
            if (angleEnd > angleStart) {
                double angleCounter = Math.ceil(angleStart / 90.0) * 90.0;
                while (angleCounter < angleEnd) {
                    if (isPlot) {
                        DeviceDriverGetBounds.this.addPlot(x, y, rx, ry, angleCounter);
                    } else {
                        DeviceDriverGetBounds.this.addPoint(x, y, rx, ry, angleCounter);
                    }
                    angleCounter += 90.0;
                }
            } else {
                double angleCounter = Math.floor(angleStart / 90.0) * 90.0;
                while (angleCounter > angleEnd) {
                    if (isPlot) {
                        DeviceDriverGetBounds.this.addPlot(x, y, rx, ry, angleCounter);
                    } else {
                        DeviceDriverGetBounds.this.addPoint(x, y, rx, ry, angleCounter);
                    }
                    angleCounter -= 90.0;
                }
            }
            if (isPlot) {
                DeviceDriverGetBounds.this.addPlot(x, y, rx, ry, angleEnd);
            } else {
                DeviceDriverGetBounds.this.addPoint(x, y, rx, ry, angleEnd);
            }
        }
    }
}

