/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import com.arcway.lib.CRC64;
import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverInterpolating;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriver;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverMetafile;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceDriverEMF
extends DeviceDriverInterpolating
implements IDeviceDriverMetafile {
    private static final ILogger logger = Logger.getLogger(DeviceDriverEMF.class);
    private static final int NR_OF_OBJECTS = 32;
    private static final double METAFILEUNITS_PER_INCH_REFERENCE = 100.0;
    private static final double METAFILEUNITS_PER_INCH = 100.0;
    private static final TransformationAffiliate WORLD_TO_DRIVER_BASIS = TransformationAffiliate.newTransformationScaling(1.0);
    private static final double PIXELS_PER_METAFILEUNIT = 1.0;
    private static final int EMF_VERSION = 65536;
    private static final int EMR_COMMENT = 70;
    private static final int EMR_HEADER = 1;
    private static final int EMR_EOF = 14;
    private static final int ENHMETA_SIGNATURE = 1179469088;
    private static final int EMR_COMMENT_EMFPLUS = 726027589;
    private final Data32BitInteger EMFPLUS_GRAPHICS_VERSION = new Data32BitInteger(-608169982);
    private static final int EMFPLUS_HEADER = 16385;
    private static final int EMFPLUS_END_OF_FILE = 16386;
    private static final int EMFPLUS_CLEAR = 16388;
    private static final int EMFPLUS_SET_WORLD_TRANSFORM = 16426;
    private static final int EMFPLUS_SET_RENDERING_ORIGIN = 16413;
    private static final int EMFPLUS_SET_ANTI_ALIAS_MODE = 16414;
    private static final int EMFPLUS_SET_TEXT_RENDERING_HINT = 16415;
    private static final int EMFPLUS_SET_INTERPOLATION_MODE = 16417;
    private static final int EMFPLUS_SET_PIXEL_OFFSET_MODE = 16418;
    private static final int EMFPLUS_SET_COMPOSITION_MODE = 16419;
    private static final int EMFPLUS_SET_COMPOSITING_QUALITY = 16420;
    private static final int EMFPLUS_SAVE = 16421;
    private static final int EMFPLUS_RESTORE = 16422;
    private static final int EMFPLUS_OBJECT = 16392;
    private static final int EMFPLUS_DRAW_FILLPOLYGON = 16396;
    private static final int EMFPLUS_DRAW_LINES = 16397;
    private static final int EMFPLUS_DRAW_STRING = 16412;
    private static final int EMFPLUS_DRAW_IMAGE = 16410;
    private static final int EMFPLUS_GRAPHICS_VERSION_1_1 = 2;
    private static final int EMFPLUS_SMOOTHING_MODE_HIGH_QUALITY = 2;
    private static final int EMFPLUS_COMPOSITION_MODE_SOURCE_OVER = 0;
    private static final int EMFPLUS_COMPOSITION_QUALITY_HIGH_QUALITY = 3;
    private static final int EMFPLUS_INTERPOLATION_MODE_HIGH_QUALITY = 2;
    private static final int EMFPLUS_PIXEL_OFFSET_MODE_HIGH_QUALITY = 2;
    private static final int EMFPLUS_TEXT_RENDERING_HINT_CLEAR_TYPE_ANTIALIAS = 4;
    private static final int EMFPLUS_FILLPOLYGON_FLAG_BRUSHID_IS_COLOR = 32768;
    private static final int EMFPLUS_DRAWSTRING_FLAG_BRUSHID_IS_COLOR = 32768;
    private static final int EMFPLUS_UNIT_TYPE_WORLD = 0;
    private static final int EMFPLUS_BRUSH_TYPE_SOLID_COLOR = 0;
    private static final int EMFPLUS_LINE_CAP_TYPE_ROUND = 2;
    private static final int EMFPLUS_PEN_DATA_START_CAP = 2;
    private static final int EMFPLUS_PEN_DATA_END_CAP = 4;
    private static final int EMFPLUS_FONT_STYLE_BOLD = 1;
    private static final int EMFPLUS_FONT_STYLE_ITALIC = 2;
    private static final int EMFPLUS_FONT_STYLE_UNDERLINE = 4;
    private static final int EMFPLUS_FONT_STYLE_STRIKETHROUGH = 8;
    private static final int EMFPLUS_UNIT_TYPE_PIXEL = 2;
    private static final int EMFPLUS_OBJECT_TYPE_PEN = 2;
    private static final int EMFPLUS_OBJECT_TYPE_IMAGE = 5;
    private static final int EMFPLUS_OBJECT_TYPE_FONT = 6;
    private static final int EMFPLUS_OBJECT_TYPE_STRING_FORMAT = 7;
    private static final int EMFPLUS_OBJECT_TYPE_IMAGE_ATTRIBUTES = 8;
    private static final int EMFPLUS_WRAP_MODE_CLAMP = 4;
    private static final int EMFPLUS_RECT_CLAMP = 0;
    private static final int IMAGE_DATA_TYPE_BITMAP = 1;
    private static final int BITMAP_DATA_TYPE_COMPRESSED = 1;
    private final DataEMFPlusARGB EMFPLUS_COLOR_TRANSPARENT = new DataEMFPlusARGB(Color.TRANSPARENT);
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private byte[] buffer = null;
    private int fileOffsetHeaderBytes = -1;
    private int fileOffsetHeaderNrOfRecords = -1;
    private int fileOffsetHeaderNrOfObjects = -1;
    private int fileOffsetEmrCommentEmfPlusBegin = -1;
    private int fileOffsetEmrCommentEmfPlusSize = -1;
    private int fileOffsetEmrCommentEmfPlusDataSize = -1;
    private int fileOffsetEmrCommentEmfPlusDataBegin = -1;
    private int fileOffsetEmrCommentEmfPlusDataEnd = -1;
    private int fileOffsetEmrCommentEmfPlusEnd = -1;
    private int nrOfEMFRecords = 0;
    private final List<EMFPlusObject> objectTable = new ArrayList<EMFPlusObject>(32);
    private final Map<EMFPlusObject, EMFPlusObject> canonicalEmfObjects;
    private TransformationAffiliate currentWorldToDriverTransformation;

    public DeviceDriverEMF() {
        int i = 0;
        while (i < 32) {
            this.objectTable.add(null);
            ++i;
        }
        this.canonicalEmfObjects = new HashMap<EMFPlusObject, EMFPlusObject>();
        this.currentWorldToDriverTransformation = WORLD_TO_DRIVER_BASIS;
    }

    @Override
    public Rectangle calculateTotalDrawingAreaInDriverCoordinates(Rectangle totalDrawingArea) {
        Dimension drawingDimensionInMM;
        Point totalDrawingAreaUpperLeftInMM;
        if (totalDrawingArea == null) {
            totalDrawingAreaUpperLeftInMM = Point.ORIGIN;
            drawingDimensionInMM = new Dimension(1.0, 1.0);
        } else {
            totalDrawingAreaUpperLeftInMM = totalDrawingArea.upperLeft;
            drawingDimensionInMM = totalDrawingArea.getDimension();
        }
        double metafileUnitsPerMM = 3.937007874015748;
        Point totalDrawingAreaUpperLeftInMetafileUnits = new Point(new GeoVector(totalDrawingAreaUpperLeftInMM).scale(metafileUnitsPerMM));
        Dimension dimensionInMetafileUnits = new Dimension(drawingDimensionInMM.width * metafileUnitsPerMM, drawingDimensionInMM.height * metafileUnitsPerMM);
        Rectangle sizeInMetafileUnits = new Rectangle(totalDrawingAreaUpperLeftInMetafileUnits.x, totalDrawingAreaUpperLeftInMetafileUnits.y, dimensionInMetafileUnits);
        return sizeInMetafileUnits;
    }

    @Override
    public IDeviceDriver startPage(TransformationAffiliate mmToDriverCoordinates, Rectangle pageSizeInDriverCoordinates) {
        this.buffer = null;
        this.byteArrayOutputStream.reset();
        this.writeEMRHeader(pageSizeInDriverCoordinates);
        this.writeEMRCommentEMFPlusStart();
        this.writeInitialEMFPlusRecords(pageSizeInDriverCoordinates);
        return this;
    }

    @Override
    public void endPage(IDeviceDriver deviceDriver) {
        this.writeTerminatingEMFPlusRecords();
        this.writeEMRCommentEMFPlusEnd();
        this.writeEMREOF();
        this.buffer = this.byteArrayOutputStream.toByteArray();
        this.patchHeader();
    }

    @Override
    public void saveImageDirectly(OutputStream targetStream) throws PrintingFailure, EXEmptyResult {
        block14: {
            if (this.buffer != null) {
                try {
                    boolean noWriteErrorOccured = false;
                    try {
                        targetStream.write(this.buffer);
                        targetStream.flush();
                        noWriteErrorOccured = true;
                        break block14;
                    }
                    finally {
                        if (noWriteErrorOccured) {
                            targetStream.close();
                        } else {
                            try {
                                targetStream.close();
                            }
                            catch (Exception e) {
                                logger.debug("Problem wile closing Image File stream (probably caused by a previous error)", (Throwable)e);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new PrintingFailure(e);
                }
            }
            try {
                targetStream.close();
            }
            catch (Exception e) {
                logger.debug("Problem wile closing Image File stream", (Throwable)e);
            }
            throw new EXEmptyResult();
        }
    }

    private void writeEMRHeader(Rectangle pageSizeInMetafileUnits) {
        double inchesPerMetafileUnit = 0.01;
        double mmPerMetafileUnit = 25.4 * inchesPerMetafileUnit;
        double pointOZeroMMPerMetafileUnit = mmPerMetafileUnit * 100.0;
        double umPerMetafileUnit = mmPerMetafileUnit * 1000.0;
        Rectangle pageSizeInPointOZeroMM = pageSizeInMetafileUnits.scale(pointOZeroMMPerMetafileUnit);
        Rectangle pageSizeInPixels = pageSizeInMetafileUnits.scale(1.0);
        Rectangle pageSizeInMM = pageSizeInMetafileUnits.scale(mmPerMetafileUnit);
        Rectangle pageSizeInum = pageSizeInMetafileUnits.scale(umPerMetafileUnit);
        this.writeInt32(1);
        this.writeInt32(108);
        this.writeRectLInclusiveInclusive(pageSizeInMetafileUnits);
        this.writeRectLInclusiveInclusive(pageSizeInPointOZeroMM);
        this.writeInt32(1179469088);
        this.writeInt32(65536);
        this.fileOffsetHeaderBytes = this.sampleFileOffset();
        this.writeInt32(0);
        this.fileOffsetHeaderNrOfRecords = this.sampleFileOffset();
        this.writeInt32(0);
        this.fileOffsetHeaderNrOfObjects = this.sampleFileOffset();
        this.writeInt16(0);
        this.writeInt16(0);
        this.writeInt32(0);
        this.writeInt32(0);
        this.writeInt32(0);
        this.writeSizeL(pageSizeInPixels.getDimension());
        this.writeSizeL(pageSizeInMM.getDimension());
        this.writeInt32(0);
        this.writeInt32(0);
        this.writeInt32(0);
        this.writeSizeL(pageSizeInum.getDimension());
        ++this.nrOfEMFRecords;
    }

    private void writeEMRCommentEMFPlusStart() {
        this.fileOffsetEmrCommentEmfPlusBegin = this.sampleFileOffset();
        this.writeInt32(70);
        this.fileOffsetEmrCommentEmfPlusSize = this.sampleFileOffset();
        this.writeInt32(0);
        this.fileOffsetEmrCommentEmfPlusDataSize = this.sampleFileOffset();
        this.writeInt32(0);
        this.fileOffsetEmrCommentEmfPlusDataBegin = this.sampleFileOffset();
        this.writeInt32(726027589);
    }

    private void writeEMRCommentEMFPlusEnd() {
        this.fileOffsetEmrCommentEmfPlusDataEnd = this.sampleFileOffset();
        this.writePaddingTo32Bit();
        this.fileOffsetEmrCommentEmfPlusEnd = this.sampleFileOffset();
        ++this.nrOfEMFRecords;
    }

    private void writeEMREOF() {
        this.writeInt32(14);
        this.writeInt32(20);
        this.writeInt32(0);
        this.writeInt32(16);
        this.writeInt32(20);
        ++this.nrOfEMFRecords;
    }

    private void patchHeader() {
        this.patchInt32(this.fileOffsetHeaderBytes, this.buffer.length);
        this.patchInt32(this.fileOffsetHeaderNrOfRecords, this.nrOfEMFRecords);
        this.patchInt16(this.fileOffsetHeaderNrOfObjects, 32);
        this.patchInt32(this.fileOffsetEmrCommentEmfPlusSize, this.fileOffsetEmrCommentEmfPlusEnd - this.fileOffsetEmrCommentEmfPlusBegin);
        this.patchInt32(this.fileOffsetEmrCommentEmfPlusDataSize, this.fileOffsetEmrCommentEmfPlusDataEnd - this.fileOffsetEmrCommentEmfPlusDataBegin);
    }

    private void writeInitialEMFPlusRecords(Rectangle pageSizeInDriverCoordinates) {
        this.writeEMFPlusHeader();
        this.writeEMFPlusSetWorldTransform(this.currentWorldToDriverTransformation);
        this.writeEMFPlusClear();
        this.writeEMFPlusSetAntiAliasMode(2);
        this.writeEMFPlusSetCompositionMode(0);
        this.writeEMFPlusSetCompositingQuality(3);
        this.writeEMFPlusSetInterpolationMode(2);
        this.writeEMFPlusSetPixelOffstMode(2);
        this.writeEMFPlusSetRenderingOrigin(pageSizeInDriverCoordinates.upperLeft);
        this.writeEMFPlusSetTextRenderingHint(4);
        this.writeEMFPlusSave(0);
    }

    private void writeTerminatingEMFPlusRecords() {
        this.writeEMFPlusRestore(0);
        this.writeEMFPlusEOF();
    }

    private void writeEMFPlusHeader() {
        Data32BitInteger recordingFlags = new Data32BitInteger(0);
        double pixelsPerInch = 100.0;
        Data32BitInteger resolutionDPI = new Data32BitInteger(pixelsPerInch);
        this.writeEMFPlusRecord(16385, 0, new Data[]{this.EMFPLUS_GRAPHICS_VERSION, recordingFlags, resolutionDPI, resolutionDPI});
    }

    private void writeEMFPlusSetWorldTransform(TransformationAffiliate mmToDriverCoordinates) {
        Data32BitFloat m11 = new Data32BitFloat(mmToDriverCoordinates.getM11());
        Data32BitFloat m21 = new Data32BitFloat(mmToDriverCoordinates.getM12());
        Data32BitFloat m12 = new Data32BitFloat(mmToDriverCoordinates.getM21());
        Data32BitFloat m22 = new Data32BitFloat(mmToDriverCoordinates.getM22());
        Data32BitFloat dx = new Data32BitFloat(mmToDriverCoordinates.getDx());
        Data32BitFloat dy = new Data32BitFloat(mmToDriverCoordinates.getDy());
        this.writeEMFPlusRecord(16426, 0, new Data[]{m11, m12, m21, m22, dx, dy});
    }

    private void writeEMFPlusClear() {
        this.writeEMFPlusRecord(16388, 0, new Data[]{this.EMFPLUS_COLOR_TRANSPARENT});
    }

    private void writeEMFPlusSetAntiAliasMode(int mode) {
        this.writeEMFPlusRecord(16414, mode << 1 | (mode == 0 ? 0 : 1), new Data[0]);
    }

    private void writeEMFPlusSetCompositionMode(int mode) {
        this.writeEMFPlusRecord(16419, mode, new Data[0]);
    }

    private void writeEMFPlusSetCompositingQuality(int mode) {
        this.writeEMFPlusRecord(16420, mode, new Data[0]);
    }

    private void writeEMFPlusSetInterpolationMode(int mode) {
        this.writeEMFPlusRecord(16417, mode, new Data[0]);
    }

    private void writeEMFPlusSetPixelOffstMode(int mode) {
        this.writeEMFPlusRecord(16418, mode, new Data[0]);
    }

    private void writeEMFPlusSetRenderingOrigin(Point origin) {
        this.writeEMFPlusRecord(16413, 0, new Data[]{new DataPoint32BitInteger(origin)});
    }

    private void writeEMFPlusSetTextRenderingHint(int mode) {
        this.writeEMFPlusRecord(16415, mode, new Data[0]);
    }

    private void writeEMFPlusSave(int stackIndex) {
        this.writeEMFPlusRecord(16421, 0, new Data[]{new Data32BitInteger(stackIndex)});
    }

    private void writeEMFPlusRestore(int stackIndex) {
        this.writeEMFPlusRecord(16422, 0, new Data[]{new Data32BitInteger(stackIndex)});
    }

    private void writeEMFPlusEOF() {
        this.writeEMFPlusRecord(16386, 0, new Data[0]);
    }

    private void writeEMFPlusRecord(int type, int flags, Data[] datas) {
        this.writeInt16(type);
        this.writeInt16(flags);
        int unpaddedDataSize = 0;
        Data[] dataArray = datas;
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            Data data = dataArray[n2];
            unpaddedDataSize += data.size();
            ++n2;
        }
        int dataSize = DeviceDriverEMF.alignSizeTo32Bit(unpaddedDataSize);
        int unpaddedSize = dataSize + 12;
        int size = DeviceDriverEMF.alignSizeTo32Bit(unpaddedSize);
        this.writeInt32(size);
        this.writeInt32(dataSize);
        Data[] dataArray2 = datas;
        int n3 = datas.length;
        int n4 = 0;
        while (n4 < n3) {
            Data data = dataArray2[n4];
            data.write();
            ++n4;
        }
        this.writePaddingBytes(dataSize - unpaddedDataSize);
        this.writePaddingBytes(size - unpaddedSize);
    }

    private void writePaddingTo32Bit() {
        int offset = this.sampleFileOffset();
        while (offset % 4 != 0) {
            this.writePaddingByte();
            offset = this.sampleFileOffset();
        }
    }

    private static int alignSizeTo32Bit(int size) {
        int aligned = size;
        while (aligned % 4 != 0) {
            ++aligned;
        }
        return aligned;
    }

    private void writePaddingBytes(int nr) {
        int i = 0;
        while (i < nr) {
            this.writePaddingByte();
            ++i;
        }
    }

    private void writePaddingByte() {
        this.writeByte((byte)0);
    }

    private void writeBytes(byte[] data) {
        try {
            this.byteArrayOutputStream.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeByte(int int8) {
        this.writeByte((byte)int8);
    }

    private void writeByte(byte int8) {
        this.byteArrayOutputStream.write(int8);
    }

    private void writeInt16(int int16) {
        this.byteArrayOutputStream.write(DeviceDriverEMF.getByte(int16, 1));
        this.byteArrayOutputStream.write(DeviceDriverEMF.getByte(int16, 2));
    }

    private void writeInt32(int int32) {
        this.byteArrayOutputStream.write(DeviceDriverEMF.getByte(int32, 1));
        this.byteArrayOutputStream.write(DeviceDriverEMF.getByte(int32, 2));
        this.byteArrayOutputStream.write(DeviceDriverEMF.getByte(int32, 3));
        this.byteArrayOutputStream.write(DeviceDriverEMF.getByte(int32, 4));
    }

    private void writeFloat32(double float32) {
        int floatAsInt = Float.floatToIntBits((float)float32);
        this.writeInt32(floatAsInt);
    }

    private void writeRectLInclusiveInclusive(Rectangle rectangle) {
        int left = DeviceDriverEMF.fitToInt32(rectangle.upperLeft.x);
        int top = DeviceDriverEMF.fitToInt32(rectangle.upperLeft.y);
        int right = DeviceDriverEMF.fitToInt32(rectangle.lowerRight.x);
        int bottom = DeviceDriverEMF.fitToInt32(rectangle.lowerRight.y);
        this.writeInt32(left);
        this.writeInt32(top);
        this.writeInt32(right);
        this.writeInt32(bottom);
    }

    private void writeSizeL(Dimension dimension) {
        int w = DeviceDriverEMF.fitToInt32(dimension.width);
        int h = DeviceDriverEMF.fitToInt32(dimension.height);
        this.writeInt32(w);
        this.writeInt32(h);
    }

    private void writeRectF(Rectangle rectangle) {
        this.writeFloat32(rectangle.upperLeft.x);
        this.writeFloat32(rectangle.upperLeft.y);
        this.writeFloat32(rectangle.w());
        this.writeFloat32(rectangle.h());
    }

    private void patchInt32(int offset, int patchValue) {
        this.buffer[offset + 0] = DeviceDriverEMF.getByte(patchValue, 1);
        this.buffer[offset + 1] = DeviceDriverEMF.getByte(patchValue, 2);
        this.buffer[offset + 2] = DeviceDriverEMF.getByte(patchValue, 3);
        this.buffer[offset + 3] = DeviceDriverEMF.getByte(patchValue, 4);
    }

    private void patchInt16(int offset, int patchValue) {
        this.buffer[offset + 0] = DeviceDriverEMF.getByte(patchValue, 1);
        this.buffer[offset + 1] = DeviceDriverEMF.getByte(patchValue, 2);
    }

    private static int fitToInt32(double d) {
        return (int)Math.min(Math.max(Math.round(d), Integer.MIN_VALUE), Integer.MAX_VALUE);
    }

    private int sampleFileOffset() {
        return this.byteArrayOutputStream.size();
    }

    private static byte getByte(int integer, int bytenumber) {
        switch (bytenumber) {
            case 1: {
                return (byte)(integer & 0xFF);
            }
            case 2: {
                return (byte)(integer >> 8 & 0xFF);
            }
            case 3: {
                return (byte)(integer >> 16 & 0xFF);
            }
            case 4: {
                return (byte)(integer >> 24 & 0xFF);
            }
        }
        return 0;
    }

    private void emfPlusObject(EMFPlusObject emfObject) {
        int objectID = emfObject.getTableIndex();
        if (objectID >= 0) {
            int type = emfObject.getType();
            int flags = type << 8 | objectID;
            Data[] data = emfObject.getData();
            this.writeEMFPlusRecord(16392, flags, data);
        }
    }

    private void resolve(EMFPlusObject nonCanonicalObject, IResolved resolved) {
        int tableIndex;
        EMFPlusObject canonicalObject = this.canonicalEmfObjects.get(nonCanonicalObject);
        if (canonicalObject == null) {
            canonicalObject = nonCanonicalObject;
            this.canonicalEmfObjects.put(canonicalObject, canonicalObject);
        }
        if ((tableIndex = canonicalObject.getTableIndex()) < 0) {
            int minUsageCount = Integer.MAX_VALUE;
            int tableIndexToUse = 0;
            int i = 0;
            while (i < 32) {
                int currentUsageCount;
                EMFPlusObject currentObject = this.objectTable.get(i);
                int n = currentUsageCount = currentObject == null ? Integer.MIN_VALUE : currentObject.getUsageCounter();
                if (currentUsageCount < minUsageCount) {
                    tableIndexToUse = i;
                    minUsageCount = currentUsageCount;
                }
                ++i;
            }
            EMFPlusObject currentObject = this.objectTable.get(tableIndexToUse);
            if (currentObject != null) {
                currentObject.setTableIndex(-1);
                this.canonicalEmfObjects.remove(currentObject);
            }
            this.objectTable.set(tableIndexToUse, canonicalObject);
            canonicalObject.setTableIndex(tableIndexToUse);
            this.emfPlusObject(canonicalObject);
        }
        int i = 0;
        while (i < 32) {
            EMFPlusObject currentObject;
            if (i != canonicalObject.getTableIndex() && (currentObject = this.objectTable.get(i)) != null) {
                currentObject.downrate();
            }
            ++i;
        }
        canonicalObject.use(resolved);
    }

    private void getIndexOfCurrentPen(IResolved resolved) {
        int width = (int)this.getLineWidth();
        Color color = this.getLineColor();
        EMFPlusPen uncanonicalObject = new EMFPlusPen(width, color);
        this.resolve(uncanonicalObject, resolved);
    }

    private void getIndexOfCurrentImageAttributesObject(IResolved resolved) {
        EMFPlusImageAttributes uncanonicalObject = new EMFPlusImageAttributes();
        this.resolve(uncanonicalObject, resolved);
    }

    private void getIndexOfCurrentStringFormat(IResolved resolved) {
        int alingment = this.getTextAlignment();
        EMFPlusStringFormat uncanonicalObject = new EMFPlusStringFormat(alingment);
        this.resolve(uncanonicalObject, resolved);
    }

    private void getIndexOfCurrentFont(IResolved resolved) {
        double emSize = this.getTextAscent() - this.getTextDescent();
        boolean isBold = this.isTextBold();
        boolean isItalic = this.isTextItalic();
        boolean isUnderlined = false;
        boolean isStrikedThrough = false;
        String familyName = this.getTextFontName();
        EMFPlusFont uncanonicalObject = new EMFPlusFont(emSize, isBold, isItalic, isUnderlined, isStrikedThrough, familyName);
        this.resolve(uncanonicalObject, resolved);
    }

    private void getIndexForImageObject(byte[] imageFileData, IResolved resolved) {
        EMFPlusImageObject uncanonicalObject = new EMFPlusImageObject(imageFileData);
        this.resolve(uncanonicalObject, resolved);
    }

    @Override
    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        if (optionalTransformation != null) {
            this.withTransformation(optionalTransformation, runnable);
        } else {
            runnable.run();
        }
    }

    private <T extends Throwable> void withTransformation(TransformationAffiliate transformation, IDeviceRunnable<T> runnable) throws T {
        TransformationAffiliate resultingTrafo;
        TransformationAffiliate currentTrafo = this.currentWorldToDriverTransformation;
        this.currentWorldToDriverTransformation = resultingTrafo = transformation.transform(currentTrafo);
        this.writeEMFPlusSetWorldTransform(resultingTrafo);
        try {
            runnable.run();
        }
        finally {
            this.writeEMFPlusSetWorldTransform(currentTrafo);
            this.currentWorldToDriverTransformation = currentTrafo;
        }
    }

    private void emfPlusDrawLines(final Points points) {
        this.getIndexOfCurrentPen(new IResolved(){

            @Override
            public void resolved(int indexOfPenObject) {
                Data[] datas = new Data[1 + points.size()];
                datas[0] = new Data32BitInteger(points.size());
                int i = 0;
                while (i < points.size()) {
                    datas[i + 1] = new DataPoint32BitFloat(points.get(i));
                    ++i;
                }
                int flags = indexOfPenObject;
                DeviceDriverEMF.this.writeEMFPlusRecord(16397, flags, datas);
            }
        });
    }

    private void emfPlusDrawFillPolygon(Points points) {
        Data[] datas = new Data[2 + points.size()];
        datas[0] = new DataEMFPlusARGB(this.getFillColor(), this.getFillAlpha());
        datas[1] = new Data32BitInteger(points.size());
        int i = 0;
        while (i < points.size()) {
            datas[i + 2] = new DataPoint32BitFloat(points.get(i));
            ++i;
        }
        this.writeEMFPlusRecord(16396, 32768, datas);
    }

    private void emfPlusDrawString(final String text, final Rectangle layoutRect) {
        this.getIndexOfCurrentFont(new IResolved(){

            @Override
            public void resolved(final int indexOfFontObject) {
                DeviceDriverEMF.this.getIndexOfCurrentStringFormat(new IResolved(){

                    @Override
                    public void resolved(int indexOfCurrentStringFormat) {
                        int flags = 0x8000 | indexOfFontObject;
                        DataEMFPlusARGB textColor = new DataEMFPlusARGB(DeviceDriverEMF.this.getTextColor());
                        Data32BitInteger indexOfFormatObject = new Data32BitInteger(indexOfCurrentStringFormat);
                        Data32BitInteger length = new Data32BitInteger(text.length());
                        DataEMFPlusRectF layoutRectData = new DataEMFPlusRectF(layoutRect);
                        DataUnicodeString textData = new DataUnicodeString(text);
                        DeviceDriverEMF.this.writeEMFPlusRecord(16412, flags, new Data[]{textColor, indexOfFormatObject, length, layoutRectData, textData});
                    }
                });
            }
        });
    }

    private void emfPlusDrawImage(final int indexOfImageObject, final Dimension sizeOfImageInPixels, final Rectangle destinationRectangle) {
        this.getIndexOfCurrentImageAttributesObject(new IResolved(){

            @Override
            public void resolved(int indexOfImageAttributesObject) {
                int flags = indexOfImageObject;
                Data32BitInteger indexOfImageAttributesObjectAsData = new Data32BitInteger(indexOfImageAttributesObject);
                Data32BitInteger sourceUnitType = new Data32BitInteger(2);
                Rectangle sourceRectInPixels = new Rectangle(0.0, 0.0, sizeOfImageInPixels.width - 1.0, sizeOfImageInPixels.height - 1.0);
                DataEMFPlusRectF sourceRectData = new DataEMFPlusRectF(sourceRectInPixels);
                DataEMFPlusRectF destRectData = new DataEMFPlusRectF(destinationRectangle);
                DeviceDriverEMF.this.writeEMFPlusRecord(16410, flags, new Data[]{indexOfImageAttributesObjectAsData, sourceUnitType, sourceRectData, destRectData});
            }
        });
    }

    @Override
    protected void fillPoints(Points points) {
        this.emfPlusDrawFillPolygon(points);
    }

    @Override
    public void plot(Point point) {
        Points points = new Points();
        points.add(point);
        points.add(point.movePoint(GeoVector.GeoVector_1_0));
        this.emfPlusDrawLines(points);
    }

    @Override
    public void line(Line line) {
        Points points = new Points();
        points.add(line.start);
        points.add(line.end);
        this.emfPlusDrawLines(points);
    }

    @Override
    public void arc(Arc arc) {
        Points points = arc.getPointsApproximated(50, 1.0);
        if (points.size() == 1) {
            points.add(points.get(0));
        }
        this.emfPlusDrawLines(points);
    }

    @Override
    public void skipPlot(Point point) {
    }

    @Override
    public void skipLine(Line line) {
    }

    @Override
    public void skipArc(Arc arc) {
    }

    @Override
    public boolean isNotInterestedInRealTextDrawing() {
        return false;
    }

    @Override
    public void text(Point p, double textLength, String text, TurnedRectangle clippingHint) {
        GeoVector pToBaseRight;
        GeoVector pToBaseLeft;
        GeoVector baseLineToTop = new GeoVector(0.0, -this.getTextTop());
        GeoVector baseLineToBottom = GeoVector.add(baseLineToTop, new GeoVector(0.0, this.getTextLineHeight() + 1.0));
        GeoVector baseLineVector = new GeoVector(textLength + 1.0, 0.0);
        int alignment = this.getTextAlignment();
        if (alignment == 1) {
            pToBaseLeft = GeoVector.NULL;
            pToBaseRight = baseLineVector;
        } else if (alignment == 4) {
            pToBaseLeft = baseLineVector.turn180();
            pToBaseRight = GeoVector.NULL;
        } else {
            pToBaseRight = baseLineVector.scale(0.5);
            pToBaseLeft = pToBaseRight.turn180();
        }
        Point baselineLeft = p.movePoint(pToBaseLeft);
        Point baselineRight = p.movePoint(pToBaseRight);
        Point upperLeft = baselineLeft.movePoint(baseLineToTop);
        Point lowerRight = baselineRight.movePoint(baseLineToBottom);
        Rectangle layoutRect = new Rectangle(upperLeft, lowerRight);
        double angle = this.getTextDirection().getAngle();
        TransformationAffiliate trafo = TransformationAffiliate.newTransformationRotation(p, angle);
        trafo.addLast(this.currentWorldToDriverTransformation);
        this.writeEMFPlusSetWorldTransform(trafo);
        this.emfPlusDrawString(text, layoutRect);
        this.writeEMFPlusSetWorldTransform(this.currentWorldToDriverTransformation);
    }

    @Override
    public boolean supportsNullImage() {
        return false;
    }

    @Override
    public void drawImage(IOffscreenBitmap offscreenBitmap, int sourceX, int sourceY, int sourceW, int sourceH, TurnedRectangle turnedScaleToRectangle, int alpha) {
        try {
            Image imageToDraw;
            double ppm = 2834.645669291339;
            IRenderer renderer = offscreenBitmap.getRenderer();
            Image baseImage = Image.wrapImage(offscreenBitmap, ppm, ppm);
            if (alpha == 255) {
                imageToDraw = baseImage;
            } else {
                double toTransparent = 1.0 - (double)alpha / 255.0;
                imageToDraw = renderer.createTransparentImage(baseImage, toTransparent);
            }
            try {
                ImageFileType imageFileType = ImageCoDec.determineFileType(imageToDraw.isLossyImage());
                byte[] pngOrJpgFileData = imageToDraw.getOffscreenBitmap().getOptionalPngOrJpgFileData();
                if (pngOrJpgFileData == null) {
                    pngOrJpgFileData = ImageCoDec.encodeIntoByteArray(imageToDraw, imageFileType);
                }
                final Dimension sizeOfImageInPixels = new Dimension(imageToDraw.getWidthInPixels(), imageToDraw.getHeightInPixels());
                Point center = turnedScaleToRectangle.getCenter();
                Dimension dimension = turnedScaleToRectangle.getDimension();
                Direction direction = turnedScaleToRectangle.getDirection();
                double angle = direction.getAngle();
                final Rectangle destinationRectangle = new Rectangle(center, dimension);
                TransformationAffiliate trafo = TransformationAffiliate.newTransformationRotation(center, angle);
                trafo.addLast(this.currentWorldToDriverTransformation);
                this.writeEMFPlusSetWorldTransform(trafo);
                this.getIndexForImageObject(pngOrJpgFileData, new IResolved(){

                    @Override
                    public void resolved(int indexOfImageObject) {
                        DeviceDriverEMF.this.emfPlusDrawImage(indexOfImageObject, sizeOfImageInPixels, destinationRectangle);
                    }
                });
                this.writeEMFPlusSetWorldTransform(this.currentWorldToDriverTransformation);
            }
            finally {
                if (baseImage != imageToDraw) {
                    imageToDraw.dispose();
                }
            }
        }
        catch (EXNoMoreHandles e) {
            logger.error((Throwable)e);
        }
        catch (EXImageTooBig e) {
            logger.error((Throwable)e);
        }
    }

    @Override
    public boolean driverSupportsTransformationForSubElements() {
        return true;
    }

    private abstract class Data {
        private Data() {
        }

        public abstract int size();

        public abstract void write();
    }

    private class Data16BitInteger
    extends Data {
        private final int data;

        public Data16BitInteger(int data) {
            this.data = data;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void write() {
            DeviceDriverEMF.this.writeInt16(this.data);
        }
    }

    private class Data32BitFloat
    extends Data {
        private final double data;

        public Data32BitFloat(double data) {
            this.data = data;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public void write() {
            DeviceDriverEMF.this.writeFloat32(this.data);
        }
    }

    private class Data32BitInteger
    extends Data {
        private final int data;

        public Data32BitInteger(int data) {
            this.data = data;
        }

        public Data32BitInteger(double data) {
            this.data = (int)Math.round(data);
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public void write() {
            DeviceDriverEMF.this.writeInt32(this.data);
        }
    }

    private class DataByteArray
    extends Data {
        private final byte[] data;

        public DataByteArray(byte[] data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.length;
        }

        @Override
        public void write() {
            DeviceDriverEMF.this.writeBytes(this.data);
        }
    }

    private class DataEMFPlusARGB
    extends Data {
        private final Color color;
        private final int fillAlpha;

        public DataEMFPlusARGB(Color color, int fillAlpha) {
            this.color = color;
            this.fillAlpha = fillAlpha;
        }

        public DataEMFPlusARGB(Color color) {
            this.color = color;
            this.fillAlpha = color.transparent ? 0 : 255;
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public void write() {
            DeviceDriverEMF.this.writeByte(this.color.b);
            DeviceDriverEMF.this.writeByte(this.color.g);
            DeviceDriverEMF.this.writeByte(this.color.r);
            DeviceDriverEMF.this.writeByte(this.fillAlpha);
        }
    }

    private class DataEMFPlusRectF
    extends Data {
        private final Rectangle rect;

        public DataEMFPlusRectF(Rectangle rect) {
            this.rect = rect;
        }

        @Override
        public int size() {
            return 16;
        }

        @Override
        public void write() {
            DeviceDriverEMF.this.writeRectF(this.rect);
        }
    }

    private class DataPoint32BitFloat
    extends Data {
        private final Point data;

        public DataPoint32BitFloat(Point data) {
            this.data = data;
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public void write() {
            DeviceDriverEMF.this.writeFloat32(this.data.x);
            DeviceDriverEMF.this.writeFloat32(this.data.y);
        }
    }

    private class DataPoint32BitInteger
    extends Data {
        private final Point data;

        public DataPoint32BitInteger(Point data) {
            this.data = data;
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public void write() {
            int x = DeviceDriverEMF.fitToInt32(this.data.x);
            int y = DeviceDriverEMF.fitToInt32(this.data.y);
            DeviceDriverEMF.this.writeInt32(x);
            DeviceDriverEMF.this.writeInt32(y);
        }
    }

    private class DataUnicodeString
    extends Data {
        private final String string;

        public DataUnicodeString(String string) {
            this.string = string;
        }

        @Override
        public int size() {
            return 2 * this.string.length();
        }

        @Override
        public void write() {
            int i = 0;
            while (i < this.string.length()) {
                char c = this.string.charAt(i);
                DeviceDriverEMF.this.writeInt16(c);
                ++i;
            }
        }
    }

    private class EMFPlusFont
    extends EMFPlusObject {
        private final double emSize;
        private final boolean isBold;
        private final boolean isItalic;
        private final boolean isUnderlined;
        private final boolean isStrikedThrough;
        private final String familyName;

        private EMFPlusFont(double emSize, boolean isBold, boolean isItalic, boolean isUnderlined, boolean isStrikedThrough, String familyName) {
            this.emSize = emSize;
            this.isBold = isBold;
            this.isItalic = isItalic;
            this.isUnderlined = isUnderlined;
            this.isStrikedThrough = isStrikedThrough;
            this.familyName = familyName;
        }

        @Override
        public int getType() {
            return 6;
        }

        @Override
        public Data[] getData() {
            Data32BitFloat emSizeData = new Data32BitFloat(this.emSize);
            Data32BitInteger sizeUnit = new Data32BitInteger(0);
            Data32BitInteger fontStyleFlags = new Data32BitInteger((this.isBold ? 1 : 0) | (this.isItalic ? 2 : 0) | (this.isUnderlined ? 4 : 0) | (this.isStrikedThrough ? 8 : 0));
            Data32BitInteger reserved = new Data32BitInteger(0);
            Data32BitInteger length = new Data32BitInteger(this.familyName.length());
            DataUnicodeString familyNameData = new DataUnicodeString(this.familyName);
            return new Data[]{DeviceDriverEMF.this.EMFPLUS_GRAPHICS_VERSION, emSizeData, sizeUnit, fontStyleFlags, reserved, length, familyNameData};
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + new Double(this.emSize).hashCode();
            result = 31 * result + (this.isBold ? 1234 : 4321);
            result = 31 * result + (this.isItalic ? 2345 : 5432);
            result = 31 * result + (this.isUnderlined ? 4567 : 7654);
            result = 31 * result + (this.isStrikedThrough ? 3456 : 6543);
            result = 31 * result + (this.familyName == null ? 0 : this.familyName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EMFPlusFont other = (EMFPlusFont)obj;
            if (this.emSize != other.emSize) {
                return false;
            }
            if (this.isBold != other.isBold) {
                return false;
            }
            if (this.isItalic != other.isItalic) {
                return false;
            }
            if (this.isUnderlined != other.isUnderlined) {
                return false;
            }
            if (this.isStrikedThrough != other.isStrikedThrough) {
                return false;
            }
            return !(this.familyName == null ? other.familyName != null : !this.familyName.equals(other.familyName));
        }
    }

    private class EMFPlusImageAttributes
    extends EMFPlusObject {
        private EMFPlusImageAttributes() {
        }

        @Override
        public int getType() {
            return 8;
        }

        @Override
        public Data[] getData() {
            Data32BitInteger reserved1 = new Data32BitInteger(0);
            Data32BitInteger wrapMode = new Data32BitInteger(4);
            DataEMFPlusARGB clampColor = new DataEMFPlusARGB(Color.TRANSPARENT);
            Data32BitInteger objectClamp = new Data32BitInteger(0);
            Data32BitInteger reserved2 = new Data32BitInteger(0);
            return new Data[]{DeviceDriverEMF.this.EMFPLUS_GRAPHICS_VERSION, reserved1, wrapMode, clampColor, objectClamp, reserved2};
        }

        public int hashCode() {
            int result = 1;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return this.getClass() == obj.getClass();
        }
    }

    private class EMFPlusImageObject
    extends EMFPlusObject {
        private final long crc64;
        private final int hashCode;
        private byte[] imageFileData;

        private EMFPlusImageObject(byte[] imageFileData) {
            assert (imageFileData != null);
            this.imageFileData = imageFileData;
            this.crc64 = CRC64.calculateCRC64FromBytes((byte[])imageFileData);
            this.hashCode = Long.valueOf(this.crc64).hashCode();
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public Data[] getData() {
            assert (this.imageFileData != null);
            Data32BitInteger dataType = new Data32BitInteger(1);
            Data32BitInteger width = new Data32BitInteger(0);
            Data32BitInteger height = new Data32BitInteger(0);
            Data32BitInteger stride = new Data32BitInteger(0);
            Data32BitInteger pixelFormat = new Data32BitInteger(0);
            Data32BitInteger bitmapType = new Data32BitInteger(1);
            DataByteArray imageFileDatas = new DataByteArray(this.imageFileData);
            this.imageFileData = null;
            return new Data[]{DeviceDriverEMF.this.EMFPLUS_GRAPHICS_VERSION, dataType, width, height, stride, pixelFormat, bitmapType, imageFileDatas};
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EMFPlusImageObject other = (EMFPlusImageObject)obj;
            return this.crc64 == other.crc64;
        }
    }

    private abstract class EMFPlusObject {
        private static final int UPRATE = 32;
        private int usageCounter = 0;
        private int tableIndex = -1;

        public int getUsageCounter() {
            return this.usageCounter;
        }

        public void downrate() {
            this.usageCounter = this.usageCounter == Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.usageCounter == 0 ? 0 : this.usageCounter - 1);
        }

        public void use(IResolved resolved) {
            int newUsageCounter = this.usageCounter >= 0x7FFFFFDF ? Integer.MAX_VALUE : this.usageCounter + 32;
            try {
                this.usageCounter = Integer.MAX_VALUE;
                resolved.resolved(this.tableIndex);
            }
            finally {
                this.usageCounter = newUsageCounter;
            }
        }

        public int getTableIndex() {
            return this.tableIndex;
        }

        public void setTableIndex(int tableIndex) {
            this.tableIndex = tableIndex;
        }

        public abstract int getType();

        public abstract Data[] getData();
    }

    private class EMFPlusPen
    extends EMFPlusObject {
        private final int width;
        private final Color color;

        private EMFPlusPen(int width, Color color) {
            this.width = width;
            this.color = color;
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public Data[] getData() {
            Data32BitInteger penType = new Data32BitInteger(0);
            Data32BitInteger penDataFlags = new Data32BitInteger(6);
            Data32BitInteger penUnit = new Data32BitInteger(0);
            Data32BitFloat penWidth = new Data32BitFloat(this.width);
            Data32BitInteger lineCApTypeRound = new Data32BitInteger(2);
            Data32BitInteger brushType = new Data32BitInteger(0);
            DataEMFPlusARGB brushColor = new DataEMFPlusARGB(this.color);
            return new Data[]{DeviceDriverEMF.this.EMFPLUS_GRAPHICS_VERSION, penType, penDataFlags, penUnit, penWidth, lineCApTypeRound, lineCApTypeRound, DeviceDriverEMF.this.EMFPLUS_GRAPHICS_VERSION, brushType, brushColor};
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.color == null ? 0 : this.color.hashCodeEqualsColor());
            result = 31 * result + this.width;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EMFPlusPen other = (EMFPlusPen)obj;
            if (this.color == null ? other.color != null : !this.color.equalsColor(other.color)) {
                return false;
            }
            return this.width == other.width;
        }
    }

    private class EMFPlusStringFormat
    extends EMFPlusObject {
        private static final int FLAG_NO_FIT_BLACK_BOX = 4;
        private static final int FLAG_NO_WRAP = 4096;
        private static final int FLAG_LINE_LIMIT = 8192;
        private static final int FLAG_NO_CLIP = 16384;
        private static final int LANGUAGE_IDENTIFIER = 9;
        private static final int ALIGNMENT_NEAR = 0;
        private static final int ALIGNMENT_CENTER = 1;
        private static final int ALIGNMENT_FAR = 2;
        private static final int DIGIT_SUBSTITUTION_NONE = 1;
        private static final double FIRST_TAB_OFFSET = 0.0;
        private static final int HOTKEY_PREFIX_NONE = 0;
        private static final double LEADING_MARGIN = 0.0;
        private static final double TRAILING_MARGIN = 0.0;
        private static final double TRACKING = 1.0;
        private static final int STRING_TRIMMING_NONE = 0;
        private final int alignment;

        private EMFPlusStringFormat(int alignment) {
            this.alignment = alignment;
        }

        @Override
        public int getType() {
            return 7;
        }

        @Override
        public Data[] getData() {
            Data32BitInteger stringFormatFlags = new Data32BitInteger(28676);
            Data32BitInteger languageIdentifier = new Data32BitInteger(9);
            Data32BitInteger stringAlignment = this.alignment == 1 ? new Data32BitInteger(0) : (this.alignment == 4 ? new Data32BitInteger(2) : new Data32BitInteger(1));
            Data32BitInteger lineAlignment = new Data32BitInteger(0);
            Data32BitInteger digitSubstituation = new Data32BitInteger(1);
            Data32BitFloat firstTabOffset = new Data32BitFloat(0.0);
            Data32BitInteger hotKeyPrefix = new Data32BitInteger(0);
            Data32BitFloat leadingMargin = new Data32BitFloat(0.0);
            Data32BitFloat trailingMargin = new Data32BitFloat(0.0);
            Data32BitFloat tracking = new Data32BitFloat(1.0);
            Data32BitInteger trimming = new Data32BitInteger(0);
            Data32BitInteger tabStopCount = new Data32BitInteger(0);
            Data32BitInteger rangeCount = new Data32BitInteger(0);
            return new Data[]{DeviceDriverEMF.this.EMFPLUS_GRAPHICS_VERSION, stringFormatFlags, languageIdentifier, stringAlignment, lineAlignment, digitSubstituation, languageIdentifier, firstTabOffset, hotKeyPrefix, leadingMargin, trailingMargin, tracking, trimming, tabStopCount, rangeCount};
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.alignment;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EMFPlusStringFormat other = (EMFPlusStringFormat)obj;
            return this.alignment == other.alignment;
        }
    }

    private static interface IResolved {
        public void resolved(int var1);
    }
}

