/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics.devicedrivers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

public class AnalyzeWMFFile {
    private static final Map<Integer, String> ENUM_METAFILE_TYPE = new TreeMap<Integer, String>();
    private static final Map<Integer, String> ENUM_METAFILE_ESCAPES;
    private static final Map<Integer, String> ENUM_BRUSH_STYLE;
    private static final Map<Integer, String> ENUM_COLOR_USAGE;
    private static final Map<Integer, String> ENUM_METAFILE_VERSION;
    private static final Map<Integer, String> ENUM_TERNARY_RASTER_OPERATION;
    private static final Map<Integer, String> ENUM_RECORD_TYPE;
    private static final char[] HEX_ARRAY;

    static {
        AnalyzeWMFFile.add(ENUM_METAFILE_TYPE, "MEMORYMETAFILE", 1);
        AnalyzeWMFFile.add(ENUM_METAFILE_TYPE, "DISKMETAFILE", 2);
        ENUM_METAFILE_ESCAPES = new TreeMap<Integer, String>();
        AnalyzeWMFFile.add(ENUM_METAFILE_ESCAPES, "META_ESCAPE_ENHANCED_METAFILE", 15);
        ENUM_BRUSH_STYLE = new TreeMap<Integer, String>();
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_SOLID", 0);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_NULL", 1);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_HATCHED", 2);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_PATTERN", 3);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_INDEXED", 4);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_DIBPATTERN", 5);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_DIBPATTERNPT", 6);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_PATTERN8X8", 7);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_DIBPATTERN8X8", 8);
        AnalyzeWMFFile.add(ENUM_BRUSH_STYLE, "BS_MONOPATTERN", 9);
        ENUM_COLOR_USAGE = new TreeMap<Integer, String>();
        AnalyzeWMFFile.add(ENUM_COLOR_USAGE, "DIB_RGB_COLORS", 0);
        AnalyzeWMFFile.add(ENUM_COLOR_USAGE, "DIB_PAL_COLORS", 1);
        AnalyzeWMFFile.add(ENUM_COLOR_USAGE, "DIB_PAL_INDICES", 2);
        ENUM_METAFILE_VERSION = new TreeMap<Integer, String>();
        AnalyzeWMFFile.add(ENUM_METAFILE_VERSION, "METAVERSION100", 256);
        AnalyzeWMFFile.add(ENUM_METAFILE_VERSION, "METAVERSION300", 768);
        ENUM_TERNARY_RASTER_OPERATION = new TreeMap<Integer, String>();
        AnalyzeWMFFile.add(ENUM_TERNARY_RASTER_OPERATION, "PSDPXAXN", 71);
        AnalyzeWMFFile.add(ENUM_TERNARY_RASTER_OPERATION, "PDSPDAOXXN", 73);
        AnalyzeWMFFile.add(ENUM_TERNARY_RASTER_OPERATION, "PATINVERT", 90);
        ENUM_RECORD_TYPE = new TreeMap<Integer, String>();
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_EOF", 0);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_REALIZEPALETTE", 53);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETPALENTRIES", 55);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETBKMODE", 258);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETMAPMODE", 259);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETROP2", 260);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETRELABS", 261);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETPOLYFILLMODE", 262);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETSTRETCHBLTMODE", 263);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETTEXTCHAREXTRA", 264);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_RESTOREDC", 295);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_RESIZEPALETTE", 313);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_DIBCREATEPATTERNBRUSH", 322);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETLAYOUT", 329);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETBKCOLOR", 513);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETTEXTCOLOR", 521);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_OFFSETVIEWPORTORG", 529);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_LINETO", 531);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_MOVETO", 532);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_OFFSETCLIPRGN", 544);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_FILLREGION", 552);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETMAPPERFLAGS", 561);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SELECTPALETTE", 564);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_POLYGON", 804);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_POLYLINE", 805);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETTEXTJUSTIFICATION", 522);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETWINDOWORG", 523);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETWINDOWEXT", 524);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETVIEWPORTORG", 525);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETVIEWPORTEXT", 526);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_OFFSETWINDOWORG", 527);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SCALEWINDOWEXT", 1040);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SCALEVIEWPORTEXT", 1042);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_EXCLUDECLIPRECT", 1045);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_INTERSECTCLIPRECT", 1046);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_ELLIPSE", 1048);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_FLOODFILL", 1049);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_FRAMEREGION", 1065);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_ANIMATEPALETTE", 1078);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_TEXTOUT", 1313);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_POLYPOLYGON", 1336);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_EXTFLOODFILL", 1352);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_RECTANGLE", 1051);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETPIXEL", 1055);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_ROUNDRECT", 1564);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_PATBLT", 1565);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SAVEDC", 30);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_PIE", 2074);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_STRETCHBLT", 2851);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_ESCAPE", 1574);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_INVERTREGION", 298);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_PAINTREGION", 299);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SELECTCLIPREGION", 300);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SELECTOBJECT", 301);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETTEXTALIGN", 302);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_ARC", 2071);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_CHORD", 2096);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_BITBLT", 2338);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_EXTTEXTOUT", 2610);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_SETDIBTODEV", 3379);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_DIBBITBLT", 2368);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_DIBSTRETCHBLT", 2881);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_STRETCHDIB", 3907);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_DELETEOBJECT", 496);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_CREATEPALETTE", 247);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_CREATEPATTERNBRUSH", 505);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_CREATEPENINDIRECT", 762);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_CREATEFONTINDIRECT", 763);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_CREATEBRUSHINDIRECT", 764);
        AnalyzeWMFFile.addLowByte(ENUM_RECORD_TYPE, "META_CREATEREGION", 1791);
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }

    private static void add(Map<Integer, String> map, String name, int value) {
        map.put(value, name);
    }

    private static void addLowByte(Map<Integer, String> map, String name, int value) {
        int lowByte = value & 0xFF;
        if (map.containsKey(lowByte)) {
            throw new IllegalArgumentException(name);
        }
        map.put(lowByte, name);
    }

    public static void main(String[] args) throws IOException {
        AnalyzeWMFFile.title("transparentPPT");
        FileInputStream is = new FileInputStream("D:\\transparentPPT.wmf");
        AnalyzeWMFFile.dumpWMFFile(is);
        System.out.println();
        AnalyzeWMFFile.title("transparentAC");
        is = new FileInputStream("D:\\transparentAC.wmf");
        AnalyzeWMFFile.dumpWMFFile(is);
    }

    private static void dumpWMFFile(FileInputStream is) throws IOException {
        ByteArrayOutputStream embeddedEMFData = new ByteArrayOutputStream();
        AnalyzeWMFFile.title("META_PLACEABLE");
        AnalyzeWMFFile.read4ByteHex("Key", is);
        AnalyzeWMFFile.read2ByteHex("HWmf", is);
        AnalyzeWMFFile.readRectangle("BoundingBox", is);
        AnalyzeWMFFile.readCardValue("Inch", is);
        AnalyzeWMFFile.read4ByteHex("Reserved", is);
        AnalyzeWMFFile.readCardValue("Checksum", is);
        AnalyzeWMFFile.title("META_HEADER");
        AnalyzeWMFFile.readEnum("Type", ENUM_METAFILE_TYPE, is);
        int headerSize = AnalyzeWMFFile.readCardValue("HeaderSize", is);
        AnalyzeWMFFile.readEnum("Version", ENUM_METAFILE_VERSION, is);
        AnalyzeWMFFile.read4ByteValue("Size", is);
        AnalyzeWMFFile.readCardValue("NumberOfObjects", is);
        AnalyzeWMFFile.read4ByteValue("MaxRecord", is);
        AnalyzeWMFFile.readCardValue("NumberOfMembers", is);
        headerSize -= 9;
        while (headerSize > 0) {
            AnalyzeWMFFile.readCardValue("Unknown", is);
            --headerSize;
        }
        int functionNumer = AnalyzeWMFFile.readRecord(is, embeddedEMFData);
        while (functionNumer != 0) {
            functionNumer = AnalyzeWMFFile.readRecord(is, embeddedEMFData);
        }
        is.close();
        byte[] embeddedEMFDataBytes = embeddedEMFData.toByteArray();
        ByteArrayInputStream embeddedEMFDataIS = new ByteArrayInputStream(embeddedEMFDataBytes);
        AnalyzeWMFFile.readEmbeddedEMFData(embeddedEMFDataIS);
    }

    private static void readEmbeddedEMFData(InputStream is) throws IOException {
        int c = is.read();
        if (c != -1) {
            System.out.println();
            AnalyzeWMFFile.title("Embedded EMF File");
            int count = 0;
            while (c != -1) {
                if (c >= 0 && c < 32) {
                    System.out.print(".");
                } else {
                    char cr = (char)c;
                    System.out.print(cr);
                }
                c = is.read();
                if (++count % 64 != 0) continue;
                System.out.println();
            }
            System.out.println();
        }
        is.close();
    }

    private static void title(String title) {
        System.out.println();
        System.out.println(title);
        int i = 0;
        while (i < title.length()) {
            System.out.print("=");
            ++i;
        }
        System.out.println();
    }

    private static int readRecord(InputStream is, ByteArrayOutputStream embeddedEMFData) throws IOException {
        int recordSize = AnalyzeWMFFile.readLongValue(is);
        int recordFunction = AnalyzeWMFFile.readCardValue(is);
        int functionNumber = recordFunction & 0xFF;
        int subfunction = recordFunction >>> 8 & 0xFF;
        String function = AnalyzeWMFFile.resolve(ENUM_RECORD_TYPE, functionNumber);
        System.out.print(String.valueOf(function) + " (Size " + (recordSize -= 3) + ", Sub Function " + subfunction + ")");
        if (recordSize > 0) {
            System.out.print(":");
            InputStream recordData = AnalyzeWMFFile.readSubData(is, recordSize * 2);
            if ("META_ESCAPE".equals(function)) {
                System.out.println();
                AnalyzeWMFFile.readRecordMetaEscape(recordData, embeddedEMFData);
            } else if ("META_DIBCREATEPATTERNBRUSH".equals(function)) {
                System.out.println();
                AnalyzeWMFFile.readRecordDibCreatePatternBrush(recordData);
            } else if ("META_DIBBITBLT".equals(function)) {
                System.out.println();
                AnalyzeWMFFile.readRecordDibBitBlt(subfunction, recordData);
            } else if ("META_SETWINDOWEXT".equals(function)) {
                System.out.println();
                int bottom = AnalyzeWMFFile.readWordValue(recordData);
                int right = AnalyzeWMFFile.readWordValue(recordData);
                int top = 0;
                int left = 0;
                AnalyzeWMFFile.writeRect(left, top, right, bottom);
            } else if ("META_INTERSECTCLIPRECT".equals(function)) {
                System.out.println();
                AnalyzeWMFFile.writeRectangleBRTL(recordData);
            } else if ("META_POLYGON".equals(function)) {
                int nrPoints = AnalyzeWMFFile.readCardValue(recordData);
                AnalyzeWMFFile.writePoints(nrPoints, recordData);
            } else {
                System.out.print(" ");
                AnalyzeWMFFile.readCardArray(recordSize, recordData);
                System.out.println();
            }
        } else {
            System.out.println();
        }
        return functionNumber;
    }

    private static void writePoints(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            AnalyzeWMFFile.writePoint(AnalyzeWMFFile.readWordValue(is), AnalyzeWMFFile.readWordValue(is));
            ++i;
        }
    }

    private static void writeRectangleBRTL(InputStream recordData) throws IOException {
        int bottom = AnalyzeWMFFile.readWordValue(recordData);
        int right = AnalyzeWMFFile.readWordValue(recordData);
        int top = AnalyzeWMFFile.readWordValue(recordData);
        int left = AnalyzeWMFFile.readWordValue(recordData);
        AnalyzeWMFFile.writeRectangleLTRB(new int[]{left, top, right, bottom});
    }

    private static void readRecordDibBitBlt(int subFunction, InputStream is) throws IOException {
        int rest = is.available() / 2;
        boolean containsImage = subFunction != rest;
        AnalyzeWMFFile.readEnum(" |- Raster Operation", ENUM_TERNARY_RASTER_OPERATION, is);
        byte[] index = new byte[1];
        is.read(index);
        System.out.println(" |- Raster Operation Operation Index Low:  " + AnalyzeWMFFile.bytesToBin(index));
        is.read(index);
        System.out.println(" |- Raster Operation Operation Index High: " + AnalyzeWMFFile.bytesToBin(index));
        int ySrc = AnalyzeWMFFile.readWordValue(is);
        int xSrc = AnalyzeWMFFile.readWordValue(is);
        if (!containsImage) {
            AnalyzeWMFFile.readCardValue(" |- Reserved", is);
        }
        int height = AnalyzeWMFFile.readWordValue(is);
        int width = AnalyzeWMFFile.readWordValue(is);
        int yDest = AnalyzeWMFFile.readWordValue(is);
        int xDest = AnalyzeWMFFile.readWordValue(is);
        byte[] data = AnalyzeWMFFile.flush(is);
        if (data.length != 0) {
            AnalyzeWMFFile.dump(" '- Data", data);
        }
        AnalyzeWMFFile.writeRect(xSrc, ySrc, xSrc + width, ySrc + height);
        AnalyzeWMFFile.writeRect(xDest, yDest, xDest + width, yDest + height);
    }

    private static void dump(String title, byte[] bytes) {
        System.out.println(String.valueOf(title) + ": " + AnalyzeWMFFile.bytesToHex(bytes));
    }

    private static void readRecordDibCreatePatternBrush(InputStream is) throws IOException {
        int brushStyleNumber = AnalyzeWMFFile.readCardValue(is);
        String brushStyle = AnalyzeWMFFile.resolve(ENUM_BRUSH_STYLE, brushStyleNumber);
        System.out.println(" |- Brush Sytle: " + brushStyle);
        int colorUsageNumber = AnalyzeWMFFile.readCardValue(is);
        if (brushStyle.contains("DIB")) {
            String colorUsage = AnalyzeWMFFile.resolve(ENUM_COLOR_USAGE, colorUsageNumber);
            System.out.println(" |- ColorUsage: " + colorUsage);
            System.out.println(" '- Target:");
            InputStream dibIs = AnalyzeWMFFile.readSubData(is);
            AnalyzeWMFFile.readDIB(dibIs, colorUsage.equals("DIB_PAL_INDICES"));
        } else {
            System.out.println(" |- ColorUsage: " + colorUsageNumber);
            byte[] data = AnalyzeWMFFile.flush(is);
            System.out.println(" '- Target: 0x" + AnalyzeWMFFile.bytesToHex(data));
        }
    }

    private static void readDIB(InputStream is, boolean withPalette) throws IOException {
        int step;
        int end;
        int start;
        int bitCount;
        int planes;
        int height;
        int width;
        int headerSize = AnalyzeWMFFile.read4ByteValue("     |- Header Size", is);
        if (headerSize == 12) {
            width = AnalyzeWMFFile.readWordValue("     |- Width", is);
            height = AnalyzeWMFFile.readWordValue("     |- Height", is);
            planes = AnalyzeWMFFile.readCardValue("     |- Planes", is);
            bitCount = AnalyzeWMFFile.readCardValue("     '- Bit Count", is);
            headerSize -= 12;
        } else {
            width = AnalyzeWMFFile.read4ByteValue("     |- Width", is);
            height = AnalyzeWMFFile.read4ByteValue("     |- Height", is);
            planes = AnalyzeWMFFile.readCardValue("     |- Planes", is);
            bitCount = AnalyzeWMFFile.readCardValue("     |- Bit Count", is);
            AnalyzeWMFFile.read4ByteValue("     |- Compression", is);
            AnalyzeWMFFile.read4ByteValue("     |- Image Size", is);
            AnalyzeWMFFile.read4ByteValue("     |- X Pixels Per Meter", is);
            AnalyzeWMFFile.read4ByteValue("     |- Y Pixels Per Meter", is);
            AnalyzeWMFFile.read4ByteValue("     |- Color Used", is);
            AnalyzeWMFFile.read4ByteValue("     |- Color Important", is);
            headerSize -= 40;
        }
        while (headerSize > 0) {
            is.read();
            --headerSize;
        }
        if (withPalette) {
            throw new UnsupportedOperationException();
        }
        byte[] data = new byte[4];
        int colors = 1 << planes;
        int c = 0;
        while (c < colors) {
            is.read(data);
            System.out.println("     |- Color " + c + ": 0x" + AnalyzeWMFFile.bytesToHex(data));
            ++c;
        }
        int lineSize = (width * planes * bitCount + 31 & 0xFFFFFFE0) / 8;
        if (height > 0) {
            start = 0;
            end = height - 1;
            step = 1;
        } else {
            start = -height - 1;
            end = 0;
            step = -1;
        }
        data = new byte[lineSize];
        int line = start;
        while (line != end + step) {
            is.read(data);
            if (line == end) {
                System.out.println("     '- Line " + line + ": " + AnalyzeWMFFile.bytesToBin(data));
            } else {
                System.out.println("     |- Line " + line + ": " + AnalyzeWMFFile.bytesToBin(data));
            }
            line += step;
        }
        data = AnalyzeWMFFile.flush(is);
        if (data.length > 0) {
            System.out.println("     '- Rest: 0x" + AnalyzeWMFFile.bytesToBin(data));
        }
    }

    private static void readRecordMetaEscape(InputStream is, ByteArrayOutputStream embeddedEMFData) throws IOException {
        int escapeFunctionNumber = AnalyzeWMFFile.readCardValue(is);
        String escapeFunction = AnalyzeWMFFile.resolve(ENUM_METAFILE_ESCAPES, escapeFunctionNumber);
        int byteCount = AnalyzeWMFFile.readCardValue(is);
        System.out.println(" '- " + escapeFunction + " (" + byteCount + " Bytes)");
        InputStream subData = AnalyzeWMFFile.readSubData(is, byteCount);
        if ("META_ESCAPE_ENHANCED_METAFILE".equals(escapeFunction)) {
            AnalyzeWMFFile.readRecordMetaEscapeEnhancedMetafile(subData, embeddedEMFData);
        } else {
            AnalyzeWMFFile.readByteArray("     '- Data: ", byteCount, subData);
        }
    }

    private static void readRecordMetaEscapeEnhancedMetafile(InputStream is, ByteArrayOutputStream embeddedEMFData) throws IOException {
        AnalyzeWMFFile.read4ByteHex("     |- Comment Identifier: ", is);
        AnalyzeWMFFile.read4ByteHex("     |- Comment Type: ", is);
        AnalyzeWMFFile.read4ByteHex("     |- Version: ", is);
        AnalyzeWMFFile.read2ByteHex("     |- Checksum: ", is);
        AnalyzeWMFFile.read4ByteHex("     |- Flags: ", is);
        AnalyzeWMFFile.read4ByteValue("     |- Comment Record Count: ", is);
        AnalyzeWMFFile.read4ByteValue("     |- Current Record Size: ", is);
        AnalyzeWMFFile.read4ByteValue("     |- Remaining Bytes: ", is);
        int enhancedMetafileDataSize = AnalyzeWMFFile.read4ByteValue("     '- Enhanced Metafile Data Size: ", is);
        byte[] data = new byte[enhancedMetafileDataSize];
        is.read(data);
        embeddedEMFData.write(data);
    }

    private static InputStream readSubData(InputStream is, int byteCount) throws IOException {
        byte[] data = new byte[byteCount];
        is.read(data);
        return new ByteArrayInputStream(data);
    }

    private static InputStream wordIS(int[] ints) {
        byte[] data = new byte[ints.length * 2];
        int off = 0;
        int i = 0;
        while (i < ints.length) {
            data[off] = (byte)(i % 255);
            data[off + 1] = (byte)(i >> 8);
            off += 2;
            ++i;
        }
        return new ByteArrayInputStream(data);
    }

    private static void read4ByteMagicAsASCII(InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        is.read(bytes);
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] >= 0 && bytes[i] < 32) {
                bytes[i] = 46;
            }
            ++i;
        }
        String s = new String(bytes, "ISO-8859-1");
        System.out.println("Magic: " + s);
    }

    private static void readEnum(String title, Map<Integer, String> map, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeWMFFile.readCardValue(is);
        String name = AnalyzeWMFFile.resolve(map, value);
        System.out.println(name);
    }

    private static void read4BytesEnum(String title, Map<Integer, String> map, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeWMFFile.readLongValue(is);
        String name = AnalyzeWMFFile.resolve(map, value);
        System.out.println(name);
    }

    private static String resolve(Map<Integer, String> map, int value) {
        String name = map.get(value);
        if (name == null) {
            name = "0x" + Integer.toHexString(value);
        }
        return name;
    }

    private static int read2ByteHex(String title, InputStream is) throws IOException {
        byte[] bytes = new byte[2];
        bytes[1] = (byte)is.read();
        bytes[0] = (byte)is.read();
        System.out.println(String.valueOf(title) + ": 0x" + AnalyzeWMFFile.bytesToHex(bytes));
        return bytes[0] + 256 * bytes[1];
    }

    private static void read4ByteHex(String title, InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        bytes[3] = (byte)is.read();
        bytes[2] = (byte)is.read();
        bytes[1] = (byte)is.read();
        bytes[0] = (byte)is.read();
        System.out.println(String.valueOf(title) + ": 0x" + AnalyzeWMFFile.bytesToHex(bytes));
    }

    private static void readWordArray(String title, int count, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        AnalyzeWMFFile.readWordArray(count, is);
        System.out.println();
    }

    private static void readCardArray(String title, int count, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        AnalyzeWMFFile.readCardArray(count, is);
        System.out.println();
    }

    private static void readCardArray(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            if (i > 0) {
                System.out.print(",");
            }
            int value = AnalyzeWMFFile.readCardValue(is);
            System.out.print(value);
            ++i;
        }
    }

    private static void readWordArray(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            if (i > 0) {
                System.out.print(",");
            }
            int value = AnalyzeWMFFile.readWordValue(is);
            System.out.print(value);
            ++i;
        }
    }

    private static int[] readRectangle(String title, InputStream is) throws IOException {
        System.out.println(String.valueOf(title) + ":");
        int[] rect = AnalyzeWMFFile.readRectangle(is);
        AnalyzeWMFFile.writeRectangleLTRB(rect);
        return rect;
    }

    private static void writeRectangleLTRB(int[] rect) {
        AnalyzeWMFFile.writeRect(rect[0], rect[1], rect[2], rect[3]);
    }

    private static void writeRect(int x1, int y1, int x2, int y2) {
        AnalyzeWMFFile.writePoint(x1, y1);
        AnalyzeWMFFile.writePoint(x2, y1);
        AnalyzeWMFFile.writePoint(x2, y2);
        AnalyzeWMFFile.writePoint(x1, y2);
        AnalyzeWMFFile.writePoint(x1, y1);
    }

    private static void writePoint(int x, int y) {
        System.out.println("\t" + x + "\t" + y);
    }

    private static int[] readRectangle(InputStream is) throws IOException {
        int[] rect = new int[4];
        int i = 0;
        while (i < 4) {
            rect[i] = AnalyzeWMFFile.readWordValue(is);
            ++i;
        }
        return rect;
    }

    private static void readByteArray(String title, int count, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        AnalyzeWMFFile.readByteArray(count, is);
        System.out.println();
    }

    private static void readByteArray(int count, InputStream is) throws IOException {
        int i = 0;
        while (i < count) {
            if (i > 0) {
                System.out.print(",");
            }
            int value = AnalyzeWMFFile.readByteValue(is);
            System.out.print(value);
            ++i;
        }
    }

    private static int readLongValue(InputStream is) throws IOException {
        int value = (int)((long)AnalyzeWMFFile.readCardValue(is) + 65536L * (long)AnalyzeWMFFile.readCardValue(is));
        return value;
    }

    private static int readWordValue(InputStream is) throws IOException {
        int value = AnalyzeWMFFile.readCardValue(is);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    private static int readCardValue(InputStream is) throws IOException {
        int value = AnalyzeWMFFile.readByteValue(is) + 256 * AnalyzeWMFFile.readByteValue(is);
        return value;
    }

    private static int readByteValue(InputStream is) throws IOException {
        int value = is.read();
        return value;
    }

    private static int readWordValue(String title, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeWMFFile.readWordValue(is);
        System.out.print(value);
        System.out.println();
        return value;
    }

    private static int readCardValue(String title, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeWMFFile.readCardValue(is);
        System.out.print(value);
        System.out.println();
        return value;
    }

    private static int read4ByteValue(String title, InputStream is) throws IOException {
        System.out.print(String.valueOf(title) + ": ");
        int value = AnalyzeWMFFile.readLongValue(is);
        System.out.print(value);
        System.out.println();
        return value;
    }

    private static String bytesToBin(byte[] bytes) {
        String s = "";
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            s = String.valueOf(s) + String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
            ++i;
        }
        return s;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    private static InputStream readSubData(InputStream is) throws IOException {
        byte[] data = AnalyzeWMFFile.flush(is);
        ByteArrayInputStream subData = new ByteArrayInputStream(data);
        return subData;
    }

    private static byte[] flush(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int i = is.read();
        while (i != -1) {
            os.write(i);
            i = is.read();
        }
        is.close();
        byte[] data = os.toByteArray();
        os.close();
        return data;
    }
}

