/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.graphics;

public class Color {
    public static final Color TRANSPARENT = new Color(0, 0, 0, true);
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color GRAY = new Color(128, 128, 150);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color RED = new Color(255, 64, 64);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color DARKGREEN = new Color(0, 175, 0);
    public static final Color BLUE = new Color(0, 0, 255);
    public static final Color ORANGE = new Color(255, 128, 0);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color LIGHTGRAY = new Color(200, 200, 200);
    public static final Color LIGHTBLUE = new Color(205, 221, 237);
    public static final Color LIGHTYELLOW = new Color(255, 255, 200);
    public static final Color TOOLTIPYELLOW = new Color(255, 255, 220);
    public static final Color DARKBLUE = new Color(0, 0, 127);
    public int r;
    public int g;
    public int b;
    public boolean transparent;

    public static int convertBitDepth(int sourceValue, int sourceBitDepth, int destBitDepth) {
        int destValue;
        if (sourceBitDepth > 0 && destBitDepth > 0) {
            int sourceValues = 1 << sourceBitDepth;
            int destValues = 1 << destBitDepth;
            destValue = sourceValue * (destValues - 1) / (sourceValues - 1);
        } else {
            destValue = 0;
        }
        return destValue;
    }

    public Color(Color color) {
        assert (color != null);
        this.r = color.r;
        this.g = color.g;
        this.b = color.b;
        this.transparent = color.transparent;
    }

    Color(int r, int g, int b, boolean transparent) {
        assert (r >= 0 && r < 256) : "r out of range";
        assert (g >= 0 && g < 256) : "g out of range";
        assert (b >= 0 && b < 256) : "b out of range";
        this.r = r;
        this.g = g;
        this.b = b;
        this.transparent = transparent;
    }

    public Color(int r, int g, int b) {
        assert (r >= 0 && r < 256) : "r out of range";
        assert (g >= 0 && g < 256) : "g out of range";
        assert (b >= 0 && b < 256) : "b out of range";
        this.r = r;
        this.g = g;
        this.b = b;
        this.transparent = false;
    }

    public Color() {
        this.r = 0;
        this.g = 0;
        this.b = 0;
        this.transparent = false;
    }

    public Color getGray() {
        int gray = (this.r + this.g + this.b) / 3;
        return new Color(gray, gray, gray, this.transparent);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isGreyOrTransparent() {
        return this.transparent || this.r == this.g && this.r == this.b;
    }

    public Color gotoWhite(double mixture) {
        return this.goToColor(WHITE, mixture);
    }

    public Color gotoBlack(double mixture) {
        return this.goToColor(BLACK, mixture);
    }

    public Color gotoGray(double mixture) {
        return this.goToColor(this.getGray(), mixture);
    }

    public Color goToColor(Color targetColor, double mixture) {
        return new Color(this.machMichAnnasch(this.r, targetColor.r, mixture), this.machMichAnnasch(this.g, targetColor.g, mixture), this.machMichAnnasch(this.b, targetColor.b, mixture), this.transparent);
    }

    private int machMichAnnasch(int woher, int wohin, double wieWeit) {
        return Math.max(0, Math.min(255, (int)((double)wohin - (double)(wohin - woher) * (1.0 - wieWeit))));
    }

    public boolean equalsColor(Color color) {
        if (this.transparent || color.transparent) {
            return this.transparent == color.transparent;
        }
        return this.r == color.r && this.g == color.g && this.b == color.b;
    }

    public int hashCodeEqualsColor() {
        if (this.transparent) {
            return 1;
        }
        return this.r << 24 ^ this.g << 16 ^ this.b << 8 ^ this.r << 8 ^ this.g;
    }

    @Deprecated
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            return this.equalsColor(color);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        return this.hashCodeEqualsColor();
    }

    public String toString() {
        return String.format("Color(r=%03d,g=%03d,b=%03d,transparent=%s)", this.r, this.g, this.b, Boolean.toString(this.transparent));
    }
}

