/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry.polygon;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.lib.geometry.polygon.PolygonLine;
import com.arcway.lib.geometry.polygon.PolygonProcessor;
import java.util.Arrays;
import java.util.List;

public class Polygon {
    static int DEFAULT_DRAWARC_MAXIMUM_NUMBER_OF_POINTS = 50;
    static double DEFAULT_DRAWARC_POINTS_PER_UNIT = 1.0;
    private static int HITTEST_DRAWARC_MAXIMUM_NUMBER_OF_POINTS = 50;
    private static double HITTEST_DRAWARC_POINTS_PER_UNIT = 0.0;
    private final boolean isClosed;
    private final PolygonCorner[] polygonCorners;
    private final List<PolygonCorner> polygonCornersAsList;
    private PolygonLine[] polygonLines;
    private Direction[] polygonDirections;
    private Line[] cornerPointConnectionLines = null;
    private Points approximatedPolygonCache = null;
    private int approximatedPolygonCacheMaxPoints;
    private double approximatedPolygonCachePointsPerUnit;
    private Points polygonPointsHitTest = null;
    private Transformation polygonPointsHitTestTrafo = null;
    private final Object polygonPointsHitTestSynchronizer = new Object();
    private Polygon transformedPolygonCache = null;
    private Transformation transformedPolygonCacheTransformation = null;

    public Polygon(Corners corners, boolean closedDraw) {
        assert (corners != null) : "corners = null";
        int size = corners.size();
        this.polygonCorners = new PolygonCorner[size];
        this.polygonCornersAsList = Arrays.asList(this.polygonCorners);
        int i = 0;
        while (i < size) {
            Corner baseCorner = corners.getCorner(i);
            this.polygonCorners[i] = new PolygonCorner(baseCorner.x, baseCorner.y);
            ++i;
        }
        this.isClosed = size > 0 ? closedDraw : false;
        this.initializeCornerLinks();
        i = 0;
        while (i < size) {
            double r;
            double rmax;
            PolygonCorner currentCorner = this.polygonCorners[i];
            Corner currentBaseCorner = corners.getCorner(i);
            if (currentCorner.prev != null) {
                rmax = Geo.arcLengthLine(currentCorner.prev.x, currentCorner.prev.y, currentCorner.x, currentCorner.y);
                if (currentCorner.prev.prev != null) {
                    rmax /= 2.0;
                }
                currentCorner.radiusToPrev = currentBaseCorner.radiusInfinity ? rmax : Math.min(currentBaseCorner.radius, rmax);
            }
            if (currentCorner.next != null) {
                rmax = Geo.arcLengthLine(currentCorner.x, currentCorner.y, currentCorner.next.x, currentCorner.next.y);
                if (currentCorner.next.next != null) {
                    rmax /= 2.0;
                }
                currentCorner.radiusToNext = currentBaseCorner.radiusInfinity ? rmax : Math.min(currentBaseCorner.radius, rmax);
            }
            currentCorner.radiusToPrev = r = Math.min(currentCorner.radiusToPrev, currentCorner.radiusToNext);
            currentCorner.radiusToNext = r;
            ++i;
        }
        this.initializePolygonCorners();
        this.initializePolygonLinesAndDirections();
    }

    public Polygon(Polygon polygon, Transformation transformation) {
        int size = polygon.polygonCorners.length;
        this.polygonCorners = new PolygonCorner[size];
        this.polygonCornersAsList = Arrays.asList(this.polygonCorners);
        int i = 0;
        while (i < size) {
            PolygonCorner originalCorner = polygon.polygonCorners[i];
            Point transformedPosition = originalCorner.transform(transformation);
            PolygonCorner transformedCorner = new PolygonCorner(transformedPosition.x, transformedPosition.y);
            if (originalCorner.prev != null) {
                transformedCorner.radiusToPrev = Polygon.transformRadius(originalCorner.radiusToPrev, originalCorner, originalCorner.prev, transformation);
            }
            if (originalCorner.next != null) {
                transformedCorner.radiusToNext = Polygon.transformRadius(originalCorner.radiusToNext, originalCorner, originalCorner.next, transformation);
            }
            this.polygonCorners[i] = transformedCorner;
            ++i;
        }
        this.isClosed = polygon.isClosed;
        this.initializeCornerLinks();
        this.initializePolygonCorners();
        this.initializePolygonLinesAndDirections();
    }

    private static double transformRadius(double originalRadius, Point originalCorner, Point originalCornerPrevOrNext, Transformation transformation) {
        double newRadius;
        if (originalRadius > 1.0E-10) {
            GeoVector originalDirection = new GeoVector(originalCorner, originalCornerPrevOrNext);
            GeoVector originalRadiusVector = originalDirection.scaleToLength(originalRadius);
            Point originalTargetPoint = originalCorner.movePoint(originalRadiusVector);
            Point newCorner = originalCorner.transform(transformation);
            Point newTargetPoint = originalTargetPoint.transform(transformation);
            GeoVector newRadiusVector = new GeoVector(newCorner, newTargetPoint);
            newRadius = newRadiusVector.abs();
        } else {
            newRadius = 0.0;
        }
        return newRadius;
    }

    private void initializeCornerLinks() {
        int size = this.polygonCorners.length;
        if (size > 0) {
            int cornerIdx;
            PolygonCorner predecessorCorner;
            if (this.isClosed) {
                predecessorCorner = this.polygonCorners[size - 1];
                cornerIdx = 0;
            } else {
                predecessorCorner = this.polygonCorners[0];
                cornerIdx = 1;
            }
            while (cornerIdx < size) {
                PolygonCorner currentCorner = this.polygonCorners[cornerIdx];
                currentCorner.prev = predecessorCorner;
                predecessorCorner.next = currentCorner;
                ++cornerIdx;
                predecessorCorner = currentCorner;
            }
        }
    }

    private void initializePolygonCorners() {
        int size = this.polygonCorners.length;
        int i = 0;
        while (i < size) {
            this.polygonCorners[i].initialize();
            ++i;
        }
    }

    private void initializePolygonLinesAndDirections() {
        int endIndex = this.isClosed ? this.polygonCorners.length - 1 : this.polygonCorners.length - 2;
        this.polygonLines = new PolygonLine[Math.max(0, endIndex + 1)];
        int indexOfNonZeroLineForLeedingZeroLines = -1;
        int i = 0;
        while (i <= endIndex) {
            PolygonLine polygonLine;
            PolygonCorner corner1st = this.polygonCorners[i];
            PolygonCorner corner2nd = corner1st.next;
            this.polygonLines[i] = polygonLine = new PolygonLine(corner1st, corner2nd);
            if (!polygonLine.start.equalsPoint(polygonLine.end)) {
                if (this.isClosed) {
                    indexOfNonZeroLineForLeedingZeroLines = i;
                } else if (indexOfNonZeroLineForLeedingZeroLines == -1) {
                    indexOfNonZeroLineForLeedingZeroLines = i;
                }
            }
            ++i;
        }
        if (indexOfNonZeroLineForLeedingZeroLines == -1) {
            this.polygonDirections = null;
        } else {
            PolygonLine nonZeroLineForLeedingZeroLines = this.polygonLines[indexOfNonZeroLineForLeedingZeroLines];
            GeoVector vectorForLeedingZeroLines = new GeoVector(nonZeroLineForLeedingZeroLines.start, nonZeroLineForLeedingZeroLines.end);
            Direction directionOfZeroLines = vectorForLeedingZeroLines.getDirection();
            this.polygonDirections = new Direction[this.polygonLines.length];
            int i2 = 0;
            while (i2 <= endIndex) {
                Direction direction;
                PolygonLine polygonLine = this.polygonLines[i2];
                GeoVector vector = new GeoVector(polygonLine.start, polygonLine.end);
                if (vector.isZero()) {
                    direction = directionOfZeroLines;
                } else {
                    directionOfZeroLines = direction = vector.getDirection();
                }
                this.polygonDirections[i2] = direction;
                ++i2;
            }
        }
    }

    public int getPolygonCornerPointCount() {
        return this.polygonCorners.length;
    }

    public PolygonCorner getPolygonCorner(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.polygonCorners.length) : "index >= getPolygonCornerPointCount()";
        return this.polygonCorners[index];
    }

    public PolygonLine getPolygonLine(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.polygonCorners.length) : "index >= getPolygonCornerPointCount()";
        if (!this.isClosed) assert (index < this.polygonCorners.length - 1) : "index >= getPolygonCornerPointCount()";
        assert (this.polygonLines != null) : "polygon line cache was not setup correctly";
        assert (index < this.polygonLines.length) : "polygon line cache was not setup correctly";
        return this.polygonLines[index];
    }

    public Point getPolygonCornerPoint(int index) {
        assert (index >= 0) : "index < 0";
        assert (index < this.polygonCorners.length) : "index >= getPolygonCornerPointCount()";
        return this.polygonCorners[index];
    }

    public synchronized Polygon getTransformedPolygon(Transformation transformation) {
        assert (transformation != null) : "transformation is null";
        if (transformation.isNOPTransformation()) {
            return this;
        }
        if (this.transformedPolygonCache == null || transformation != this.transformedPolygonCacheTransformation) {
            this.transformedPolygonCache = new Polygon(this, transformation);
            this.transformedPolygonCacheTransformation = transformation;
        }
        return this.transformedPolygonCache;
    }

    public Points getPointsApproximated() {
        return this.getPointsApproximated(DEFAULT_DRAWARC_MAXIMUM_NUMBER_OF_POINTS, DEFAULT_DRAWARC_POINTS_PER_UNIT);
    }

    public synchronized Points getPointsApproximated(int maxPoints, double pointsPerUnit) {
        assert (maxPoints > 0) : "max points not greater 0";
        assert (pointsPerUnit > 0.0) : "points per unit not greater 0";
        if (this.approximatedPolygonCache == null || maxPoints != this.approximatedPolygonCacheMaxPoints || pointsPerUnit != this.approximatedPolygonCachePointsPerUnit) {
            this.approximatedPolygonCache = this.calculatePoints(maxPoints, pointsPerUnit);
            this.approximatedPolygonCacheMaxPoints = maxPoints;
            this.approximatedPolygonCachePointsPerUnit = pointsPerUnit;
        }
        return this.approximatedPolygonCache;
    }

    public boolean hasBeenHit(Point point, double tolerance) {
        return this.hasBeenHit(point, tolerance, Transformation.NOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBeenHit(Point point, double tolerance, Transformation trafo) {
        assert (point != null) : "point is null";
        assert (tolerance > -1.0E-10) : "tolerance is < 0";
        boolean hasBeenHit = false;
        Object object = this.polygonPointsHitTestSynchronizer;
        synchronized (object) {
            this.updatePolygonPointsHitTest(trafo);
            if (this.isClosed) {
                hasBeenHit = this.polygonPointsHitTest.isInside(point);
            }
            if (!hasBeenHit && tolerance > 1.0E-10) {
                hasBeenHit = this.polygonPointsHitTest.isNearBorder(point, tolerance, this.isClosed);
            }
        }
        return hasBeenHit;
    }

    public boolean isNearBorder(Point point, double tolerance) {
        return this.isNearBorder(point, tolerance, Transformation.NOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNearBorder(Point point, double tolerance, Transformation trafo) {
        boolean isNearBorder;
        assert (point != null) : "point is null";
        assert (tolerance > -1.0E-10) : "tolerance is < 0";
        Object object = this.polygonPointsHitTestSynchronizer;
        synchronized (object) {
            this.updatePolygonPointsHitTest(trafo);
            isNearBorder = this.polygonPointsHitTest.isNearBorder(point, tolerance, this.isClosed);
        }
        return isNearBorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDistanceToBorder(Point point) {
        assert (point != null) : "point is null";
        double distance = Double.POSITIVE_INFINITY;
        Object object = this.polygonPointsHitTestSynchronizer;
        synchronized (object) {
            this.updatePolygonPointsHitTest(Transformation.NOP);
            distance = this.polygonPointsHitTest.getDistanceToBorder(point, this.isClosed);
        }
        return distance;
    }

    private void updatePolygonPointsHitTest(Transformation trafo) {
        if (this.polygonPointsHitTest == null || this.polygonPointsHitTestTrafo == null || !this.polygonPointsHitTestTrafo.isEqualTransformation(trafo)) {
            this.polygonPointsHitTest = this.calculatePoints(HITTEST_DRAWARC_MAXIMUM_NUMBER_OF_POINTS, HITTEST_DRAWARC_POINTS_PER_UNIT);
            this.polygonPointsHitTestTrafo = trafo;
        }
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    private Points calculatePoints(int maxPoints, double pointsPerUnit) {
        assert (maxPoints > 0 || pointsPerUnit > 1.0E-10) : "max points not greater 0 OR points ist not greater than 0";
        PointApproximationPolygonProcessor polygonProcessor = new PointApproximationPolygonProcessor(maxPoints, pointsPerUnit);
        this.process(polygonProcessor);
        return polygonProcessor.getPoints();
    }

    public double arcLength() {
        ArcLengthPolygonProcessor polygonProcessor = new ArcLengthPolygonProcessor();
        this.process(polygonProcessor);
        return polygonProcessor.getArcLength();
    }

    public Point point(double arcLength) {
        GoArcLengthPolygonProcessor polygonProcessor = new GoArcLengthPolygonProcessor(arcLength);
        this.process(polygonProcessor);
        return polygonProcessor.getPoint();
    }

    public Rectangle getBounds() {
        OuterBoundsPolygonProcessor polygonProcessor = new OuterBoundsPolygonProcessor();
        this.process(polygonProcessor);
        return polygonProcessor.getOuterBounds();
    }

    public void process(PolygonProcessor polygonProcessor) {
        int size = this.polygonCorners.length;
        polygonProcessor.processInitialize(this);
        if (this.polygonDirections == null) {
            if (size > 0) {
                polygonProcessor.processPoint(this.polygonCorners[0]);
            }
        } else {
            int i = 0;
            while (i < size) {
                Direction enteringLine;
                PolygonCorner currentCorner = this.polygonCorners[i];
                Direction enteringArc = i == 0 ? (this.isClosed ? this.polygonDirections[size - 1] : this.polygonDirections[0]) : this.polygonDirections[i - 1];
                Direction leavingArc = !this.isClosed && i == size - 1 ? this.polygonDirections[size - 2] : this.polygonDirections[i];
                Arc arc = currentCorner.arc;
                if (arc != null) {
                    polygonProcessor.processArc(enteringArc, arc, leavingArc);
                    enteringLine = leavingArc;
                } else {
                    enteringLine = enteringArc;
                }
                PolygonCorner nextCorner = currentCorner.next;
                if (nextCorner != null) {
                    PolygonLine currentLine = this.getPolygonLine(i);
                    Line line = currentLine.line;
                    if (line != null && !line.isZeroLengthLine()) {
                        Arc nextArc = nextCorner.arc;
                        Direction leavingLine = nextArc != null ? leavingArc : (this.isClosed ? (i == size - 1 ? this.polygonDirections[0] : this.polygonDirections[i + 1]) : (i >= size - 2 ? this.polygonDirections[size - 2] : this.polygonDirections[i + 1]));
                        polygonProcessor.processLine(enteringLine, line, leavingLine);
                    }
                }
                ++i;
            }
        }
        polygonProcessor.processFinalize(this);
    }

    public boolean isInside(Polygon innerPolygon) {
        assert (this.polygonCorners.length > 2) : "For a container polygon at least 3 points are necessary";
        if (innerPolygon.polygonCorners.length == 0) {
            return false;
        }
        if (innerPolygon.polygonCorners.length == 1) {
            return Points.isInside(innerPolygon.polygonCorners[0], this.polygonCornersAsList);
        }
        assert (innerPolygon.polygonCorners.length > 1) : "Polygon must have 2 or more points";
        PolygonCorner[] polygonCornerArray = innerPolygon.polygonCorners;
        int n = innerPolygon.polygonCorners.length;
        int n2 = 0;
        while (n2 < n) {
            PolygonCorner actualPoint = polygonCornerArray[n2];
            if (!Points.isInside(actualPoint, this.polygonCornersAsList)) {
                return false;
            }
            ++n2;
        }
        Line[] cornerPointLines = this.getCornerPointConnectionLines();
        Line[] lineArray = innerPolygon.getCornerPointConnectionLines();
        int n3 = lineArray.length;
        n = 0;
        while (n < n3) {
            Line innerPolygonsLine = lineArray[n];
            if (Polygon.lineIntersectionTestForInsidePolygonTest(innerPolygonsLine, cornerPointLines)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean lineIntersectionTestForInsidePolygonTest(Line line, Line[] cornerPointConnectionLines) {
        Line[] lineArray = cornerPointConnectionLines;
        int n = cornerPointConnectionLines.length;
        int n2 = 0;
        while (n2 < n) {
            Line actualLine = lineArray[n2];
            if (actualLine.intersectWithoutTangents(line) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Line[] getCornerPointConnectionLines() {
        if (this.cornerPointConnectionLines == null) {
            int lineCount = this.isClosed ? this.polygonCorners.length : this.polygonCorners.length - 1;
            this.cornerPointConnectionLines = new Line[lineCount];
            int i = 0;
            while (i < lineCount) {
                PolygonCorner corner1st = this.polygonCorners[i];
                PolygonCorner corner2nd = corner1st.next;
                this.cornerPointConnectionLines[i] = new Line(corner1st, corner2nd, true);
                ++i;
            }
        }
        return this.cornerPointConnectionLines;
    }

    private static class ArcLengthPolygonProcessor
    extends PolygonProcessor {
        protected double arcLength = 0.0;

        private ArcLengthPolygonProcessor() {
        }

        public double getArcLength() {
            return this.arcLength;
        }

        @Override
        public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
            this.arcLength += arc.arcLength();
        }

        @Override
        public void processLine(Direction comingFrom, Line line, Direction goingTo) {
            this.arcLength += line.arcLength();
        }

        @Override
        public void processPoint(Point point) {
        }
    }

    private static class GoArcLengthPolygonProcessor
    extends PolygonProcessor {
        protected double arcLengthToGo;
        protected boolean found = false;
        protected Point point = null;

        public GoArcLengthPolygonProcessor(double arcLengthFind) {
            this.arcLengthToGo = arcLengthFind;
        }

        public Point getPoint() {
            return this.point;
        }

        @Override
        public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
            if (!this.found) {
                double arcLength = arc.arcLength();
                if (this.arcLengthToGo <= arcLength + 1.0E-10) {
                    this.point = arc.getPoint(this.arcLengthToGo);
                    this.found = true;
                }
                this.arcLengthToGo -= arcLength;
            }
        }

        @Override
        public void processLine(Direction comingFrom, Line line, Direction goingTo) {
            if (!this.found) {
                double arcLength = line.arcLength();
                if (this.arcLengthToGo <= arcLength + 1.0E-10) {
                    this.point = line.getPoint(this.arcLengthToGo);
                    this.found = true;
                }
                this.arcLengthToGo -= arcLength;
            }
        }

        @Override
        public void processPoint(Point pointToProcess) {
            if (!this.found && this.arcLengthToGo <= 1.0E-10) {
                this.point = pointToProcess;
                this.found = true;
            }
        }
    }

    private static class OuterBoundsPolygonProcessor
    extends PolygonProcessor {
        protected Rectangle outerBounds = null;

        private OuterBoundsPolygonProcessor() {
        }

        public Rectangle getOuterBounds() {
            return this.outerBounds;
        }

        @Override
        public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
            this.addBounds(arc.getBounds());
        }

        @Override
        public void processLine(Direction comingFrom, Line line, Direction goingTo) {
            this.addBounds(line.getBounds());
        }

        @Override
        public void processPoint(Point point) {
            this.addBounds(point.getBounds());
        }

        private void addBounds(Rectangle boundsToAdd) {
            if (boundsToAdd != null) {
                this.outerBounds = this.outerBounds == null ? boundsToAdd : this.outerBounds.union(boundsToAdd);
            }
        }
    }

    private static class PointApproximationPolygonProcessor
    extends PolygonProcessor {
        Points pointList = new Points();
        private final int maxPoints;
        private final double pointsPerUnit;

        public PointApproximationPolygonProcessor(int maxPoints, double pointsPerUnit) {
            this.maxPoints = maxPoints;
            this.pointsPerUnit = pointsPerUnit;
        }

        public Points getPoints() {
            return this.pointList;
        }

        @Override
        public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
            this.pointList.addAllIfDiffersFromLast(arc.getPointsApproximated(this.maxPoints, this.pointsPerUnit));
        }

        @Override
        public void processLine(Direction comingFrom, Line line, Direction goingTo) {
            this.pointList.addPointIfDiffersFromLast(line.start);
            this.pointList.addPointIfDiffersFromLast(line.end);
        }

        @Override
        public void processPoint(Point point) {
            this.pointList.addPointIfDiffersFromLast(Point.getAsPoint(point));
        }

        @Override
        public void processFinalize(Polygon polygon) {
            if (polygon.isClosed() && this.pointList.size() >= 2) {
                this.pointList.remove(this.pointList.size() - 1);
            }
        }
    }
}

