/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TransformationConcatenation
extends Transformation {
    private static final ILogger logger = Logger.getLogger(TransformationConcatenation.class);
    private final List<Transformation> atomicTransformations = new ArrayList<Transformation>();

    public TransformationConcatenation() {
    }

    public TransformationConcatenation(TransformationConcatenation template) {
        for (Transformation trafo : template.atomicTransformations) {
            this.atomicTransformations.add(trafo.getCopy());
        }
    }

    public TransformationConcatenation(Transformation transformation) {
        assert (transformation != null) : "transformation must not be null";
        this.addLast(transformation);
    }

    public void addFirst(Transformation transformation) {
        Transformation firstTrafo;
        assert (transformation != null) : "transformation must not be null";
        Transformation transformation2 = firstTrafo = this.atomicTransformations.size() == 0 ? null : this.atomicTransformations.get(0);
        if (!transformation.isNOPTransformation()) {
            if (transformation instanceof TransformationConcatenation) {
                TransformationConcatenation trafoConcatenation = (TransformationConcatenation)transformation;
                ListIterator<Transformation> i = trafoConcatenation.atomicTransformations.listIterator(trafoConcatenation.atomicTransformations.size());
                while (i.hasPrevious()) {
                    Transformation trafo = i.previous();
                    this.addFirst(trafo);
                }
            } else if (transformation instanceof TransformationAffiliate && firstTrafo != null && firstTrafo instanceof TransformationAffiliate) {
                TransformationAffiliate firstTrafoAffiliate = (TransformationAffiliate)firstTrafo;
                TransformationAffiliate trafoAffiliate = (TransformationAffiliate)transformation;
                firstTrafoAffiliate.addFirst(trafoAffiliate);
                if (firstTrafoAffiliate.isNOPTransformation()) {
                    this.atomicTransformations.remove(0);
                }
            } else {
                this.atomicTransformations.add(0, transformation.getCopy());
            }
        }
    }

    public void addLast(Transformation transformation) {
        Transformation lastTrafo;
        assert (transformation != null) : "transformation must not be null";
        Transformation transformation2 = lastTrafo = this.atomicTransformations.size() == 0 ? null : this.atomicTransformations.get(this.atomicTransformations.size() - 1);
        if (!transformation.isNOPTransformation()) {
            if (transformation instanceof TransformationConcatenation) {
                TransformationConcatenation trafoConcatenation = (TransformationConcatenation)transformation;
                for (Transformation trafo : trafoConcatenation.atomicTransformations) {
                    this.addLast(trafo);
                }
            } else if (transformation instanceof TransformationAffiliate && lastTrafo != null && lastTrafo instanceof TransformationAffiliate) {
                TransformationAffiliate lastTrafoAffiliate = (TransformationAffiliate)lastTrafo;
                TransformationAffiliate trafoAffiliate = (TransformationAffiliate)transformation;
                lastTrafoAffiliate.addLast(trafoAffiliate);
                if (lastTrafoAffiliate.isNOPTransformation()) {
                    this.atomicTransformations.remove(0);
                }
            } else {
                this.atomicTransformations.add(transformation.getCopy());
            }
        }
    }

    @Override
    public boolean isNOPTransformation() {
        return this.atomicTransformations.isEmpty();
    }

    @Override
    public Transformation getInverse() {
        TransformationConcatenation inverse = new TransformationConcatenation();
        for (Transformation atomicTransformation : this.atomicTransformations) {
            inverse.addFirst(atomicTransformation.getInverse());
        }
        return inverse;
    }

    @Override
    public TransformationConcatenation getCopy() {
        return new TransformationConcatenation(this);
    }

    @Override
    protected Point transform(Point p) {
        assert (p != null) : "point must not be null";
        Point transformedPoint = p;
        for (Transformation atomicTransformation : this.atomicTransformations) {
            transformedPoint = atomicTransformation.transform(transformedPoint);
        }
        return transformedPoint;
    }

    public String toString() {
        return "Transformation(atomicTransformations=" + this.atomicTransformations + ")";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformationConcatenation) {
            TransformationConcatenation t = (TransformationConcatenation)obj;
            if (t.atomicTransformations.size() != this.atomicTransformations.size()) {
                return false;
            }
            Iterator<Transformation> i = this.atomicTransformations.iterator();
            Iterator<Transformation> j = t.atomicTransformations.iterator();
            while (i.hasNext() && j.hasNext()) {
                Transformation b;
                Transformation a = i.next();
                if (a.equals(b = j.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        int h = 0;
        for (Transformation t : this.atomicTransformations) {
            h ^= t.hashCode();
        }
        return h;
    }

    @Override
    public boolean isEqualTransformation(Transformation other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.atomicTransformations.size() == 0) {
            return other.isNOPTransformation();
        }
        if (this.atomicTransformations.size() == 1) {
            return this.atomicTransformations.get(0).isEqualTransformation(other);
        }
        if (other instanceof TransformationConcatenation) {
            TransformationConcatenation ot = (TransformationConcatenation)other;
            if (ot.atomicTransformations.size() != this.atomicTransformations.size()) {
                return false;
            }
            int i = 0;
            while (i < this.atomicTransformations.size()) {
                if (!this.atomicTransformations.get(i).isEqualTransformation(ot.atomicTransformations.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }
}

