/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.geometry.TransformationConcatenation;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class TransformationAffiliate
extends Transformation {
    private static final ILogger logger = Logger.getLogger(TransformationAffiliate.class);
    private boolean isNop = true;
    private Concatenation concatenation = null;
    private boolean concatenationIsValid = false;
    private double m11 = 1.0;
    private double m12 = 0.0;
    private double m21 = 0.0;
    private double m22 = 1.0;
    private double dx = 0.0;
    private double dy = 0.0;

    public static TransformationAffiliate newTransformationNOP() {
        return new TransformationAffiliate();
    }

    public static TransformationAffiliate newTransformationTranslation(GeoVector translation) {
        assert (translation != null);
        double m11 = 1.0;
        double m12 = 0.0;
        double m21 = 0.0;
        double m22 = 1.0;
        double dx = translation.x;
        double dy = translation.y;
        return new TransformationAffiliate(m11, m12, m21, m22, dx, dy);
    }

    public static TransformationAffiliate newTransformationScaling(GeoVector scaling) {
        double m11 = scaling.x;
        double m12 = 0.0;
        double m21 = 0.0;
        double m22 = scaling.y;
        double dx = 0.0;
        double dy = 0.0;
        return new TransformationAffiliate(m11, m12, m21, m22, dx, dy);
    }

    public static TransformationAffiliate newTransformationScaling(double scaling) {
        double m11 = scaling;
        double m12 = 0.0;
        double m21 = 0.0;
        double m22 = scaling;
        double dx = 0.0;
        double dy = 0.0;
        return new TransformationAffiliate(m11, m12, m21, m22, dx, dy);
    }

    public static TransformationAffiliate newTransformationRotation(double angle) {
        double cos;
        double rad = -angle * Math.PI / 180.0;
        double sin = Math.sin(rad);
        double m11 = cos = Math.cos(rad);
        double m12 = -sin;
        double m21 = sin;
        double m22 = cos;
        double dx = 0.0;
        double dy = 0.0;
        return new TransformationAffiliate(m11, m12, m21, m22, dx, dy);
    }

    public static TransformationAffiliate newTransformationRotation(Point p, double angle) {
        TransformationAffiliate trafo = TransformationAffiliate.newTransformationNOP();
        GeoVector originToP = new GeoVector(p.x, p.y);
        GeoVector pToOrigin = originToP.turn180();
        trafo.translate(pToOrigin);
        trafo.rotate(angle);
        trafo.translate(originToP);
        return trafo;
    }

    public static TransformationAffiliate newTransformationShear(GeoVector shearing) {
        double m11 = 1.0;
        double m12 = shearing.x;
        double m21 = shearing.y;
        double m22 = 1.0;
        double dx = 0.0;
        double dy = 0.0;
        return new TransformationAffiliate(m11, m12, m21, m22, dx, dy);
    }

    public TransformationAffiliate() {
    }

    public TransformationAffiliate(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.m11 = m11;
        this.m12 = m12;
        this.m21 = m21;
        this.m22 = m22;
        this.dx = dx;
        this.dy = dy;
        this.updateCaches();
    }

    private void updateCaches() {
        this.isNop = Geo.equals(this.m11, 1.0) && Geo.equals(this.m12, 0.0) && Geo.equals(this.m21, 0.0) && Geo.equals(this.m22, 1.0) && Geo.equals(this.dx, 0.0) && Geo.equals(this.dy, 0.0);
        this.concatenation = null;
        this.concatenationIsValid = false;
    }

    public final double getM11() {
        return this.m11;
    }

    public final double getM12() {
        return this.m12;
    }

    public final double getM21() {
        return this.m21;
    }

    public final double getM22() {
        return this.m22;
    }

    public final double getDx() {
        return this.dx;
    }

    public final double getDy() {
        return this.dy;
    }

    @Override
    public final boolean isNOPTransformation() {
        return this.isNop;
    }

    public void translate(GeoVector translation) {
        TransformationAffiliate transformation = TransformationAffiliate.newTransformationTranslation(translation);
        this.addLast(transformation);
    }

    public void scale(GeoVector scaling) {
        TransformationAffiliate transformation = TransformationAffiliate.newTransformationScaling(scaling);
        this.addLast(transformation);
    }

    public void scale(double scaling) {
        TransformationAffiliate transformation = TransformationAffiliate.newTransformationScaling(scaling);
        this.addLast(transformation);
    }

    public void rotate(double angle) {
        TransformationAffiliate transformation = TransformationAffiliate.newTransformationRotation(angle);
        this.addLast(transformation);
    }

    public void shear(GeoVector shearing) {
        TransformationAffiliate transformation = TransformationAffiliate.newTransformationShear(shearing);
        this.addLast(transformation);
    }

    public final TransformationAffiliate transform(TransformationAffiliate transformationAffiliate) {
        TransformationAffiliate resultAffiliate = this.getCopy();
        resultAffiliate.addLast(transformationAffiliate);
        return resultAffiliate;
    }

    @Override
    public final TransformationAffiliate getInverse() {
        double idy;
        double idx;
        double im22;
        double im21;
        double im12;
        double im11;
        double det = this.m11 * this.m22 - this.m12 * this.m21;
        if (Geo.isZero(det)) {
            im11 = 1.0;
            im12 = 0.0;
            im21 = 0.0;
            im22 = 1.0;
            idx = 0.0;
            idy = 0.0;
        } else {
            im11 = this.m22 / det;
            im12 = -this.m12 / det;
            im21 = -this.m21 / det;
            im22 = this.m11 / det;
            idx = (this.m12 * this.dy - this.m22 * this.dx) / det;
            idy = (this.m21 * this.dx - this.m11 * this.dy) / det;
        }
        return new TransformationAffiliate(im11, im12, im21, im22, idx, idy);
    }

    @Override
    public final TransformationAffiliate getCopy() {
        return new TransformationAffiliate(this.m11, this.m12, this.m21, this.m22, this.dx, this.dy);
    }

    @Override
    protected final Point transform(Point p) {
        return new Point(this.m11 * p.x + this.m12 * p.y + this.dx, this.m21 * p.x + this.m22 * p.y + this.dy);
    }

    public final void addFirst(TransformationAffiliate transformation) {
        double fm11 = this.m11;
        double fm12 = this.m12;
        double fm21 = this.m21;
        double fm22 = this.m22;
        double fdx = this.dx;
        double fdy = this.dy;
        double sm11 = transformation.m11;
        double sm12 = transformation.m12;
        double sm21 = transformation.m21;
        double sm22 = transformation.m22;
        double sdx = transformation.dx;
        double sdy = transformation.dy;
        this.m11 = fm11 * sm11 + fm12 * sm21;
        this.m12 = fm11 * sm12 + fm12 * sm22;
        this.m21 = fm21 * sm11 + fm22 * sm21;
        this.m22 = fm21 * sm12 + fm22 * sm22;
        this.dx = fm11 * sdx + fm12 * sdy + fdx;
        this.dy = fm21 * sdx + fm22 * sdy + fdy;
        this.updateCaches();
    }

    public final void addLast(TransformationAffiliate transformation) {
        double fm11 = transformation.m11;
        double fm12 = transformation.m12;
        double fm21 = transformation.m21;
        double fm22 = transformation.m22;
        double fdx = transformation.dx;
        double fdy = transformation.dy;
        double sm11 = this.m11;
        double sm12 = this.m12;
        double sm21 = this.m21;
        double sm22 = this.m22;
        double sdx = this.dx;
        double sdy = this.dy;
        this.m11 = fm11 * sm11 + fm12 * sm21;
        this.m12 = fm11 * sm12 + fm12 * sm22;
        this.m21 = fm21 * sm11 + fm22 * sm21;
        this.m22 = fm21 * sm12 + fm22 * sm22;
        this.dx = fm11 * sdx + fm12 * sdy + fdx;
        this.dy = fm21 * sdx + fm22 * sdy + fdy;
        this.updateCaches();
    }

    public final String toString() {
        return "Transformation(affiliate=(" + this.m11 + " " + this.m12 + ", " + this.m21 + " " + this.m22 + " | " + this.dx + " " + this.dy + ")";
    }

    public final boolean equalsTransformationAffiliate(TransformationAffiliate other) {
        if (!Point.ORIGIN.transform(this).equalsPoint(Point.ORIGIN.transform(other))) {
            return false;
        }
        if (!Point.Point_1_1.transform(this).equalsPoint(Point.Point_1_1.transform(other))) {
            return false;
        }
        return Point.Point_0_minus1.transform(this).equalsPoint(Point.Point_0_minus1.transform(other));
    }

    @Deprecated
    public final boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransformationAffiliate) {
            TransformationAffiliate t = (TransformationAffiliate)obj;
            return this.equalsTransformationAffiliate(t);
        }
        return false;
    }

    @Deprecated
    public final int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.m11 + this.m12 + this.m21 + this.m22 + this.dx + this.dy).hashCode();
    }

    @Override
    public boolean isEqualTransformation(Transformation other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.isNOPTransformation()) {
            return other.isNOPTransformation();
        }
        if (other instanceof TransformationConcatenation) {
            return other.isEqualTransformation(this);
        }
        if (other instanceof TransformationAffiliate) {
            return this.equalsTransformationAffiliate((TransformationAffiliate)other);
        }
        return false;
    }

    public Concatenation toConcatenation() {
        Concatenation result;
        if (this.concatenationIsValid) {
            result = this.concatenation;
        } else {
            double det = this.m11 * this.m11 + this.m21 * this.m21;
            if (det < 0.0) {
                result = null;
            } else {
                double sx = Math.sqrt(det);
                double phi = Math.atan2(this.m21, this.m11);
                double phiInDegrees = -phi * 180.0 / Math.PI;
                double sin = Math.sin(phi);
                double cos = Math.cos(phi);
                double msy = this.m12 * cos + this.m22 * sin;
                double sy = Math.abs(sin) > Math.abs(cos) ? (msy * cos - this.m12) / sin : (this.m22 - msy * sin) / cos;
                if (Double.isNaN(sy) || Double.isInfinite(sy)) {
                    result = null;
                } else {
                    double m = msy / sy;
                    GeoVector scale = new GeoVector(sx, sy);
                    double shear = m;
                    Direction rotate = Direction.valueOf(phiInDegrees);
                    GeoVector translate = new GeoVector(this.dx, this.dy);
                    result = new Concatenation(scale, shear, rotate, translate);
                }
            }
            this.concatenationIsValid = true;
            this.concatenation = result;
        }
        return result;
    }

    public TransformationAffiliate extractShearAndRotateToBeAppliedLast() {
        double cy;
        double cx;
        double det = this.m11 * this.m22;
        if (Geo.isZero(det)) {
            cx = 0.0;
            cy = 0.0;
        } else {
            cx = this.m12 / this.m22;
            cy = this.m21 / this.m11;
        }
        double dm11 = 1.0;
        double dm12 = cx;
        double dm21 = cy;
        double dm22 = 1.0;
        double ddx = 0.0;
        double ddy = 0.0;
        return new TransformationAffiliate(dm11, dm12, dm21, dm22, ddx, ddy);
    }

    public static class Concatenation {
        private final GeoVector scale;
        private final double shear;
        private final Direction rotate;
        private final GeoVector translate;

        private Concatenation(GeoVector scale, double shear, Direction rotate, GeoVector translate) {
            this.scale = scale;
            this.shear = shear;
            this.rotate = rotate;
            this.translate = translate;
        }

        public GeoVector getScaling() {
            return this.scale;
        }

        public double getShearingX() {
            return this.shear;
        }

        public Direction getRotation() {
            return this.rotate;
        }

        public GeoVector getTranslation() {
            return this.translate;
        }

        public String toString() {
            return "TransformationAffiliate, Concatenation: Scale " + this.scale + ", ShearX " + this.shear + ", Rotate " + this.rotate + ", Translate " + this.translate;
        }
    }
}

