/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class StraightLineDirection {
    private static final ILogger logger = Logger.getLogger(StraightLineDirection.class);
    public static final StraightLineDirection X_AXIS = new StraightLineDirection(0.0);
    public static final StraightLineDirection Y_AXIS = new StraightLineDirection(90.0);
    private final double angle;

    public StraightLineDirection(double angle) {
        this.angle = Geo.getNormalizedStraightLineAngle(angle);
    }

    public StraightLineDirection(Direction direction) {
        this.angle = Geo.getNormalizedStraightLineAngle(direction.getAngle());
    }

    public StraightLineDirection(StraightLineDirection direction) {
        this.angle = direction.angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean nearToXAxis() {
        return this.angle < 45.0000000001 || this.angle > 134.9999999999;
    }

    public boolean nearToYAxis() {
        return this.angle > 44.9999999999 && this.angle < 135.0000000001;
    }

    public boolean equalsStraightLineDirection(StraightLineDirection directionToCompare) {
        return Geo.equalsNormalizedStraightLineAngles(this.angle, directionToCompare.angle);
    }

    public String toString() {
        return "EvenDirection(" + this.angle + "\u00b0)";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StraightLineDirection) {
            StraightLineDirection directionToCompare = (StraightLineDirection)obj;
            return this.equalsStraightLineDirection(directionToCompare);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.angle).hashCode();
    }
}

