/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.InterceptEvenPolygonProcessor;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.StraightLineDirection;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class StraightLine {
    private static final ILogger logger = Logger.getLogger(StraightLine.class);
    public static final StraightLine X_AXIS = new StraightLine(Point.ORIGIN, StraightLineDirection.X_AXIS);
    public static final StraightLine Y_AXIS = new StraightLine(Point.ORIGIN, StraightLineDirection.Y_AXIS);
    private final StraightLineDirection direction;
    private final Point entryPoint;
    private Point intersectionWithXAxis;
    private Point intersectionWithYAxis;
    private boolean isCanonized = false;

    public StraightLine(Point point1, Point point2) {
        assert (point1 != null);
        assert (point2 != null);
        assert (!point1.equalsPoint(point2));
        this.direction = new StraightLineDirection(new GeoVector(point1, point2).getDirection());
        this.entryPoint = Point.getAsPoint(point1);
    }

    public StraightLine(Line line) {
        this(line.start, line.end);
    }

    public StraightLine(Point entryPoint, StraightLineDirection direction) {
        assert (entryPoint != null);
        assert (direction != null);
        this.entryPoint = Point.getAsPoint(entryPoint);
        this.direction = new StraightLineDirection(direction);
    }

    public StraightLine(Point entryPoint, Direction direction) {
        assert (entryPoint != null);
        assert (direction != null);
        this.entryPoint = Point.getAsPoint(entryPoint);
        this.direction = new StraightLineDirection(direction);
    }

    private void canonize() {
        if (!this.isCanonized) {
            if (this.direction.nearToYAxis()) {
                this.intersectionWithXAxis = new Point(this.getIntersectionWithXAxis(), 0.0);
            }
            if (this.direction.nearToXAxis()) {
                this.intersectionWithYAxis = new Point(0.0, this.getIntersectionWithYAxis());
            }
            assert (this.intersectionWithXAxis != null || this.intersectionWithYAxis != null) : "neither near to X axis nor to Y axis";
            this.isCanonized = true;
        }
    }

    public boolean isParallelToXAxis() {
        return StraightLineDirection.X_AXIS.equalsStraightLineDirection(this.direction);
    }

    public boolean isParallelToYAxis() {
        return StraightLineDirection.Y_AXIS.equalsStraightLineDirection(this.direction);
    }

    public double getIntersectionWithXAxis() {
        double deltaY = this.entryPoint.y;
        double angle = this.direction.getAngle();
        double deltaX = deltaY / Math.tan(Math.toRadians(angle));
        return this.entryPoint.x + deltaX;
    }

    public double getIntersectionWithYAxis() {
        double deltaX = this.entryPoint.x;
        double angle = this.direction.getAngle();
        double deltaY = deltaX * Math.tan(Math.toRadians(angle));
        return this.entryPoint.y + deltaY;
    }

    public boolean isParallel(StraightLine straightLine) {
        return this.direction.equalsStraightLineDirection(straightLine.direction);
    }

    public Point getEntryPoint() {
        return this.entryPoint;
    }

    public GeoVector getDirectionVector() {
        return new GeoVector(1.0, Direction.valueOf(this.direction.getAngle()));
    }

    public StraightLineDirection getDirection() {
        return this.direction;
    }

    public boolean isOnStraightLine(Point point) {
        double xe = this.getEntryPoint().x;
        double ye = this.getEntryPoint().y;
        double xr = this.getDirectionVector().x;
        double yr = this.getDirectionVector().y;
        if (Geo.equals(xr, 0.0) && Geo.equals(yr, 0.0)) {
            return Geo.equals(point.x, xe) && Geo.equals(point.y, ye);
        }
        if (Geo.equals(xr, 0.0)) {
            return Geo.equals(point.x, xe);
        }
        if (Geo.equals(yr, 0.0)) {
            return Geo.equals(point.y, ye);
        }
        double tx = (point.x - xe) / xr;
        double ty = (point.y - ye) / yr;
        return Geo.equals(tx, ty);
    }

    public Point getInterceptPoint(StraightLine straightLine) {
        if (this.isParallel(straightLine)) {
            return null;
        }
        double a1 = this.getEntryPoint().x;
        double b1 = this.getEntryPoint().y;
        double a2 = straightLine.getEntryPoint().x;
        double b2 = straightLine.getEntryPoint().y;
        double x1 = this.getDirectionVector().x;
        double y1 = this.getDirectionVector().y;
        double x2 = straightLine.getDirectionVector().x;
        double y2 = straightLine.getDirectionVector().y;
        double s = 0.0;
        if (Geo.isZero(x1)) {
            assert (!Geo.isZero(x2));
            s = (a1 - a2) / x2;
        } else if (Geo.isZero(y1)) {
            assert (!Geo.isZero(y2));
            s = (b1 - b2) / y2;
        } else {
            double numerator = (a2 - a1) * y1 - (b2 - b1) * x1;
            double denominator = y2 * x1 - x2 * y1;
            assert (!Geo.isZero(denominator));
            s = numerator / denominator;
        }
        return straightLine.getPoint(s);
    }

    private Point getPoint(double lambda) {
        double xe = this.entryPoint.x;
        double ye = this.entryPoint.y;
        double xr = this.getDirectionVector().x;
        double yr = this.getDirectionVector().y;
        double x = xe + lambda * xr;
        double y = ye + lambda * yr;
        return new Point(x, y);
    }

    public Points getInterceptPoints(Arc arc) {
        Point p2;
        double sqrt;
        double under_sqrt;
        Points points = new Points();
        double radius = arc.rx;
        if (radius < arc.ry) {
            radius = arc.ry;
        }
        GeoVector centerVector = new GeoVector(Point.ORIGIN, arc.center);
        GeoVector directionVector = this.getDirectionVector();
        double directionVector_sqr = GeoVector.mulScalar(directionVector, directionVector);
        if (Geo.isZero(directionVector_sqr)) {
            return points;
        }
        GeoVector entryVector = new GeoVector(this.entryPoint);
        double p = 2.0 * GeoVector.mulScalar(entryVector, directionVector);
        p -= 2.0 * GeoVector.mulScalar(directionVector, centerVector);
        double q = GeoVector.mulScalar(entryVector, entryVector);
        q -= 2.0 * GeoVector.mulScalar(entryVector, centerVector);
        q += GeoVector.mulScalar(centerVector, centerVector);
        q -= radius * radius;
        if (Geo.isGreaterThanZero(under_sqrt = (p /= directionVector_sqr) * p / 4.0 - (q /= directionVector_sqr))) {
            sqrt = Math.sqrt(under_sqrt);
        } else if (Geo.isZeroOrGreaterThanZero(under_sqrt)) {
            sqrt = 0.0;
        } else {
            return points;
        }
        double t1 = -p / 2.0 + sqrt;
        double t2 = -p / 2.0 - sqrt;
        Point p1 = this.getPoint(t1);
        if (this.isInAngleIntervallOfArc(arc, p1) && this.isOnStraightLine(p1)) {
            points.add(p1);
        }
        if (!p1.equalsPoint(p2 = this.getPoint(t2)) && this.isInAngleIntervallOfArc(arc, p2) && this.isOnStraightLine(p2)) {
            points.add(p2);
        }
        return points;
    }

    private boolean isInAngleIntervallOfArc(Arc arc, Point point) {
        GeoVector centreInterception = new GeoVector(arc.center, point);
        return centreInterception.getDirection().isInInvervall(arc.angleStart, arc.angleEnd);
    }

    public Points getIntersectionPoints(Polygon polygon) {
        InterceptEvenPolygonProcessor pProcessor = new InterceptEvenPolygonProcessor(this);
        polygon.process(pProcessor);
        return pProcessor.getInterceptPoints();
    }

    public StraightLine getPerpendicular(Point throughPoint) {
        return new StraightLine(throughPoint, this.getDirectionVector().turn90().getDirection());
    }

    public boolean equalsStraightLine(StraightLine straightLine) {
        if (straightLine == null) {
            return false;
        }
        if (this == straightLine) {
            return true;
        }
        this.canonize();
        straightLine.canonize();
        if (!this.direction.equalsStraightLineDirection(straightLine.direction)) {
            return false;
        }
        if (this.intersectionWithXAxis != null && straightLine.intersectionWithXAxis != null) {
            return this.intersectionWithXAxis.equalsPoint(straightLine.intersectionWithXAxis);
        }
        if (this.intersectionWithYAxis != null && straightLine.intersectionWithYAxis != null) {
            return this.intersectionWithYAxis.equalsPoint(straightLine.intersectionWithYAxis);
        }
        assert (false) : "must not be reached";
        return false;
    }

    public String toString() {
        this.canonize();
        if (this.intersectionWithXAxis != null) {
            return "StraightLine(" + this.direction.getAngle() + "\u00b0, intersectionXAxis: " + this.intersectionWithXAxis.x + "|" + this.intersectionWithXAxis.y + ")";
        }
        if (this.intersectionWithYAxis != null) {
            return "StraightLine(" + this.direction.getAngle() + "\u00b0, intersectionYAxis: " + this.intersectionWithYAxis.x + "|" + this.intersectionWithYAxis.y + ")";
        }
        assert (false) : "after canonize StraightLine must have an intersecion point";
        return "Error: StraightLine does not exist";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StraightLine) {
            StraightLine straightLineToCompare = (StraightLine)obj;
            return this.equalsStraightLine(straightLineToCompare);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.error("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return 0;
    }
}

