/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Rectangle {
    private static final ILogger logger = Logger.getLogger(Rectangle.class);
    public final Point upperLeft;
    public final Point lowerRight;

    public Rectangle(Rectangle r) {
        assert (r != null);
        this.upperLeft = Point.getAsPoint(r.upperLeft);
        this.lowerRight = Point.getAsPoint(r.lowerRight);
    }

    public Rectangle(Point p1, Point p2) {
        assert (p2 != null);
        assert (p1 != null);
        this.upperLeft = new Point(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y));
        this.lowerRight = new Point(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
    }

    private Rectangle(Point p1_upperLeft, Point p2_lowerRight, boolean p1AndP2AreKnownToBeUpperLeftAndLowerRight) {
        assert (p1_upperLeft != null);
        assert (p2_lowerRight != null);
        assert (p1AndP2AreKnownToBeUpperLeftAndLowerRight);
        assert (p1_upperLeft.x <= p2_lowerRight.x);
        assert (p1_upperLeft.y <= p2_lowerRight.y);
        this.upperLeft = p1_upperLeft;
        this.lowerRight = p2_lowerRight;
    }

    public Rectangle(double x1, double y1, double x2, double y2) {
        double max_y;
        double min_y;
        double max_x;
        double min_x;
        if (x1 < x2) {
            min_x = x1;
            max_x = x2;
        } else {
            min_x = x2;
            max_x = x1;
        }
        if (y1 < y2) {
            min_y = y1;
            max_y = y2;
        } else {
            min_y = y2;
            max_y = y1;
        }
        this.upperLeft = new Point(min_x, min_y);
        this.lowerRight = new Point(max_x, max_y);
    }

    public Rectangle(double x, double y, Dimension d) {
        this.upperLeft = new Point(x, y);
        this.lowerRight = new Point(x + d.width, y + d.height);
    }

    public Rectangle(Point center, Dimension d) {
        this(center.x - d.width / 2.0, center.y - d.height / 2.0, center.x + d.width / 2.0, center.y + d.height / 2.0);
    }

    public double x() {
        return this.upperLeft.x;
    }

    public double y() {
        return this.upperLeft.y;
    }

    public double w() {
        return this.lowerRight.x - this.upperLeft.x;
    }

    public double h() {
        return this.lowerRight.y - this.upperLeft.y;
    }

    public Rectangle translate(GeoVector distance) {
        assert (distance != null);
        return new Rectangle(new Point(this.upperLeft.x + distance.x, this.upperLeft.y + distance.y), new Point(this.lowerRight.x + distance.x, this.lowerRight.y + distance.y), true);
    }

    public Rectangle scale(double factor) {
        return new Rectangle(new Point(this.upperLeft.x * factor, this.upperLeft.y * factor), new Point(this.lowerRight.x * factor, this.lowerRight.y * factor), true);
    }

    public Rectangle union(Point p) {
        if (p != null) {
            Point union_ul;
            boolean update_lr;
            boolean update_ul_x = this.upperLeft.x > p.x;
            boolean update_ul_y = this.upperLeft.y > p.y;
            boolean update_lr_x = this.lowerRight.x < p.x;
            boolean update_lr_y = this.lowerRight.y < p.y;
            boolean update_ul = update_ul_x || update_ul_y;
            boolean bl = update_lr = update_lr_x || update_lr_y;
            if (!update_ul && !update_lr) {
                return this;
            }
            Point point = update_ul ? new Point(update_ul_x ? p.x : this.upperLeft.x, update_ul_y ? p.y : this.upperLeft.y) : (union_ul = this.upperLeft);
            Point union_lr = update_lr ? new Point(update_lr_x ? p.x : this.lowerRight.x, update_lr_y ? p.y : this.lowerRight.y) : this.lowerRight;
            return new Rectangle(union_ul, union_lr, true);
        }
        return this;
    }

    public Rectangle union(Rectangle r) {
        if (r != null) {
            Point union_ul;
            boolean update_lr;
            boolean update_ul_x = this.upperLeft.x > r.upperLeft.x;
            boolean update_ul_y = this.upperLeft.y > r.upperLeft.y;
            boolean update_lr_x = this.lowerRight.x < r.lowerRight.x;
            boolean update_lr_y = this.lowerRight.y < r.lowerRight.y;
            boolean update_ul = update_ul_x || update_ul_y;
            boolean bl = update_lr = update_lr_x || update_lr_y;
            if (!update_ul && !update_lr) {
                return this;
            }
            Point point = update_ul ? new Point(update_ul_x ? r.upperLeft.x : this.upperLeft.x, update_ul_y ? r.upperLeft.y : this.upperLeft.y) : (union_ul = this.upperLeft);
            Point union_lr = update_lr ? new Point(update_lr_x ? r.lowerRight.x : this.lowerRight.x, update_lr_y ? r.lowerRight.y : this.lowerRight.y) : this.lowerRight;
            return new Rectangle(union_ul, union_lr, true);
        }
        return this;
    }

    public Rectangle expand(double value) {
        return this.expand(value, value, value, value);
    }

    public Rectangle expand(double subFromX1, double subFromY1, double addToX2, double addToY2) {
        double upperLeftX = this.upperLeft.x - subFromX1;
        double upperLeftY = this.upperLeft.y - subFromY1;
        double lowerRightX = this.lowerRight.x + addToX2;
        double lowerRightY = this.lowerRight.y + addToY2;
        return new Rectangle(upperLeftX, upperLeftY, lowerRightX, lowerRightY);
    }

    public Rectangle expand(Insets insets) {
        return this.expand(insets.leftInset, insets.upperInset, insets.rightInset, insets.lowerInset);
    }

    public Rectangle shrink(Insets insets) {
        return this.expand(-insets.leftInset, -insets.upperInset, -insets.rightInset, -insets.lowerInset);
    }

    public Dimension getDimension() {
        return new Dimension(this.w(), this.h());
    }

    public Rectangle move(GeoVector v) {
        return new Rectangle(this.upperLeft.movePoint(v), this.lowerRight.movePoint(v));
    }

    public Rectangle transform(Transformation transformation) {
        assert (transformation != null);
        Point uL = this.upperLeft.transform(transformation);
        Point uR = new Point(this.lowerRight.x, this.upperLeft.y).transform(transformation);
        Point lL = new Point(this.upperLeft.x, this.lowerRight.y).transform(transformation);
        Point lR = this.lowerRight.transform(transformation);
        double xmin = Math.min(Math.min(Math.min(uL.x, uR.x), lL.x), lR.x);
        double ymin = Math.min(Math.min(Math.min(uL.y, uR.y), lL.y), lR.y);
        double xmax = Math.max(Math.max(Math.max(uL.x, uR.x), lL.x), lR.x);
        double ymax = Math.max(Math.max(Math.max(uL.y, uR.y), lL.y), lR.y);
        return new Rectangle(xmin, ymin, xmax, ymax);
    }

    public Points toPoints() {
        Points points = new Points();
        points.add(new Point(this.upperLeft.x, this.upperLeft.y));
        points.add(new Point(this.lowerRight.x, this.upperLeft.y));
        points.add(new Point(this.lowerRight.x, this.lowerRight.y));
        points.add(new Point(this.upperLeft.x, this.lowerRight.y));
        return points;
    }

    public boolean isInside(Point point) {
        assert (point != null);
        return point.x >= this.upperLeft.x && point.x <= this.lowerRight.x && point.y >= this.upperLeft.y && point.y <= this.lowerRight.y;
    }

    public boolean intersects(Rectangle rectangle) {
        boolean intersects;
        if (rectangle == null) {
            intersects = false;
        } else {
            double upper = Math.max(this.upperLeft.y, rectangle.upperLeft.y);
            double lower = Math.min(this.lowerRight.y, rectangle.lowerRight.y);
            double left = Math.max(this.upperLeft.x, rectangle.upperLeft.x);
            double right = Math.min(this.lowerRight.x, rectangle.lowerRight.x);
            intersects = true;
            if (intersects) {
                intersects &= Geo.isZeroOrGreaterThanZero(lower - upper);
            }
            if (intersects) {
                intersects &= Geo.isZeroOrGreaterThanZero(right - left);
            }
        }
        return intersects;
    }

    public Corners toCorners() {
        Corners corners = new Corners(4);
        corners.add(new Corner(this.upperLeft));
        corners.add(new Corner(this.lowerRight.x, this.upperLeft.y));
        corners.add(new Corner(this.lowerRight));
        corners.add(new Corner(this.upperLeft.x, this.lowerRight.y));
        return corners;
    }

    public Corners toCorners(double radius) {
        Corners corners = new Corners(4);
        corners.add(new Corner(this.upperLeft, radius));
        corners.add(new Corner(this.lowerRight.x, this.upperLeft.y, radius));
        corners.add(new Corner(this.lowerRight, radius));
        corners.add(new Corner(this.upperLeft.x, this.lowerRight.y, radius));
        return corners;
    }

    public Point center() {
        return new Point((this.upperLeft.x + this.lowerRight.x) / 2.0, (this.upperLeft.y + this.lowerRight.y) / 2.0);
    }

    public Line lowerBound() {
        return new Line(this.upperLeft.x, this.lowerRight.y, this.lowerRight.x, this.lowerRight.y);
    }

    public boolean isInside(Rectangle innerRectangle) {
        assert (innerRectangle != null);
        boolean isInside = false;
        if (this.isInside(innerRectangle.upperLeft) && this.isInside(innerRectangle.lowerRight)) {
            isInside = true;
        }
        return isInside;
    }

    public String toString() {
        return "Rectangle(upperLeft=" + this.upperLeft + ", lowerRight=" + this.lowerRight + ", dimension=" + this.getDimension() + ")";
    }

    public boolean equalsRectangle(Rectangle a) {
        return a.upperLeft.equalsPoint(this.upperLeft) && a.lowerRight.equalsPoint(this.lowerRight);
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Rectangle) {
            Rectangle a = (Rectangle)obj;
            return this.equalsRectangle(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return this.upperLeft.hashCode() ^ this.lowerRight.hashCode();
    }
}

