/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Corner;
import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.geometry.StraightLineDirection;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Line {
    private static final ILogger logger = Logger.getLogger(Line.class);
    public final Point start;
    public final Point end;

    public Line(Point start, Point end) {
        assert (start != null);
        assert (end != null);
        this.start = Point.getAsPoint(start);
        this.end = Point.getAsPoint(end);
    }

    public Line(Point start, Point end, boolean blindlyAcceptPointArgumentsThatAreSubclassesOfPoint) {
        assert (blindlyAcceptPointArgumentsThatAreSubclassesOfPoint);
        assert (start != null);
        assert (end != null);
        this.start = start;
        this.end = end;
    }

    public Line(double startX, double startY, double endX, double endY) {
        this.start = new Point(startX, startY);
        this.end = new Point(endX, endY);
    }

    public double arcLength() {
        return Geo.arcLengthLine(this.start.x, this.start.y, this.end.x, this.end.y);
    }

    public Points getPoints() {
        Points points = new Points(2);
        points.add(this.start);
        points.add(this.end);
        return points;
    }

    public Point getPoint(double arcLength) {
        assert (Geo.isGreaterThanZero(this.arcLength()));
        double arcLengthLine = this.arcLength();
        Point p = Geo.isGreaterThanZero(arcLengthLine) ? new Point(this.start.x + arcLength * (this.end.x - this.start.x) / arcLengthLine, this.start.y + arcLength * (this.end.y - this.start.y) / arcLengthLine) : this.start;
        return p;
    }

    public boolean isNear(Point point, double maxDistance) {
        assert (point != null);
        assert (Geo.isZeroOrGreaterThanZero(maxDistance));
        assert (!this.start.equalsPoint(this.end));
        return Line.isNear(this.start, this.end, point, maxDistance);
    }

    public static boolean isNear(Point from, Point to, Point point, double maxDistance) {
        Point nearest;
        double distance;
        GeoVector direction;
        assert (from != null);
        assert (to != null);
        assert (point != null);
        assert (Geo.isZeroOrGreaterThanZero(maxDistance));
        if (maxDistance < 1.0E-10) {
            return false;
        }
        if (from.equalsPoint(to)) {
            return new GeoVector(from, point).abs() <= maxDistance;
        }
        boolean isNear = false;
        double u = ((point.x - from.x) * (to.x - from.x) + (point.y - from.y) * (to.y - from.y)) / (direction.x * direction.x + direction.y * direction.y);
        direction = new GeoVector(to.x - from.x, to.y - from.y);
        double hangover = maxDistance / direction.abs();
        if (u > -hangover && u < 1.0 + hangover && (distance = new GeoVector(nearest = new Point(from.x + direction.x * u, from.y + direction.y * u), point).abs()) < maxDistance) {
            isNear = true;
        }
        return isNear;
    }

    public static double getDistance(Point lineStartPoint, Point lineEndPoint, Point point) {
        assert (lineStartPoint != null);
        assert (lineEndPoint != null);
        assert (point != null);
        if (lineStartPoint.equalsPoint(lineEndPoint)) {
            return new GeoVector(lineStartPoint, point).abs();
        }
        GeoVector direction = new GeoVector(lineEndPoint.x - lineStartPoint.x, lineEndPoint.y - lineStartPoint.y);
        double u = ((point.x - lineStartPoint.x) * (lineEndPoint.x - lineStartPoint.x) + (point.y - lineStartPoint.y) * (lineEndPoint.y - lineStartPoint.y)) / (direction.x * direction.x + direction.y * direction.y);
        Point nearest = u < 0.0 ? lineStartPoint : (u > 1.0 ? lineEndPoint : new Point(lineStartPoint.x + direction.x * u, lineStartPoint.y + direction.y * u));
        return new GeoVector(nearest, point).abs();
    }

    public boolean isParallel(Line line) {
        boolean isParallel;
        if (this.isZeroLengthLine()) {
            isParallel = false;
        } else if (line.isZeroLengthLine()) {
            isParallel = false;
        } else {
            GeoVector thisVector = new GeoVector(this.start, this.end);
            GeoVector lineVector = new GeoVector(line.start, line.end);
            isParallel = thisVector.getDirection().isParallel(lineVector.getDirection());
        }
        return isParallel;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.start, this.end);
    }

    public Corners toCornersWithZeroRadius() {
        Corners corners = new Corners(2);
        corners.add(new Corner(this.start, 0.0));
        corners.add(new Corner(this.end, 0.0));
        return corners;
    }

    public double getDistance(Point p) {
        return Line.getDistance(this.start, this.end, p);
    }

    public Point getCenter() {
        return new Point((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0);
    }

    public Point intersectWithoutTangents(Line line) {
        Point intersectPoint = null;
        assert (line != null);
        if (this.isZeroLengthLine() || line.isZeroLengthLine()) {
            return null;
        }
        if (this.isParallel(line)) {
            return null;
        }
        double x1 = this.start.x;
        double y1 = this.start.y;
        double x2 = this.end.x;
        double y2 = this.end.y;
        double x3 = line.start.x;
        double y3 = line.start.y;
        double x4 = line.end.x;
        double y4 = line.end.y;
        double s = (x3 - x1) * (y2 - y1) + (y1 - y3) * (x2 - x1);
        s /= (x3 - x4) * (y2 - y1) + (y4 - y3) * (x2 - x1);
        double t = (x1 - x3) * (y4 - y3) + (y3 - y1) * (x4 - x3);
        if ((t /= (x1 - x2) * (y4 - y3) + (y2 - y1) * (x4 - x3)) < 1.0E-10 || t > 0.9999999999 || s < 1.0E-10 || s > 0.9999999999) {
            return null;
        }
        intersectPoint = new Point((1.0 - t) * x1 + t * x2, (1.0 - t) * y1 + t * y2);
        assert (this.assertionIntersectionPointIsEqual(line, intersectPoint, x3, x4, y3, y4, s, t));
        return intersectPoint;
    }

    private boolean assertionIntersectionPointIsEqual(Line line, Point intersectPoint, double x3, double x4, double y3, double y4, double s, double t) {
        Point assertionPoint = new Point((1.0 - s) * x3 + s * x4, (1.0 - s) * y3 + s * y4);
        if (!intersectPoint.equalsPoint(assertionPoint)) {
            logger.error("de.plans.fmca.geometry." + this + ".intersectWithoutTangents(" + line + "): intersectionPoint should equals calculations from both lines (" + t + " -> " + intersectPoint + " != " + s + " -> " + assertionPoint + ")");
        }
        return true;
    }

    public boolean isZeroLengthLine() {
        boolean isOnePoint = false;
        if (Geo.equals(this.start.x, this.end.x) && Geo.equals(this.start.y, this.end.y)) {
            isOnePoint = true;
        }
        return isOnePoint;
    }

    public StraightLineDirection getStaightLineDirection() {
        StraightLineDirection direction = this.isZeroLengthLine() ? null : new StraightLine(this).getDirection();
        return direction;
    }

    public boolean equalsLine(Line a) {
        return a.start.equalsPoint(this.start) && a.end.equalsPoint(this.end);
    }

    public String toString() {
        return "Line(start=" + this.start + ", end=" + this.end + ")";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Line) {
            Line a = (Line)obj;
            return this.equalsLine(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return this.start.hashCode() ^ this.end.hashCode();
    }
}

