/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.geometry.polygon.PolygonProcessor;

public class InterceptEvenPolygonProcessor
extends PolygonProcessor {
    private final StraightLine interceptEven;
    private final Points interceptPoints = new Points(50);

    public InterceptEvenPolygonProcessor(StraightLine even) {
        this.interceptEven = even;
    }

    @Override
    public void processArc(Direction comingFrom, Arc arc, Direction goingTo) {
        this.interceptPoints.addAll(this.interceptEven.getInterceptPoints(arc));
    }

    @Override
    public void processLine(Direction comingFrom, Line line, Direction goingTo) {
        Point iPoint;
        if (this.interceptEven.equalsStraightLine(new StraightLine(line.start, line.end))) {
            this.interceptPoints.add(Point.getAsPoint(line.start));
            this.interceptPoints.add(Point.getAsPoint(line.end));
        } else if (!this.interceptEven.isParallel(new StraightLine(line.start, line.end)) && (iPoint = this.interceptEven.getInterceptPoint(new StraightLine(line.start, line.end))) != null && line.isNear(iPoint, 1.0E-10)) {
            this.interceptPoints.add(iPoint);
        }
    }

    @Override
    public void processPoint(Point point) {
        if (this.interceptEven.isOnStraightLine(point)) {
            this.interceptPoints.add(Point.getAsPoint(point));
        }
    }

    public Points getInterceptPoints() {
        return this.interceptPoints;
    }
}

