/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Transformation;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class GeoVector {
    private static final ILogger logger = Logger.getLogger(GeoVector.class);
    public static final GeoVector NULL = new GeoVector(0.0, 0.0);
    public static final GeoVector GeoVector_1_1 = new GeoVector(1.0, 1.0);
    public static final GeoVector GeoVector_1_0 = new GeoVector(1.0, 0.0);
    public static final GeoVector GeoVector_0_1 = new GeoVector(0.0, 1.0);
    public final double x;
    public final double y;

    public static double angle(double x, double y) {
        assert (!Geo.isZero(x) || !Geo.isZero(y));
        return Math.toDegrees(Math.atan2(-y, x));
    }

    public GeoVector() {
        this(0.0, 0.0);
    }

    public GeoVector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public GeoVector(Point point) {
        assert (point != null);
        this.x = point.x;
        this.y = point.y;
    }

    public GeoVector(Point from, Point to) {
        assert (from != null);
        assert (to != null);
        this.x = to.x - from.x;
        this.y = to.y - from.y;
    }

    public GeoVector(double length, Direction direction) {
        this.x = length * Math.cos(Math.toRadians(direction.getAngle()));
        this.y = -length * Math.sin(Math.toRadians(direction.getAngle()));
    }

    public GeoVector scale(double s) {
        return new GeoVector(this.x * s, this.y * s);
    }

    public GeoVector scaleToLength(double length) {
        assert (!Geo.isZero(this.abs()));
        double lengthOld = this.abs();
        double scale = length / lengthOld;
        return this.scale(scale);
    }

    public GeoVector turn90() {
        return new GeoVector(this.y, -this.x);
    }

    public GeoVector turn270() {
        return new GeoVector(-this.y, this.x);
    }

    public GeoVector turn180() {
        return new GeoVector(-this.x, -this.y);
    }

    public GeoVector turn(double angle) {
        double angleRadians = Math.toRadians(angle);
        double cos_angleRadians = Math.cos(angleRadians);
        double sin_angleRadians = Math.sin(angleRadians);
        return new GeoVector(this.x * cos_angleRadians + this.y * sin_angleRadians, -this.x * sin_angleRadians + this.y * cos_angleRadians);
    }

    public GeoVector turn(Direction direction) {
        return this.turn(direction.getAngle());
    }

    public static double getDifferenceVectorAngle(Point from, Point to) {
        double angle = GeoVector.getDifferenceVectorAngle(from.x, from.y, to.x, to.y);
        assert (angle == new GeoVector(from, to).angle());
        return angle;
    }

    public static double getDifferenceVectorAngle(double from_x, double from_y, double to_x, double to_y) {
        double angle;
        if (from_y == to_y) {
            double atan2_arg_x = to_x - from_x;
            if (Double.isNaN(atan2_arg_x)) {
                assert (false);
                angle = Double.NaN;
            } else if (atan2_arg_x > 0.0) {
                angle = -0.0;
            } else if (atan2_arg_x < 0.0) {
                angle = -180.0;
            } else {
                assert (atan2_arg_x == 0.0);
                assert (false);
                angle = Double.NaN;
            }
        } else {
            angle = GeoVector.angle(to_x - from_x, to_y - from_y);
        }
        return angle;
    }

    public static double getDistance(Point p1, Point p2) {
        double distX = p2.x - p1.x;
        double distY = p2.y - p1.y;
        return Math.sqrt(distX * distX + distY * distY);
    }

    public double angle() {
        return GeoVector.angle(this.x, this.y);
    }

    public double abs() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public GeoVector transform(Point modelPoint, Transformation transformation) {
        assert (modelPoint != null);
        assert (transformation != null);
        Point to = modelPoint.movePoint(this);
        Point fromTransformed = modelPoint.transform(transformation);
        Point toTransformed = to.transform(transformation);
        return new GeoVector(fromTransformed, toTransformed);
    }

    public static GeoVector add(GeoVector a, GeoVector b) {
        assert (a != null);
        assert (b != null);
        return new GeoVector(a.x + b.x, a.y + b.y);
    }

    public static GeoVector add(GeoVector a, GeoVector b, GeoVector c) {
        assert (a != null);
        assert (b != null);
        assert (c != null);
        return new GeoVector(a.x + b.x + c.x, a.y + b.y + c.y);
    }

    public static GeoVector sub(GeoVector a, GeoVector b) {
        assert (a != null);
        assert (b != null);
        return new GeoVector(a.x - b.x, a.y - b.y);
    }

    public static double mulScalar(GeoVector a, GeoVector b) {
        assert (a != null);
        assert (b != null);
        return a.x * b.x + a.y * b.y;
    }

    public Direction getDirection() {
        Direction direction = null;
        if (this.abs() > 1.0E-10) {
            direction = Direction.valueOf(this.angle());
        }
        return direction;
    }

    public static double angle(GeoVector from, GeoVector to) {
        assert (from != null);
        assert (to != null);
        assert (!Geo.isZero(from.abs()));
        assert (!Geo.isZero(to.abs()));
        double angleFrom = from.angle();
        double angleTo = to.angle();
        double angle = angleTo - angleFrom;
        if (angle > 180.0) {
            angle -= 360.0;
        } else if (angle < -180.0) {
            angle += 360.0;
        }
        assert (-180.0 <= angle);
        assert (angle <= 180.0);
        return angle;
    }

    public static boolean isLinearlyDependent(GeoVector a, GeoVector b) {
        double ratioB;
        double ratioA;
        boolean bZero;
        assert (a != null);
        assert (b != null);
        boolean aZero = a.abs() < 1.0E-10;
        boolean bl = bZero = b.abs() < 1.0E-10;
        boolean isLD = aZero || bZero ? true : (Geo.equals(a.y, 0.0) ? Geo.equals(b.y, 0.0) : (ratioA = a.x / a.y) > (ratioB = b.x / b.y) - 1.0E-10 && ratioA < ratioB + 1.0E-10);
        return isLD;
    }

    public boolean isZero() {
        return Geo.isZero(this.abs());
    }

    public boolean equalsGeoVector(GeoVector a) {
        return Geo.equals(a.x, this.x) && Geo.equals(a.y, this.y);
    }

    public String toString() {
        return "Vector(" + this.x + ", " + this.y + ")";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof GeoVector) {
            GeoVector a = (GeoVector)obj;
            return this.equalsGeoVector(a);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.x + this.y).hashCode();
    }
}

