/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.geometry;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;

public class Direction {
    private static final ILogger logger = Logger.getLogger(Direction.class);
    public static final Direction ANGLE_0 = new Direction(0.0);
    public static final Direction ANGLE_45 = new Direction(45.0);
    public static final Direction ANGLE_90 = new Direction(90.0);
    public static final Direction ANGLE_180 = new Direction(180.0);
    public static final Direction ANGLE_270 = new Direction(270.0);
    public static final Direction ANGLE_minus45 = new Direction(315.0);
    private final double angle;

    public static Direction valueOf(double angle) {
        double normalizedAngle = Geo.getNormalizedAngle(angle);
        Direction result = normalizedAngle < 180.0 ? (normalizedAngle == 0.0 ? ANGLE_0 : (normalizedAngle == 90.0 ? ANGLE_90 : new Direction(normalizedAngle))) : (normalizedAngle == 180.0 ? ANGLE_180 : (normalizedAngle == 270.0 ? ANGLE_270 : new Direction(normalizedAngle)));
        return result;
    }

    private Direction(double angle) {
        assert (angle == Geo.getNormalizedAngle(angle));
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isOrthogonal() {
        return Geo.equalsNormalizedStraightLineAngles(0.0, this.angle) || Geo.equalsNormalizedStraightLineAngles(90.0, this.angle);
    }

    public boolean isInInvervall(double angleStart, double angleEnd) {
        boolean isInIntervall;
        double angleStartTemp = angleStart;
        double angleEndTemp = angleEnd;
        if (Geo.equals(angleStartTemp, angleEndTemp)) {
            isInIntervall = Geo.equalsNormalizedAngles(Geo.getNormalizedAngle(angleStartTemp), this.angle);
        } else {
            if (angleStartTemp > angleEndTemp) {
                double angleTemp = angleEndTemp;
                angleEndTemp = angleStartTemp;
                angleStartTemp = angleTemp;
            }
            double angleStartNormalized = Geo.getNormalizedAngle(angleStartTemp);
            double angleEndStartNormalized = angleEndTemp + (angleStartNormalized - angleStartTemp);
            double angleEndNormalized = Geo.getNormalizedAngle(angleEndTemp);
            double angleStartEndNormalized = angleStartTemp + (angleEndNormalized - angleEndTemp);
            isInIntervall = Geo.isInClosedIntervall(this.angle, angleStartNormalized, angleEndStartNormalized) || Geo.isInClosedIntervall(this.angle, angleStartEndNormalized, angleEndNormalized);
        }
        return isInIntervall;
    }

    public boolean isParallel(Direction direction) {
        return Geo.equalsNormalizedStraightLineAngles(Geo.getNormalizedStraightLineAngle(this.angle), Geo.getNormalizedStraightLineAngle(direction.angle));
    }

    public boolean equalsDirection(Direction directionToCompare) {
        return Geo.equalsNormalizedAngles(this.angle, directionToCompare.angle);
    }

    public Direction turn180() {
        if (this.angle < 180.0) {
            return Direction.valueOf(this.angle + 180.0);
        }
        return Direction.valueOf(this.angle - 180.0);
    }

    public Direction turn90() {
        return this.turn(90.0);
    }

    public Direction turn(double offsetAngle) {
        return Direction.valueOf(this.angle + offsetAngle);
    }

    public String toString() {
        return "Direction(" + this.angle + "\u00b0)";
    }

    @Deprecated
    public boolean equals(Object obj) {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Direction) {
            Direction directionToCompare = (Direction)obj;
            return this.equalsDirection(directionToCompare);
        }
        return false;
    }

    @Deprecated
    public int hashCode() {
        logger.debug("Don't call hashCode or equals on geometric objects.", (Throwable)new Exception());
        return new Double(this.angle).hashCode();
    }

    public Integer toInteger() {
        long l = Math.round(this.angle);
        int i = (int)(l % 360L);
        return i;
    }
}

