/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets.dragndrop;

import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.TransferContentBackdoorStorage;
import com.arcway.lib.eclipse.uiframework.widgets.dragndrop.IDropSupportingWidget;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class SimpleWidgetDropListener
implements DropTargetListener {
    private final int feedback;
    private final int operation;
    private final IDropSupportingWidget widget;

    private SimpleWidgetDropListener(int operation, int standardFeedback, IDropSupportingWidget widget) {
        this.widget = widget;
        this.operation = operation;
        this.feedback = standardFeedback;
    }

    public static void addDropListenerToControl(IDropSupportingWidget widget, int operation, int standardFeedback, Control control) {
        Transfer transferAgent = widget.getTransferAgent();
        final DropTarget dropTarget = new DropTarget(control, operation);
        dropTarget.setTransfer(new Transfer[]{transferAgent});
        dropTarget.addDropListener((DropTargetListener)new SimpleWidgetDropListener(operation, standardFeedback, widget));
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dropTarget.dispose();
            }
        });
    }

    public void dragEnter(DropTargetEvent event) {
        Transfer transferAgent = this.widget.getTransferAgent();
        if ((event.operations & this.operation) != 0 && transferAgent.isSupportedType(event.currentDataType) && this.hasCorrectObjectType(event.currentDataType)) {
            event.detail = this.operation;
            event.feedback = this.feedback;
        }
    }

    public void dragLeave(DropTargetEvent event) {
        event.detail = 16;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail != this.operation) {
            event.detail = 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = this.feedback;
    }

    public void drop(DropTargetEvent event) {
        Object contents = this.getContents(event.currentDataType);
        if (contents != null) {
            this.widget.performDrop(contents);
        }
    }

    public void dropAccept(DropTargetEvent event) {
        if (event.detail != this.operation) {
            event.detail = 0;
        }
    }

    private boolean hasCorrectObjectType(TransferData transferData) {
        Object contents = this.getContents(transferData);
        if (contents == null) {
            return true;
        }
        return this.widget.hasCorrectObjectType(contents);
    }

    private Object getContents(TransferData transferData) {
        Transfer transferAgent;
        Object contents = this.widget.getContentsFromTransferAgent(transferData);
        if (contents == null && (transferAgent = this.widget.getTransferAgent()) instanceof AbstractTransferAgentForMultipleObjectTransfer) {
            contents = TransferContentBackdoorStorage.getContent((AbstractTransferAgentForMultipleObjectTransfer)transferAgent, this);
        }
        return contents;
    }
}

