/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.widgets.ImageButton;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractComplexWidget;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseNonPageWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IComplexWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.util.Locale;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class WidgetRowWidget
extends AbstractComplexWidget {
    private static final Image moveBtnImg = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/moveOne.gif").createImage();
    private final Locale userLocale;
    private IEclipseNonPageWidget sourceWidget;
    private IEclipseNonPageWidget targetWidget;
    private ImageButton moveButton;
    private Label moveButtonReplacementLabel;

    static {
        ResourceDisposer.markResourceAsSingleton((Resource)moveBtnImg);
    }

    public WidgetRowWidget(WidgetParameters parameters, IEclipseCompositeWidget parent, Locale userLocale, IComplexWidgetAdapter complexWidgetAdapter) {
        super(parameters, parent, complexWidgetAdapter);
        this.userLocale = userLocale;
    }

    @Override
    public void createWidget_internal_forComplexWidget() {
        Object[] childWidgets = this.getChildWidgets().toArray();
        this.sourceWidget = (IEclipseNonPageWidget)childWidgets[0];
        this.targetWidget = (IEclipseNonPageWidget)childWidgets[1];
        this.sourceWidget.createWidget(this.getParentComposite(), this.getContainingWorkbenchPage());
        if (this.sourceWidget instanceof IEclipseDataWidget && this.targetWidget instanceof IEclipseDataWidget) {
            this.moveButton = new ImageButton(this.getParentComposite(), Messages.getString("ImportEditorRowWidget.move", this.userLocale), moveBtnImg, 0x800000);
            this.moveButton.setBackground(this.getFormToolkit().getColors().getBackground());
            this.moveButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Object value = ((IEclipseDataWidget)WidgetRowWidget.this.sourceWidget).getCurrentValue();
                    ((IEclipseDataWidget)WidgetRowWidget.this.targetWidget).setValue(value);
                    ((IEclipseDataWidget)WidgetRowWidget.this.targetWidget).getWidgetAdapter().widgetModified();
                }
            });
        } else {
            this.moveButtonReplacementLabel = new Label(this.getParentComposite(), 0);
        }
        this.targetWidget.createWidget(this.getParentComposite(), this.getContainingWorkbenchPage());
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
            iEclipseWidget.updateWidget(mode);
        }
    }

    @Override
    public void refreshWidget_internal() {
        for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
            iEclipseWidget.refreshWidget();
        }
    }

    @Override
    public void disposeUIResources() {
        ((AbstractWidget)this.sourceWidget).disposeUIResources();
        ((AbstractWidget)this.targetWidget).disposeUIResources();
        if (this.moveButton != null) {
            this.moveButton.dispose();
        }
        if (this.moveButtonReplacementLabel != null) {
            this.moveButtonReplacementLabel.dispose();
        }
    }

    @Override
    protected Control getBaseControl() {
        if (this.moveButton != null) {
            return this.moveButton;
        }
        return this.moveButtonReplacementLabel;
    }
}

