/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractCompositeLayoutWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.editor.TableWidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class TableWidget
extends AbstractCompositeLayoutWidget {
    private Composite contentBlockComposite;
    private final int numCols;

    public TableWidget(TableWidgetParameters parameters, IEclipseCompositeWidget parent) {
        super((WidgetParameters)parameters, parent);
        this.numCols = parameters.getNumCols();
    }

    @Override
    public void createWidget_internal() {
        this.createControl(this.getParentComposite());
    }

    private void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.contentBlockComposite = toolkit.createComposite(parentComposite);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        this.contentBlockComposite.setLayoutData((Object)td);
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 20;
        layout.rightMargin = 15;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 20;
        layout.numColumns = this.numCols * 2;
        layout.makeColumnsEqualWidth = false;
        this.contentBlockComposite.setLayout((Layout)layout);
        for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
            iEclipseWidget.createWidget(this.contentBlockComposite, this.getContainingWorkbenchPage());
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (this.contentBlockComposite != null) {
            for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
                iEclipseWidget.updateWidget(mode);
            }
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.contentBlockComposite != null) {
            for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
                iEclipseWidget.refreshWidget();
            }
            this.contentBlockComposite.layout();
        }
    }

    @Override
    public void disposeUIResources() {
        this.contentBlockComposite.dispose();
    }
}

