/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.util.Arrays;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SingleChoiceRadioButtonWidget
extends AbstractDataWidget
implements SelectionListener {
    private Control control;
    private Button[] buttons;
    private Object[] keys;
    private int selectedButtonsIndex;
    private Composite widgetComposite;

    public SingleChoiceRadioButtonWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = parentComposite;
        ISortedSet_ value = (ISortedSet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        this.keys = new Object[value.size()];
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (this.isEditable() && isModificationPermitted && isModificationLocked) {
            this.createEditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
        } else {
            this.createUneditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
        }
    }

    public Object getCurrentValue() {
        return this.keys[this.selectedButtonsIndex];
    }

    public void setValue(Object value) {
        String label = "";
        int i = 0;
        for (EnumerationItem item : (ISortedSet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE)) {
            if (!item.getKey().equals(value)) continue;
            label = item.getLabel();
            i = Arrays.binarySearch(this.keys, item.getKey());
        }
        if (this.control instanceof Label) {
            ((Label)this.control).setText(label);
        }
        if (this.control instanceof Composite) {
            this.buttons[i].setSelection(true);
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        int selectedIndex = -1;
        ISortedSet_ valueRange = (ISortedSet_)this.getWidgetAdapter().getValue(mode);
        int i = 0;
        for (EnumerationItem item : valueRange) {
            if (item.isChecked()) {
                selectedIndex = i;
            }
            ++i;
        }
        if (this.control != null) {
            if (this.isEditable() && this.getWidgetAdapter().isModificationPermitted() && this.getWidgetAdapter().isModificationLocked()) {
                if (valueRange.size() != this.buttons.length) {
                    return;
                }
                Button newButton = this.buttons[selectedIndex];
                Button oldbutton = this.buttons[this.selectedButtonsIndex];
                oldbutton.removeSelectionListener((SelectionListener)this);
                newButton.removeSelectionListener((SelectionListener)this);
                oldbutton.setSelection(false);
                newButton.setSelection(true);
                oldbutton.addSelectionListener((SelectionListener)this);
                newButton.addSelectionListener((SelectionListener)this);
            } else {
                Control[] children = this.widgetComposite.getChildren();
                assert (children.length == 1);
                Label l = (Label)children[0];
                ISortedSet_ value = (ISortedSet_)this.getWidgetAdapter().getValue(mode);
                for (EnumerationItem item : value) {
                    if (!item.isChecked()) continue;
                    l.setText(item.getLabel());
                }
            }
            this.selectedButtonsIndex = selectedIndex;
            this.updateWidgetMessageDisplay();
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            FormToolkit toolkit = this.getFormToolkit();
            if (this.control != null) {
                this.control.dispose();
            }
            ISortedSet_ value = (ISortedSet_)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (this.isEditable() && isModificationPermitted && isModificationLocked) {
                this.keys = new Object[value.size()];
                this.createEditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
            } else {
                this.createUneditableControl(toolkit, (ISortedSet_<EnumerationItem>)value);
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Button button;
        Widget widget;
        if (e.widget != null && (widget = e.widget) instanceof Button && !(button = (Button)widget).isDisposed() && button.getSelection() && !button.equals(this.buttons[this.selectedButtonsIndex])) {
            int i = 0;
            while (i < this.buttons.length) {
                if (button.equals(this.buttons[i])) {
                    this.selectedButtonsIndex = i;
                    break;
                }
                ++i;
            }
            this.getWidgetAdapter().widgetModified();
        }
    }

    private void createEditableControl(FormToolkit toolkit, ISortedSet_<EnumerationItem> value) {
        this.control = toolkit.createComposite(this.widgetComposite);
        this.buttons = new Button[value.size()];
        int i = 0;
        for (EnumerationItem item : value) {
            Button button = toolkit.createButton((Composite)this.control, item.getLabel(), 16);
            button.setSelection(item.isChecked());
            if (item.isChecked()) {
                this.selectedButtonsIndex = i;
            }
            button.addSelectionListener((SelectionListener)this);
            this.buttons[i] = button;
            this.keys[i] = item.getKey();
            ++i;
        }
        TableWrapLayout layout = new TableWrapLayout();
        ((Composite)this.control).setLayout((Layout)layout);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        ((Composite)this.control).setLayoutData((Object)td);
    }

    private void createUneditableControl(FormToolkit toolkit, ISortedSet_<EnumerationItem> value) {
        for (EnumerationItem item : value) {
            if (!item.isChecked()) continue;
            this.control = toolkit.createLabel(this.widgetComposite, item.getLabel(), 16384);
            this.control.setForeground(this.widgetComposite.getDisplay().getSystemColor(15));
        }
    }
}

