/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.RelationsTreeWidgetRelationWidgetAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class RelationsTreeWidget
extends AbstractDataWidget
implements ISelectionChangedListener {
    private static final int LINE_HEIGHT = 16;
    private UsableCheckboxTreeViewer treeViewer;
    private final ContentProvider contentProvider;
    private final ILabelProvider labelProvider;
    private final NodeComparator nodeComparator;
    private Map<Object, ArrayList<?>> nodes;
    private Node[] values;
    private Composite widgetComposite;

    public RelationsTreeWidget(WidgetParameters widgetParameters, ICompositeWidget parentWidget, IDataWidgetAdapter adapter) {
        super(widgetParameters, adapter, (IEclipseCompositeWidget)parentWidget);
        assert (parentWidget instanceof IEclipseCompositeWidget);
        this.contentProvider = new ContentProvider();
        this.labelProvider = new LabelProvider();
        this.nodeComparator = new NodeComparator();
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = parentComposite;
        this.getValuesFromAdapter();
        if (this.nodes.size() == 1) {
            this.createNullValueControl(toolkit);
        } else {
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
                this.createUneditableControl();
            } else {
                this.createEditableControl();
            }
        }
    }

    private void createEditableControl() {
        this.treeViewer = new UsableCheckboxTreeViewer(this.widgetComposite, 1, 2048);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setInput(this.contentProvider.getRoot());
        this.setCheckedNodes();
        this.treeViewer.addPostSelectionChangedListener(this);
        TableWrapData td = new TableWrapData(256);
        td.grabHorizontal = true;
        td.grabVertical = true;
        td.heightHint = this.nodes.size() * 16;
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)td);
    }

    private void createUneditableControl() {
        this.createEditableControl();
        this.treeViewer.getTree().setEnabled(false);
        this.treeViewer.expandAll();
    }

    private void createNullValueControl(FormToolkit toolkit) {
        toolkit.setBorderStyle(0);
        toolkit.createLabel(this.widgetComposite, "-");
    }

    public Object getCurrentValue() {
        ArrayList<EnumerationItem> resultList = new ArrayList<EnumerationItem>();
        if (this.treeViewer != null) {
            this.treeViewer.expandAll();
            Node[] nodeArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Node element = nodeArray[n2];
                if (this.treeViewer.getChecked(element)) {
                    resultList.add(element.getItem());
                }
                ++n2;
            }
            return resultList;
        }
        return null;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        this.getValuesFromAdapter();
        if (this.treeViewer != null) {
            this.treeViewer.removePostSelectionChangedListener(this);
            this.treeViewer.refresh();
            this.setCheckedNodes();
            this.treeViewer.expandAll();
            this.treeViewer.refresh();
            this.treeViewer.addPostSelectionChangedListener(this);
        }
        this.updateWidgetMessageDisplay();
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            Control[] controls;
            FormToolkit toolkit = this.getFormToolkit();
            Control[] controlArray = controls = this.widgetComposite.getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            this.getValuesFromAdapter();
            if (this.nodes.size() == 1) {
                this.createNullValueControl(toolkit);
            } else {
                boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
                boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
                if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
                    this.createUneditableControl();
                } else {
                    this.createEditableControl();
                }
            }
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.getWidgetAdapter().widgetModified();
    }

    private void getValuesFromAdapter() {
        this.nodes = new HashMap();
        this.nodes.put(this.contentProvider.getRoot(), new ArrayList());
        Object value = this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        ISortedSet_ valuesIE = (ISortedSet_)value;
        this.values = new Node[valuesIE.size()];
        int n = 0;
        for (EnumerationItem item : valuesIE) {
            Node node = new Node(item);
            this.addNodeToMap(node);
            this.values[n++] = node;
        }
    }

    private void addNodeToMap(Node node) {
        this.nodes.put(node, new ArrayList());
        Node parentNode = node.getParent();
        if (parentNode == null) {
            ((List)this.nodes.get(this.contentProvider.getRoot())).add(node);
        } else {
            if (!this.nodes.containsKey(parentNode)) {
                this.addNodeToMap(parentNode);
            }
            ((List)this.nodes.get(parentNode)).add(node);
        }
    }

    private void setCheckedNodes() {
        ArrayList<Node> checked = new ArrayList<Node>();
        Node[] nodeArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node.isChecked()) {
                checked.add(node);
            }
            this.treeViewer.setCheckedElements(checked.toArray());
            ++n2;
        }
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object getRoot() {
            return this;
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = ((List)RelationsTreeWidget.this.nodes.get(inputElement)).toArray();
            Arrays.sort(result, RelationsTreeWidget.this.nodeComparator);
            return result;
        }

        public boolean hasChildren(Object element) {
            return !((List)RelationsTreeWidget.this.nodes.get(element)).isEmpty();
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = ((List)RelationsTreeWidget.this.nodes.get(parentElement)).toArray();
            Arrays.sort(result, RelationsTreeWidget.this.nodeComparator);
            return result;
        }

        public Object getParent(Object element) {
            if (element instanceof Node) {
                return ((Node)element).getParent();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Node) {
                return ((Node)element).getLabel();
            }
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class Node {
        private final EnumerationItem item;

        public Node(EnumerationItem enumerationItem) {
            this.item = enumerationItem;
        }

        public String getLabel() {
            return this.item.getLabel();
        }

        public Node getParent() {
            EnumerationItem parentObj = ((RelationsTreeWidgetRelationWidgetAdapter)RelationsTreeWidget.this.getWidgetAdapter()).getParent(this.item);
            if (parentObj == null) {
                return null;
            }
            return new Node(parentObj);
        }

        public boolean equals(Object node2) {
            return node2 != null && node2 instanceof Node && ((RelationsTreeWidgetRelationWidgetAdapter)RelationsTreeWidget.this.getWidgetAdapter()).isEqual(this.item, ((Node)node2).item);
        }

        public int hashCode() {
            return ((RelationsTreeWidgetRelationWidgetAdapter)RelationsTreeWidget.this.getWidgetAdapter()).getHashCode(this.item);
        }

        protected EnumerationItem getItem() {
            return this.item;
        }

        public boolean isChecked() {
            return this.item.isChecked();
        }
    }

    private class NodeComparator
    implements Comparator<Object> {
        private NodeComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            boolean o1hasNoChildren = ((List)RelationsTreeWidget.this.nodes.get(o1)).isEmpty();
            boolean o2hasNoChildren = ((List)RelationsTreeWidget.this.nodes.get(o2)).isEmpty();
            if (!o1hasNoChildren && o2hasNoChildren) {
                return -1;
            }
            if (o1hasNoChildren && !o2hasNoChildren) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(RelationsTreeWidget.this.labelProvider.getText(o1), RelationsTreeWidget.this.labelProvider.getText(o2));
        }
    }
}

