/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.uiframework.editors.imports.ImportEditorControl;
import com.arcway.lib.eclipse.uiframework.widgets.AbstractPageWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseNonPageWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.importdialog.PageWidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import java.util.Locale;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ImportEditorPageWidget
extends AbstractPageWidget {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private final int type;
    private ImportEditorControl importEditorControl;
    private String compTxt_existing;
    private String compTxt_imported;
    private Label lbl_comp;
    private CompareModeSelector cmpModeSelector;
    private Composite stk_comp;
    private StackLayout stl_comp;
    private Composite cmpImportedValues;
    private Label lblImportedValues;
    private Composite stk_newv;
    private StackLayout stl_newv;
    private Composite cmpNewValues_add;
    private Label lblNewValues_add;
    private Composite cmpNewValues_merge;
    private Label lblNewValues_merge;
    private Composite leftLine;
    private Composite rightLine;
    private Composite leftLine2;
    private Composite rightLine2;
    private Composite spaceBeforeLeftLine2;
    private Composite spaceBeforeRightLine2;
    private static final int LINE_HEIGHT = 4;
    private static final int LINE_WIDTH_TABLE_HEADERS = 2;
    private Color bgColorExistingObject;
    private Color bgColorImportedObject;
    private Color bgColorNewObject;
    private final Locale userLocale;
    private boolean isCreated = false;
    private static final int NO_IMPORT_MODE_SET = -1;
    private int currentImportMode = -1;

    public ImportEditorPageWidget(WidgetParameters parameters, Locale userLocale) {
        super(parameters);
        this.userLocale = userLocale;
        this.type = ((PageWidgetParameters)parameters).getType();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
    }

    public void reflow() {
        this.form.reflow(true);
    }

    @Override
    public void createWidget(Composite parentComposite, IWorkbenchPage workbenchPage) {
        assert (this.toolkit != null);
        super.createWidget(parentComposite, workbenchPage);
        this.initializeDisplayResources(parentComposite.getDisplay());
        this.form = this.toolkit.createScrolledForm(parentComposite);
        TableWrapLayout tableLayout = new TableWrapLayout();
        tableLayout.topMargin = 20;
        tableLayout.rightMargin = 20;
        tableLayout.horizontalSpacing = 10;
        tableLayout.verticalSpacing = 10;
        tableLayout.numColumns = 5;
        tableLayout.makeColumnsEqualWidth = false;
        this.form.getBody().setLayout((Layout)tableLayout);
        if (this.type == 0) {
            this.lbl_comp = this.toolkit.createLabel(this.form.getBody(), "");
            TableWrapData lbltd = new TableWrapData(2);
            lbltd.grabHorizontal = false;
            lbltd.grabVertical = false;
            this.lbl_comp.setLayoutData((Object)lbltd);
            this.stk_comp = this.toolkit.createComposite(this.form.getBody());
            lbltd = new TableWrapData(128);
            lbltd.colspan = 1;
            lbltd.grabHorizontal = true;
            lbltd.grabVertical = false;
            this.stk_comp.setLayoutData((Object)lbltd);
            this.stl_comp = new StackLayout();
            this.stk_comp.setLayout((Layout)this.stl_comp);
            this.cmpModeSelector = new CompareModeSelector(this.stk_comp);
            this.compTxt_imported = Messages.getString("ImportEditor.comparemode_imported", this.userLocale);
            this.cmpModeSelector.setImportedText(this.compTxt_imported);
            this.compTxt_existing = Messages.getString("ImportEditor.comparemode_existing", this.userLocale);
            this.cmpModeSelector.setExistingText(this.compTxt_existing);
            this.cmpImportedValues = this.createColoredComposite(this.stk_comp, this.bgColorImportedObject);
            this.lblImportedValues = this.toolkit.createLabel(this.cmpImportedValues, this.compTxt_imported);
            this.lblImportedValues.setLayoutData((Object)new GridData(2, 2, false, false));
            this.lblImportedValues.setBackground(this.bgColorImportedObject);
            this.stl_comp.topControl = this.cmpModeSelector.getControl();
            this.createCompositeForEmptyField();
            this.stk_newv = this.toolkit.createComposite(this.form.getBody());
            lbltd = new TableWrapData(128);
            lbltd.colspan = 2;
            lbltd.grabHorizontal = true;
            lbltd.grabVertical = false;
            this.stk_newv.setLayoutData((Object)lbltd);
            this.stl_newv = new StackLayout();
            this.stk_newv.setLayout((Layout)this.stl_newv);
            this.cmpNewValues_add = this.createColoredComposite(this.stk_newv, this.bgColorNewObject);
            this.lblNewValues_add = this.toolkit.createLabel(this.cmpNewValues_add, Messages.getString("ImportEditorPageWidget.new_values_add"));
            this.lblNewValues_add.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.lblNewValues_add.setBackground(this.bgColorNewObject);
            this.cmpNewValues_merge = this.createColoredComposite(this.stk_newv, this.bgColorNewObject);
            this.lblNewValues_merge = this.toolkit.createLabel(this.cmpNewValues_merge, Messages.getString("ImportEditorPageWidget.new_values_merge"));
            this.lblNewValues_merge.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.lblNewValues_merge.setBackground(this.bgColorNewObject);
            this.stl_newv.topControl = this.cmpNewValues_merge;
            this.createCompositeForEmptyField();
            this.leftLine = this.toolkit.createComposite(this.form.getBody());
            lbltd = new TableWrapData(128);
            lbltd.maxHeight = 4;
            lbltd.heightHint = 4;
            this.leftLine.setLayoutData((Object)lbltd);
            this.createCompositeForEmptyField();
            this.rightLine = this.toolkit.createComposite(this.form.getBody());
            lbltd = new TableWrapData(128);
            lbltd.maxHeight = 4;
            lbltd.heightHint = 4;
            lbltd.colspan = 2;
            this.rightLine.setLayoutData((Object)lbltd);
        }
        for (IEclipseNonPageWidget widget : this.getChildWidgets()) {
            widget.createWidget(this.form.getBody(), this.getContainingWorkbenchPage());
        }
        this.createPageFooterAndLayoutPage();
        this.isCreated = true;
    }

    private void setLineColorsAccordingToImportModeAndCompareMode() {
        if (this.currentImportMode != -1) {
            if (this.currentImportMode == 1) {
                this.leftLine.setBackground(this.bgColorImportedObject);
                this.leftLine2.setBackground(this.bgColorImportedObject);
                this.rightLine.setBackground(this.bgColorNewObject);
                this.rightLine2.setBackground(this.bgColorNewObject);
            } else {
                this.rightLine.setBackground(this.bgColorNewObject);
                this.rightLine2.setBackground(this.bgColorNewObject);
                this.setLineColorsAccordingToCompareMode();
            }
        }
    }

    private void setLineColorsAccordingToCompareMode() {
        int compareMode = this.importEditorControl.getCompareMode();
        if (compareMode == 1) {
            this.leftLine.setBackground(this.bgColorImportedObject);
            this.leftLine2.setBackground(this.bgColorImportedObject);
        } else if (compareMode == 0) {
            this.leftLine.setBackground(this.bgColorExistingObject);
            this.leftLine2.setBackground(this.bgColorExistingObject);
        }
    }

    private void disposePageFooter() {
        if (this.spaceBeforeLeftLine2 != null) {
            this.spaceBeforeLeftLine2.dispose();
        }
        if (this.leftLine2 != null) {
            this.leftLine2.dispose();
        }
        if (this.spaceBeforeRightLine2 != null) {
            this.spaceBeforeRightLine2.dispose();
        }
        if (this.rightLine2 != null) {
            this.rightLine2.dispose();
        }
    }

    private void createPageFooterAndLayoutPage() {
        if (this.type == 0) {
            this.spaceBeforeLeftLine2 = this.createCompositeForEmptyField();
            this.leftLine2 = this.toolkit.createComposite(this.form.getBody());
            TableWrapData lbltd = new TableWrapData(128);
            lbltd.maxHeight = 4;
            lbltd.heightHint = 4;
            this.leftLine2.setLayoutData((Object)lbltd);
            this.spaceBeforeRightLine2 = this.createCompositeForEmptyField();
            this.rightLine2 = this.toolkit.createComposite(this.form.getBody());
            lbltd = new TableWrapData(128);
            lbltd.maxHeight = 4;
            lbltd.heightHint = 4;
            lbltd.colspan = 2;
            this.rightLine2.setLayoutData((Object)lbltd);
        }
        this.form.getBody().layout(true, true);
        this.form.reflow(true);
        this.form.getBody().redraw();
    }

    private Composite createCompositeForEmptyField() {
        Composite emptyField = this.toolkit.createComposite(this.form.getBody());
        TableWrapData lbltd = new TableWrapData();
        lbltd.maxWidth = 0;
        lbltd.maxHeight = 0;
        emptyField.setLayoutData((Object)lbltd);
        return emptyField;
    }

    @Override
    protected void callbackRecreatePageWidget_pre() {
        if (this.isCreated) {
            this.disposePageFooter();
        }
    }

    @Override
    protected void callbackRecreatePageWidget_post() {
        if (this.isCreated) {
            this.createPageFooterAndLayoutPage();
            this.setLineColorsAccordingToImportModeAndCompareMode();
        }
    }

    public void setupImportMode(int importMode, final Button btn_new, boolean isMergeEnabled, final Button btn_merge) {
        this.currentImportMode = importMode;
        if (importMode == 1) {
            this.stl_comp.topControl = this.cmpImportedValues;
            this.cmpModeSelector.setEnabled(false);
            this.stl_newv.topControl = this.cmpNewValues_add;
        } else {
            this.stl_comp.topControl = this.cmpModeSelector.getControl();
            this.cmpModeSelector.setEnabled(true);
            this.stl_newv.topControl = this.cmpNewValues_merge;
        }
        this.setLineColorsAccordingToImportModeAndCompareMode();
        this.stk_comp.layout();
        this.stk_newv.layout();
        btn_new.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btn_new.getSelection()) {
                    ((ImportEditorPageWidget)ImportEditorPageWidget.this).stl_comp.topControl = ImportEditorPageWidget.this.cmpImportedValues;
                    ImportEditorPageWidget.this.cmpModeSelector.setEnabled(false);
                    ImportEditorPageWidget.this.stk_comp.layout();
                    ((ImportEditorPageWidget)ImportEditorPageWidget.this).stl_newv.topControl = ImportEditorPageWidget.this.cmpNewValues_add;
                    ImportEditorPageWidget.this.stk_newv.layout();
                }
            }
        });
        if (isMergeEnabled) {
            btn_merge.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (btn_merge.getSelection()) {
                        ((ImportEditorPageWidget)ImportEditorPageWidget.this).stl_comp.topControl = ImportEditorPageWidget.this.cmpModeSelector.getControl();
                        ImportEditorPageWidget.this.cmpModeSelector.setEnabled(true);
                        ImportEditorPageWidget.this.stk_comp.layout();
                        ((ImportEditorPageWidget)ImportEditorPageWidget.this).stl_newv.topControl = ImportEditorPageWidget.this.cmpNewValues_merge;
                        ImportEditorPageWidget.this.stk_newv.layout();
                    }
                }
            });
        }
    }

    public void setupMergeEnabled(boolean mergeEnabled) {
        if (mergeEnabled) {
            this.stl_comp.topControl = this.cmpModeSelector.getControl();
            this.cmpModeSelector.setEnabled(true);
            this.stk_comp.layout();
            this.stl_newv.topControl = this.cmpNewValues_merge;
            this.stk_newv.layout();
        } else {
            this.stl_comp.topControl = this.cmpImportedValues;
            this.stl_comp.topControl = this.cmpModeSelector.getControl();
            this.cmpModeSelector.setEnabled(false);
            this.stk_comp.layout();
            this.stl_newv.topControl = this.cmpNewValues_add;
            this.stk_newv.layout();
        }
    }

    public void setImportEditorControl(ImportEditorControl importEditorControl) {
        assert (importEditorControl != null);
        assert (this.importEditorControl == null);
        this.importEditorControl = importEditorControl;
        if (this.type == 0) {
            this.updateCompareMode();
        }
    }

    public void updateCompareMode() {
        this.cmpModeSelector.updateCompareMode();
        this.setLineColorsAccordingToCompareMode();
    }

    public void updateWidget(IWidgetAdapter.WidgetUpdateMode mode) {
        for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
            iEclipseWidget.updateWidget(mode);
        }
    }

    public void refreshWidget() {
        if (this.form != null) {
            this.form.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    for (IEclipseWidget iEclipseWidget : ImportEditorPageWidget.this.getChildWidgets()) {
                        iEclipseWidget.refreshWidget();
                    }
                    ImportEditorPageWidget.this.form.reflow(true);
                }
            });
        }
    }

    @Override
    public Control getBaseControl() {
        return this.form;
    }

    @Override
    public FormToolkit getFormToolkit() {
        return this.toolkit;
    }

    public int getType() {
        return this.type;
    }

    private void initializeDisplayResources(Display display) {
        assert (this.bgColorExistingObject == null) : "Dispose old resources first if repeated calls shall be allowed";
        this.bgColorExistingObject = display.getSystemColor(15);
        this.bgColorImportedObject = new Color((Device)display, 221, 232, 246);
        this.bgColorNewObject = new Color((Device)display, 212, 242, 118);
    }

    public void dispose() {
        if (this.bgColorExistingObject != null) {
            this.bgColorExistingObject = null;
            this.bgColorImportedObject.dispose();
            this.bgColorImportedObject = null;
            this.bgColorNewObject.dispose();
            this.bgColorNewObject = null;
        }
        super.dispose();
    }

    private Composite createColoredComposite(Composite parent, Color color) {
        Composite frame = this.toolkit.createComposite(parent);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        gd.horizontalAlignment = 4;
        frame.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 2;
        gl.marginHeight = 2;
        frame.setLayout((Layout)gl);
        frame.setBackground(color);
        return frame;
    }

    public void setFormToolkit(FormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public void updateWidgetMessageDisplay() {
        throw new UnsupportedOperationException();
    }

    public void clearWidgetMessageDisplay() {
        throw new UnsupportedOperationException();
    }

    private class CompareModeSelector {
        private final Composite parent;
        private final Composite comModeSelectionComposite;
        private final Button btnCompExisting;
        private final Button btnCompImported;

        private CompareModeSelector(Composite parentComposite) {
            this.parent = parentComposite;
            this.comModeSelectionComposite = ImportEditorPageWidget.this.toolkit.createComposite(this.parent);
            GridLayout gl = new GridLayout(2, true);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            this.comModeSelectionComposite.setLayout((Layout)gl);
            GridData modeButtonLayout = new GridData(4, 4, true, false);
            Composite frame = ImportEditorPageWidget.this.createColoredComposite(this.comModeSelectionComposite, ImportEditorPageWidget.this.bgColorImportedObject);
            this.btnCompImported = ImportEditorPageWidget.this.toolkit.createButton(frame, ImportEditorPageWidget.this.compTxt_imported, 17);
            this.btnCompImported.setBackground(ImportEditorPageWidget.this.bgColorImportedObject);
            this.btnCompImported.setLayoutData((Object)modeButtonLayout);
            frame = ImportEditorPageWidget.this.createColoredComposite(this.comModeSelectionComposite, ImportEditorPageWidget.this.bgColorExistingObject);
            this.btnCompExisting = ImportEditorPageWidget.this.toolkit.createButton(frame, ImportEditorPageWidget.this.compTxt_existing, 17);
            this.btnCompExisting.setBackground(ImportEditorPageWidget.this.bgColorExistingObject);
            this.btnCompExisting.setLayoutData((Object)modeButtonLayout);
            this.btnCompImported.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CompareModeSelector.this.btnCompImported.getSelection()) {
                        ImportEditorPageWidget.this.importEditorControl.setCompareMode(1);
                    }
                }
            });
            this.btnCompExisting.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (CompareModeSelector.this.btnCompExisting.getSelection()) {
                        ImportEditorPageWidget.this.importEditorControl.setCompareMode(0);
                    }
                }
            });
        }

        private Control getControl() {
            return this.comModeSelectionComposite;
        }

        private void setExistingText(String text) {
            this.btnCompExisting.setText(text);
        }

        private void setImportedText(String text) {
            this.btnCompImported.setText(text);
        }

        private void setEnabled(boolean enabled) {
            this.btnCompExisting.setEnabled(enabled);
            this.btnCompImported.setEnabled(enabled);
        }

        private void updateCompareMode() {
            int compareMode = ImportEditorPageWidget.this.importEditorControl.getCompareMode();
            if (compareMode == 0) {
                this.btnCompExisting.setSelection(true);
                this.btnCompImported.setSelection(false);
            } else {
                this.btnCompExisting.setSelection(false);
                this.btnCompImported.setSelection(true);
            }
        }
    }
}

