/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractStringWidget;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class FreeTextWidget
extends AbstractStringWidget {
    public FreeTextWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, parent);
    }

    @Override
    protected StyledText createTextControl(Composite widgetComposite) {
        return this.buildControl(widgetComposite);
    }

    @Override
    protected StyledText refreshTextControl(Composite widgetComposite) {
        return this.buildControl(widgetComposite);
    }

    @Override
    protected String getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        return (String)this.getWidgetAdapter().getValue(mode);
    }

    private StyledText buildControl(Composite widgetComposite) {
        StyledText control;
        FormToolkit toolkit = this.getFormToolkit();
        String toBeValue = this.createToBeValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            toolkit.setBorderStyle(0);
            if (toBeValue.equals("-")) {
                control = new StyledText(widgetComposite, 72);
                control.setText(toBeValue);
            } else {
                control = new StyledText(widgetComposite, 74);
                control.setText(toBeValue);
            }
            TableWrapData tdcontrol = new TableWrapData(256);
            tdcontrol.grabHorizontal = true;
            tdcontrol.grabVertical = true;
            control.setLayoutData((Object)tdcontrol);
        } else {
            control = this.createEditableControl(widgetComposite, toBeValue);
        }
        return control;
    }

    private StyledText createEditableControl(Composite widgetComposite, String toBeValue) {
        StyledText control = new StyledText(widgetComposite, 2626);
        control.setText(toBeValue);
        control.addModifyListener((ModifyListener)this);
        control.setEnabled(true);
        TableWrapData td = new TableWrapData(256, 256);
        if (control.computeSize((int)widgetComposite.getSize().x, (int)-1).y < 100) {
            td.heightHint = 100;
        }
        control.setLayoutData((Object)td);
        return control;
    }
}

