/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractCompositeLayoutWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.editor.ColumnWidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ColumnWidget
extends AbstractCompositeLayoutWidget {
    private Composite client;
    private Section section;
    private final boolean hasTwistie;
    private final boolean isExpanded;
    private final boolean isTitlebarVisible;
    private final int rowSpan;
    private final int colspan;

    public ColumnWidget(ColumnWidgetParameters parameters, IEclipseCompositeWidget parent) {
        super((WidgetParameters)parameters, parent);
        this.hasTwistie = parameters.hasTwistie();
        this.isExpanded = parameters.isExpanded();
        this.isTitlebarVisible = parameters.isVisible();
        this.colspan = parameters.getColSpan();
        this.rowSpan = parameters.getRowSpan();
    }

    private String getSectionDescriptionOrNull() {
        String tooltipText2 = this.getTooltipText();
        if (tooltipText2 == null || tooltipText2.trim().length() == 0) {
            return null;
        }
        return tooltipText2;
    }

    @Override
    public void createWidget_internal() {
        int effectiveColSpan;
        String sectionDescription = this.getSectionDescriptionOrNull();
        FormToolkit toolkit = this.getFormToolkit();
        int style = 0;
        if (this.hasTwistie()) {
            style |= 2;
        }
        if (this.isExpanded()) {
            style |= 0x40;
        }
        if (this.isTitleBarVisible()) {
            style |= 0x100;
        }
        if (this.isTitleBarVisible() && sectionDescription != null) {
            style |= 0x80;
        }
        this.section = toolkit.createSection(this.getParentComposite(), style);
        this.section.descriptionVerticalSpacing = 10;
        if (this.isTitleBarVisible() && this.getLabel() != null) {
            this.section.setText(this.getLabel());
        }
        if (this.isTitleBarVisible() && sectionDescription != null) {
            this.section.setDescription(sectionDescription);
        }
        TableWrapData td = new TableWrapData(256, 256);
        td.grabHorizontal = true;
        td.grabVertical = true;
        if (this.colspan != 0) {
            effectiveColSpan = this.colspan * 2;
        } else {
            Layout layout = this.getParentComposite().getLayout();
            effectiveColSpan = ((TableWrapLayout)layout).numColumns;
        }
        td.colspan = effectiveColSpan;
        td.rowspan = this.rowSpan;
        this.section.setLayoutData((Object)td);
        this.client = this.getFormToolkit().createComposite((Composite)this.section);
        TableWrapLayout clientLayout = new TableWrapLayout();
        clientLayout.numColumns = 2;
        clientLayout.horizontalSpacing = 10;
        clientLayout.verticalSpacing = 10;
        this.client.setLayout((Layout)clientLayout);
        this.section.setClient((Control)this.client);
        for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
            if (iEclipseWidget == null) continue;
            iEclipseWidget.createWidget(this.client, this.getContainingWorkbenchPage());
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
            iEclipseWidget.updateWidget(mode);
        }
    }

    @Override
    public void refreshWidget_internal() {
        if (this.client != null) {
            for (IEclipseWidget iEclipseWidget : this.getChildWidgets()) {
                iEclipseWidget.refreshWidget();
            }
            this.client.layout();
        }
    }

    @Override
    public void disposeUIResources() {
        this.section.dispose();
    }

    public boolean hasTwistie() {
        return this.hasTwistie;
    }

    private boolean isTitleBarVisible() {
        return this.isTitlebarVisible;
    }

    private boolean isExpanded() {
        return this.isExpanded;
    }
}

