/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.AbstractDataWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.ui.editor.datatype.ICompositeWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class BooleanWidget
extends AbstractDataWidget
implements SelectionListener {
    private Button control;
    private Composite widgetComposite;

    public BooleanWidget(WidgetParameters parameters, ICompositeWidget parent, IDataWidgetAdapter adapter) {
        super(parameters, adapter, (IEclipseCompositeWidget)parent);
        assert (parent instanceof IEclipseCompositeWidget);
    }

    @Override
    public void createControl(Composite parentComposite) {
        FormToolkit toolkit = this.getFormToolkit();
        this.widgetComposite = parentComposite;
        this.control = toolkit.createButton(this.widgetComposite, null, 32);
        Boolean value = (Boolean)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        if (value != null) {
            this.control.setSelection(value.booleanValue());
        } else {
            this.control.setSelection(false);
        }
        this.control.addSelectionListener((SelectionListener)this);
        TableWrapData td = new TableWrapData(256);
        this.control.setLayoutData((Object)td);
        boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
        boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
        if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
            this.control.setEnabled(false);
        } else {
            this.control.setEnabled(true);
        }
    }

    @Override
    public void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode mode) {
        if (this.control != null) {
            if (mode != IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE) {
                this.control.removeSelectionListener((SelectionListener)this);
                Boolean value = (Boolean)this.getWidgetAdapter().getValue(mode);
                this.control.setSelection(value != null ? value : false);
                this.control.addSelectionListener((SelectionListener)this);
            }
            this.updateWidgetMessageDisplay();
        }
    }

    public Object getCurrentValue() {
        return this.control.getSelection();
    }

    public void setValue(Object value) {
        this.control.setSelection(((Boolean)value).booleanValue());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.getWidgetAdapter().widgetModified();
    }

    @Override
    public void refreshWidget_internal() {
        if (this.widgetComposite != null) {
            FormToolkit toolkit = this.getFormToolkit();
            this.control.dispose();
            this.control = toolkit.createButton(this.widgetComposite, null, 32);
            Boolean value = (Boolean)this.getWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            if (value != null) {
                this.control.setSelection(value.booleanValue());
            } else {
                this.control.setSelection(false);
            }
            this.control.addSelectionListener((SelectionListener)this);
            boolean isModificationPermitted = this.getWidgetAdapter().isModificationPermitted();
            boolean isModificationLocked = this.getWidgetAdapter().isModificationLocked();
            if (!(this.isEditable() && isModificationPermitted && isModificationLocked)) {
                this.control.setEnabled(false);
            } else {
                this.control.setEnabled(true);
            }
            TableWrapData td = new TableWrapData(256);
            this.control.setLayoutData((Object)td);
            this.updateWidgetMessageDisplay();
            this.widgetComposite.pack();
        }
    }
}

