/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.Messages;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceDisposer;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseCompositeWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipseNonPageWidget;
import com.arcway.lib.icons.Icons16x16;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.datatype.IComplexWidget;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public abstract class AbstractWidget
implements IEclipseNonPageWidget {
    static final int COLS_PER_WIDGET = 2;
    private static final Image errorImg = ImageCache.getImageDescriptor(Icons16x16.ERROR).createImage();
    private static final Image nolockImg = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/nolock.png").createImage();
    private static final Image nopermissionImg = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/nopermission.png").createImage();
    private IWorkbenchPage containingWorkbenchPage = null;
    private final IEclipseCompositeWidget parent;
    private final int colspan;
    private Composite parentComposite;
    private boolean isCreated = false;
    private boolean isDisposed = true;
    private boolean isVisible = true;
    private boolean shallBeVisible = true;
    private boolean isEditable_basicSetting;
    private boolean isEditable_dynamicSetting;
    private final String label;
    private final boolean showLable;
    private final String tooltipText;
    private boolean hasWidgetMessageDisplayControl = false;
    private ControlDecoration widgetMessageDisplayControl = null;

    static {
        ResourceDisposer.markResourceAsSingleton((Resource)errorImg);
        ResourceDisposer.markResourceAsSingleton((Resource)nolockImg);
        ResourceDisposer.markResourceAsSingleton((Resource)nopermissionImg);
    }

    public AbstractWidget(WidgetParameters parameters, IEclipseCompositeWidget parent) {
        this.parent = parent;
        this.colspan = parameters.getColSpan();
        this.isEditable_basicSetting = !parent.isEditable() ? false : parameters.isEditable();
        this.isEditable_dynamicSetting = true;
        boolean showLable_ = parameters.showLabel();
        String label_ = parameters.getLabel();
        if (label_ != null && label_.trim().length() > 0) {
            this.label = label_.trim();
            this.showLable = showLable_;
        } else {
            this.label = null;
            this.showLable = false;
        }
        String tooltipText_ = parameters.getTooltip();
        this.tooltipText = tooltipText_ != null && tooltipText_.trim().length() > 0 ? tooltipText_.trim() : null;
    }

    @Override
    public FormToolkit getFormToolkit() {
        return this.getParent().getFormToolkit();
    }

    protected final IWorkbenchPage getContainingWorkbenchPage() {
        return this.containingWorkbenchPage;
    }

    @Override
    public final IEclipseCompositeWidget getParent() {
        return this.parent;
    }

    protected final Composite getParentComposite() {
        return this.parentComposite;
    }

    public final boolean isEditable() {
        return this.isEditable_basicSetting && this.isEditable_dynamicSetting;
    }

    public final void setEditable(boolean isEditable) {
        this.isEditable_dynamicSetting = isEditable;
    }

    public final boolean isShowingLabel() {
        return this.showLable;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getTooltipText() {
        return this.tooltipText;
    }

    @Override
    public final void createWidget(Composite parentComposite_, IWorkbenchPage workbenchPage_) {
        this.containingWorkbenchPage = workbenchPage_;
        this.parentComposite = parentComposite_;
        this.createWidget();
        this.isCreated = true;
    }

    public final void recreateWidget() {
        if (this.isCreated && this.isDisposed) {
            this.createWidget();
        }
    }

    private final void createWidget() {
        this.isDisposed = false;
        if (this.shallBeVisible) {
            this.createWidget_internal();
            this.isVisible = this.shallBeVisible;
        } else {
            this.isVisible = false;
        }
    }

    protected abstract void createWidget_internal();

    public final void updateWidget(IWidgetAdapter.WidgetUpdateMode mode) {
        if (this.isCreated && this.isVisible) {
            this.updateWidget_internal(mode);
        }
    }

    protected abstract void updateWidget_internal(IWidgetAdapter.WidgetUpdateMode var1);

    public final void refreshWidget() {
        if (this.isCreated && this.isVisible) {
            this.refreshWidget_internal();
        }
    }

    protected abstract void refreshWidget_internal();

    public final void disposeWidget(boolean editorIsClosing) {
        if (this.isCreated) {
            boolean wasVisible = this.isVisible;
            this.sendDisposeSignal(editorIsClosing);
            if (wasVisible) {
                this.disposeUIResources();
            }
        }
    }

    protected final void sendDisposeSignal(boolean editorIsClosing) {
        this.sendDisposeSignal_internal(editorIsClosing);
        this.isDisposed = true;
        this.isVisible = false;
    }

    protected abstract void sendDisposeSignal_internal(boolean var1);

    protected abstract void disposeUIResources();

    public final void setVisible(boolean visible) {
        this.shallBeVisible = visible;
    }

    protected void createWidgetMessageDisplayControl(Control controlAtWhichToDisplayMessages) {
        this.hasWidgetMessageDisplayControl = true;
        this.widgetMessageDisplayControl = new ControlDecoration(controlAtWhichToDisplayMessages, 131200);
        this.widgetMessageDisplayControl.setImage(ImageCache.getImage(this.getParentComposite().getDisplay(), Icons16x16.EMPTY));
    }

    public void updateWidgetMessageDisplay() {
        if (this.isDisposed) {
            return;
        }
        assert (this.hasWidgetMessageDisplayControl);
        IDataWidgetAdapter widgetAdapter = null;
        if (this instanceof IDataWidget) {
            widgetAdapter = ((IDataWidget)this).getWidgetAdapter();
        } else if (this instanceof IComplexWidget) {
            widgetAdapter = ((IComplexWidget)this).getWidgetAdapter();
        }
        assert (widgetAdapter != null);
        if (widgetAdapter != null) {
            boolean hasPermission = widgetAdapter.isModificationPermitted();
            boolean isLocked = widgetAdapter.isModificationLocked();
            boolean hasError = widgetAdapter.hasError();
            if (hasPermission && isLocked && !hasError) {
                this.clearWidgetMessageDisplay();
            }
            if (!isLocked) {
                String lockMessage = widgetAdapter.getLockMessage();
                if (lockMessage == null) {
                    lockMessage = Messages.getString((String)"AbstractWidget.GeneralLockMessage");
                }
                this.displayWidgetMessage(nolockImg, lockMessage);
            } else if (!hasPermission) {
                this.displayWidgetMessage(nopermissionImg, widgetAdapter.getPermissionMessage());
            } else if (hasError) {
                this.displayErrorMessage(widgetAdapter.getErrorMessage(), widgetAdapter.getCurrentPresentationContext());
            }
        }
    }

    private void displayErrorMessage(IEditorMessage error, PresentationContext presentationContext) {
        IStreamResource icon16x16 = error.getIcon16x16();
        if (icon16x16 == null) {
            IMessageLevel errorLevel = error.getMessageLevel();
            icon16x16 = errorLevel.getIcon16x16();
        }
        if (icon16x16 != null) {
            Image errorImage = ImageCache.getImage(this.getParentComposite().getDisplay(), icon16x16);
            this.displayWidgetMessage(errorImage, error.getMessageText(presentationContext));
        } else {
            this.clearWidgetMessageDisplay();
        }
    }

    private void displayWidgetMessage(Image image, String permissionMessage) {
        if (!AbstractWidget.isDisposed(this.widgetMessageDisplayControl)) {
            this.widgetMessageDisplayControl.setImage(image);
            this.widgetMessageDisplayControl.setDescriptionText(permissionMessage);
            this.widgetMessageDisplayControl.show();
        }
    }

    public void clearWidgetMessageDisplay() {
        if (this.isDisposed) {
            return;
        }
        assert (this.hasWidgetMessageDisplayControl);
        if (!AbstractWidget.isDisposed(this.widgetMessageDisplayControl)) {
            this.widgetMessageDisplayControl.hide();
        }
    }

    protected final void disposeWidgetMessageDisplayControl() {
        assert (this.hasWidgetMessageDisplayControl);
        this.hasWidgetMessageDisplayControl = false;
        this.widgetMessageDisplayControl.hide();
        this.widgetMessageDisplayControl.dispose();
        this.widgetMessageDisplayControl = null;
    }

    protected int calculateColspan(Composite parentComposite_, int labelAndInfoColumnCount) {
        int span = 1;
        switch (this.colspan) {
            case 0: {
                Layout layout = parentComposite_.getLayout();
                int layoutColumns = ((TableWrapLayout)layout).numColumns;
                span = layoutColumns - labelAndInfoColumnCount;
                break;
            }
            default: {
                span = this.colspan * 2 - labelAndInfoColumnCount;
            }
        }
        return span;
    }

    protected final boolean isDisposed() {
        return this.isDisposed;
    }

    protected final boolean isVisible() {
        return this.isVisible;
    }

    protected final boolean shallBeVisible() {
        return this.shallBeVisible;
    }

    private static final boolean isDisposed(ControlDecoration widgetMessageDisplayControl) {
        return widgetMessageDisplayControl == null || widgetMessageDisplayControl.getControl() == null || widgetMessageDisplayControl.getControl().isDisposed();
    }
}

