/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.widgets;

import com.arcway.lib.eclipse.uiframework.widgets.IEclipseNonPageWidget;
import com.arcway.lib.eclipse.uiframework.widgets.IEclipsePageWidget;
import com.arcway.lib.ui.editor.datatype.INonPageWidget;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.forms.editor.FormPage;

public abstract class AbstractPageWidget
extends FormPage
implements IEclipsePageWidget {
    private final String label;
    private final String tooltipText;
    private boolean isEditable;
    private final Collection<IEclipseNonPageWidget> childWidgets = new ArrayList<IEclipseNonPageWidget>();
    private IWorkbenchPage containingWorkbenchPage = null;

    public AbstractPageWidget(WidgetParameters parameters) {
        super(parameters.getLabel(), parameters.getLabel());
        this.label = parameters.getLabel();
        this.tooltipText = parameters.getTooltip();
        this.isEditable = parameters.isEditable();
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public void addChildWidget(INonPageWidget widget) {
        assert (widget instanceof IEclipseNonPageWidget);
        this.childWidgets.add((IEclipseNonPageWidget)widget);
    }

    public Collection<IEclipseNonPageWidget> getChildWidgets() {
        return this.childWidgets;
    }

    @Override
    public void createWidget(Composite parentComposite, IWorkbenchPage workbenchPage_) {
        this.containingWorkbenchPage = workbenchPage_;
    }

    public void recreatePageWidget() {
        this.callbackRecreatePageWidget_pre();
        for (IEclipseNonPageWidget childWidget : this.childWidgets) {
            childWidget.disposeWidget(false);
            childWidget.recreateWidget();
        }
        this.callbackRecreatePageWidget_post();
    }

    protected abstract void callbackRecreatePageWidget_pre();

    protected abstract void callbackRecreatePageWidget_post();

    public void disposeContents(boolean isEditorClosing) {
        for (IEclipseNonPageWidget childWidget : this.childWidgets) {
            childWidget.disposeWidget(isEditorClosing);
        }
    }

    protected final IWorkbenchPage getContainingWorkbenchPage() {
        return this.containingWorkbenchPage;
    }
}

