/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.treeviews.dnd;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgent;
import com.arcway.lib.eclipse.transfer.SerializableDataTypeTransferAgentWithFixDataType;
import com.arcway.lib.eclipse.transfer.dnd.DropTargetParameters;
import com.arcway.lib.eclipse.transfer.dnd.IDragHandler;
import com.arcway.lib.eclipse.transfer.dnd.IDropHandler;
import com.arcway.lib.eclipse.uiframework.treeviews.EclipseTreeViewElementWrapper;
import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewDragSource;
import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewDropTarget;
import com.arcway.lib.ui.dnd.IModelDragHandler;
import com.arcway.lib.ui.dnd.IModelDropHandler;
import com.arcway.lib.ui.treeviews.ITreeViewFrontendAgent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class TreeViewDragNDropSupport {
    public static final String TRANSFER_ID_PREFIX = "TreeViewDragNDropSupport";
    private final int operation;
    private final int operations;
    private final Transfer[] dragTransfers;
    private final Transfer[] dropTransfers;
    private final ITreeViewFrontendAgent treeView;

    public TreeViewDragNDropSupport(ITreeViewFrontendAgent treeView, int standardOperation, int additionalOperations) {
        this.treeView = treeView;
        this.operation = standardOperation;
        this.operations = this.operation | additionalOperations;
        IDataType[] dragDataTypes = treeView.getDragDataTypes(this.operation);
        ArrayList<SerializableDataTypeTransferAgentWithFixDataType> dragTransferList = new ArrayList<SerializableDataTypeTransferAgentWithFixDataType>();
        IDataType[] iDataTypeArray = dragDataTypes;
        int n = dragDataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IDataType dataType = iDataTypeArray[n2];
            dragTransferList.add(new SerializableDataTypeTransferAgentWithFixDataType(TRANSFER_ID_PREFIX + dataType.getClass().getCanonicalName(), dataType));
            ++n2;
        }
        this.dragTransfers = dragTransferList.toArray(new Transfer[dragTransferList.size()]);
        IDataType[] dropDataTypes = treeView.getDropDataTypes(this.operation);
        ArrayList<SerializableDataTypeTransferAgentWithFixDataType> dropTransferList = new ArrayList<SerializableDataTypeTransferAgentWithFixDataType>();
        IDataType[] iDataTypeArray2 = dropDataTypes;
        int n3 = dropDataTypes.length;
        int n4 = 0;
        while (n4 < n3) {
            IDataType dataType = iDataTypeArray2[n4];
            dropTransferList.add(new SerializableDataTypeTransferAgentWithFixDataType(TRANSFER_ID_PREFIX + dataType.getClass().getCanonicalName(), dataType));
            ++n4;
        }
        this.dropTransfers = dropTransferList.toArray(new Transfer[dropTransferList.size()]);
    }

    protected ITreeViewFrontendAgent getITreeView() {
        return this.treeView;
    }

    public static int mapEclipseDNDOperationIntToArcwayDNDOperationInt(int swtInt) {
        int arcwayInt = 0;
        if (false) {
            arcwayInt += 0;
        }
        if ((swtInt & 1) != 0) {
            ++arcwayInt;
        }
        if ((swtInt & 2) != 0) {
            arcwayInt += 2;
        }
        if ((swtInt & 4) != 0) {
            arcwayInt += 4;
        }
        if ((swtInt & 8) != 0) {
            arcwayInt += 8;
        }
        if ((swtInt & 0x10) != 0) {
            arcwayInt += 16;
        }
        return arcwayInt;
    }

    public static int mapArcwayDNDOperationIntToEclipseDNDOperationInt(int arcwayInt) {
        int swtInt = 0;
        if (false) {
            swtInt += 0;
        }
        if ((arcwayInt & 1) != 0) {
            ++swtInt;
        }
        if ((arcwayInt & 2) != 0) {
            swtInt += 2;
        }
        if ((arcwayInt & 4) != 0) {
            swtInt += 4;
        }
        if ((arcwayInt & 8) != 0) {
            swtInt += 8;
        }
        if ((arcwayInt & 0x10) != 0) {
            swtInt += 16;
        }
        return swtInt;
    }

    public TreeViewDragSource createDragHandler() {
        IDragHandler dragHandler = new IDragHandler(){
            IModelDragHandler platformDragHandler;

            @Override
            public boolean isDragPossible(DragSourceEvent event, ISelectionProvider selectionProvider) {
                ArrayList<Object> selectedItems = new ArrayList<Object>();
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                List selectionCollection = ((IStructuredSelection)selection).toList();
                for (Object wrapper : selectionCollection) {
                    if (!(wrapper instanceof EclipseTreeViewElementWrapper)) continue;
                    selectedItems.add(((EclipseTreeViewElementWrapper)wrapper).getTreeViewElement());
                }
                if (selectedItems.size() == 0) {
                    return false;
                }
                this.platformDragHandler = TreeViewDragNDropSupport.this.getITreeView().getModelDragHandler(selectedItems, TreeViewDragNDropSupport.mapEclipseDNDOperationIntToArcwayDNDOperationInt(TreeViewDragNDropSupport.this.operation));
                return this.platformDragHandler != null;
            }

            @Override
            public Object getDragData(DragSourceEvent event, ISelectionProvider selectionProvider) {
                if (!$assertionsDisabled && this.platformDragHandler == null) {
                    throw new AssertionError();
                }
                return this.platformDragHandler.getDragData();
            }

            @Override
            public void finishDrag(DragSourceEvent event, ISelectionProvider selectionProvider) {
                this.platformDragHandler = null;
            }
        };
        return new TreeViewDragSource(this.operations, this.dragTransfers, dragHandler);
    }

    public TreeViewDropTarget createDropTarget() {
        IDropHandler dropHandler = new IDropHandler(){
            IModelDropHandler platformDropHandler;
            TransferData transferData = null;
            Object droppedElements = null;
            int position = 0;

            @Override
            public boolean isDropPossible(DropTargetEvent event, int location, Control targetControl, DropTargetParameters parametersToChoose) {
                if (this.transferData != event.currentDataType) {
                    this.transferData = event.currentDataType;
                    Transfer[] transferArray = TreeViewDragNDropSupport.this.dropTransfers;
                    int n = transferArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Transfer transfer = transferArray[n2];
                        if (transfer.isSupportedType(this.transferData) && transfer instanceof AbstractTransferAgent) {
                            this.droppedElements = ((AbstractTransferAgent)transfer).nativeToJava(this.transferData);
                        }
                        ++n2;
                    }
                }
                if (this.droppedElements == null) {
                    return false;
                }
                parametersToChoose.requestedOperation = TreeViewDragNDropSupport.this.operation;
                parametersToChoose.requestedTransferType = this.transferData;
                Object targetFolderElement = null;
                Widget item = event.item;
                if (item != null) {
                    if (location == 3) {
                        TreeItem treeItem = (TreeItem)item;
                        this.position = treeItem.getItemCount() + 1;
                        Object treeItemData = treeItem.getData();
                        if (treeItemData instanceof EclipseTreeViewElementWrapper) {
                            targetFolderElement = ((EclipseTreeViewElementWrapper)treeItemData).getTreeViewElement();
                        }
                    } else if (location == 2 || location == 1) {
                        this.position = 0;
                        TreeItem childOfFolderTreeItem = (TreeItem)item;
                        TreeItem targetFolderTreeItem = childOfFolderTreeItem.getParentItem();
                        if (targetFolderTreeItem != null) {
                            int i = location == 2 ? 1 : 0;
                            TreeItem[] treeItemArray = targetFolderTreeItem.getItems();
                            int n = treeItemArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                TreeItem child = treeItemArray[n3];
                                if (child.equals(childOfFolderTreeItem)) {
                                    this.position = i;
                                    break;
                                }
                                ++i;
                                ++n3;
                            }
                            Object treeItemData = targetFolderTreeItem.getData();
                            if (treeItemData instanceof EclipseTreeViewElementWrapper) {
                                targetFolderElement = ((EclipseTreeViewElementWrapper)treeItemData).getTreeViewElement();
                            }
                        }
                    } else {
                        this.position = 0;
                        return false;
                    }
                }
                if (targetFolderElement != null) {
                    this.platformDropHandler = TreeViewDragNDropSupport.this.getITreeView().getModelDropHandler(this.droppedElements, targetFolderElement, TreeViewDragNDropSupport.mapEclipseDNDOperationIntToArcwayDNDOperationInt(event.detail));
                }
                boolean result = this.platformDropHandler != null;
                return result;
            }

            @Override
            public boolean performDrop(DropTargetEvent event, int location, Control targetControl) {
                if (!$assertionsDisabled && this.platformDropHandler == null) {
                    throw new AssertionError();
                }
                return this.platformDropHandler.performDrop(this.position);
            }
        };
        return new TreeViewDropTarget(this.operations, this.dropTransfers, dropHandler);
    }
}

