/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.treeviews;

import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.eclipse.uiframework.treeviews.TreeBrowserController;
import com.arcway.lib.eclipse.uiframework.treeviews.TreeViewContentProvider;
import com.arcway.lib.eclipse.uiframework.treeviews.TreeViewLabelProvider;
import com.arcway.lib.eclipse.uiframework.treeviews.TreeViewMenuListener;
import com.arcway.lib.eclipse.uiframework.treeviews.TreeViewSelectionProvider;
import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewDragSource;
import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewDragSourceListener;
import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewDropTarget;
import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewDropTargetListener;
import com.arcway.lib.eclipse.uiframework.treeviews.dnd.TreeViewMoveDragNDropSupport;
import com.arcway.lib.ui.treeviews.ITreeView;
import com.arcway.lib.ui.treeviews.ITreeViewFrontendAgent;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;

public class TreeViewWidget {
    private static final ImageDescriptor COLLAPSE_ALL_BUTTON = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/collapseall.gif");
    private static final ImageDescriptor EXPAND_ALL_BUTTON = ResourceLoader.getImageDescriptor((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/expandall.gif");
    public TreeViewer treeViewer;
    private TreeViewSelectionProvider selectionProvider;
    private final TreeBrowserController browserController;
    private final ITreeViewFrontendAgent treeViewFrontendAgent;
    public final Action collapseAllAction;
    public final Action expandAllAction;

    public TreeViewWidget(ITreeViewFrontendAgent treeViewFrontendAgent, Composite parentComposite, IViewSite viewSite) {
        this.treeViewFrontendAgent = treeViewFrontendAgent;
        Display display = parentComposite.getDisplay();
        TreeViewContentProvider treeViewContentProvider = new TreeViewContentProvider((ITreeView)treeViewFrontendAgent);
        TreeViewLabelProvider treeViewLabelProvider = new TreeViewLabelProvider((ITreeView)treeViewFrontendAgent, display);
        this.treeViewer = new TreeViewer(parentComposite, 2);
        this.treeViewer.setContentProvider((IContentProvider)treeViewContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)treeViewLabelProvider);
        this.treeViewer.setInput(treeViewContentProvider.getRoot());
        this.browserController = new TreeBrowserController(this.treeViewer, display, treeViewFrontendAgent, "RepositoryTreeBrowser", true, false);
        MenuManager projectsViewContextMenuMgr = new MenuManager();
        projectsViewContextMenuMgr.setRemoveAllWhenShown(true);
        projectsViewContextMenuMgr.addMenuListener((IMenuListener)new TreeViewMenuListener(this.treeViewer, treeViewFrontendAgent, display, viewSite));
        Menu projectsViewMenu = projectsViewContextMenuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(projectsViewMenu);
        TreeViewMoveDragNDropSupport support = new TreeViewMoveDragNDropSupport(treeViewFrontendAgent);
        ArrayList<TreeViewDragSource> dragHandlers = new ArrayList<TreeViewDragSource>();
        dragHandlers.add(support.createDragHandler());
        TreeViewDragSourceListener dragListener = new TreeViewDragSourceListener(this.treeViewer, dragHandlers);
        this.treeViewer.addDragSupport(dragListener.getSupportedOperations(), dragListener.getSupportedTransfers(), (DragSourceListener)dragListener);
        ArrayList<TreeViewDropTarget> dropHandlers = new ArrayList<TreeViewDropTarget>();
        dropHandlers.add(support.createDropTarget());
        TreeViewDropTargetListener dropListener = new TreeViewDropTargetListener(this.treeViewer, dropHandlers);
        this.treeViewer.addDropSupport(dropListener.getSupportedOperations(), dropListener.getSupportedTransfers(), (DropTargetListener)dropListener);
        this.collapseAllAction = new CollapseAllAction();
        this.expandAllAction = new ExpandAllAction();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void refresh() {
        this.browserController.refresh();
    }

    public void dispose() {
        this.browserController.dispose();
        this.treeViewFrontendAgent.dispose();
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new TreeViewSelectionProvider(this.treeViewer, this.treeViewFrontendAgent);
        }
        return this.selectionProvider;
    }

    private class CollapseAllAction
    extends Action {
        public CollapseAllAction() {
            super("", COLLAPSE_ALL_BUTTON);
        }

        public void run() {
            TreeViewWidget.this.treeViewer.collapseAll();
        }
    }

    private class ExpandAllAction
    extends Action {
        public ExpandAllAction() {
            super("", EXPAND_ALL_BUTTON);
        }

        public void run() {
            TreeViewWidget.this.treeViewer.expandAll();
        }
    }
}

