/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.treeviews;

import com.arcway.lib.eclipse.uiframework.treeviews.EclipseTreeViewElementWrapper;
import com.arcway.lib.ui.treeviews.ITreeView;
import com.arcway.lib.ui.treeviews.ITreeViewFrontendAgent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class TreeViewSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private final TreeViewer treeViewer;
    private final ITreeView treeViewFrontendAgent;
    private final List<ISelectionChangedListener> listeners;

    public TreeViewSelectionProvider(TreeViewer treeViewer, ITreeViewFrontendAgent treeViewFrontendAgent) {
        this.treeViewer = treeViewer;
        this.treeViewFrontendAgent = treeViewFrontendAgent;
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.listeners = new ArrayList<ISelectionChangedListener>();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        ISelection selection = this.treeViewer.getSelection();
        return this.translateSelection(selection);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        int i;
        while ((i = this.listeners.indexOf(listener)) != -1) {
            this.listeners.remove(i);
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList<EclipseTreeViewElementWrapper> result = new ArrayList<EclipseTreeViewElementWrapper>();
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection) {
                Object node = this.treeViewFrontendAgent.getNodeForItem(o);
                if (node == null) continue;
                result.add(new EclipseTreeViewElementWrapper(node, this.treeViewFrontendAgent));
            }
            if (result.size() > 0) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(result));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        SelectionChangedEvent newSelectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.translateSelection(event.getSelection()));
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(newSelectionChangedEvent);
        }
    }

    private ISelection translateSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object[] selectionArray = ((StructuredSelection)selection).toArray();
            Object[] elements = new Object[selectionArray.length];
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof EclipseTreeViewElementWrapper) {
                    Object unwrapped = ((EclipseTreeViewElementWrapper)selectionArray[i]).getTreeViewElement();
                    elements[i] = this.treeViewFrontendAgent.getItemForNode(unwrapped);
                }
                ++i;
            }
            return new StructuredSelection(elements);
        }
        return selection;
    }
}

