/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.treeviews;

import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.uiframework.EclipseWizardProvider;
import com.arcway.lib.eclipse.uiframework.contextmenus.IEclipseContextMenuEntry;
import com.arcway.lib.eclipse.uiframework.treeviews.EclipseTreeViewElementWrapper;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.contextmenus.IContextMenuEntry;
import com.arcway.lib.ui.contextmenus.IWizardProvider;
import com.arcway.lib.ui.treeviews.ITreeViewFrontendAgent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewSite;

public class TreeViewMenuListener
implements IMenuListener {
    private final ITreeViewFrontendAgent view;
    private final TreeViewer viewer;
    private final Display display;
    private final IViewSite viewSite;
    private final IWizardProvider wizardProvider;

    public TreeViewMenuListener(TreeViewer treeViewer, ITreeViewFrontendAgent treeView, Display display, IViewSite viewSite) {
        this.viewer = treeViewer;
        this.view = treeView;
        this.display = display;
        this.viewSite = viewSite;
        this.wizardProvider = new EclipseWizardProvider(viewSite);
    }

    public void menuAboutToShow(IMenuManager manager) {
        Object[] selectionArray = ((StructuredSelection)this.viewer.getSelection()).toArray();
        Object[] nodeArray = new Object[selectionArray.length];
        int i = 0;
        while (i < selectionArray.length) {
            if (selectionArray[i] instanceof EclipseTreeViewElementWrapper) {
                nodeArray[i] = ((EclipseTreeViewElementWrapper)selectionArray[i]).getTreeViewElement();
            }
            ++i;
        }
        IContextMenuEntry[] entries = this.view.getContextMenuEntries(nodeArray);
        if (entries.length > 0) {
            String[] stringArray = IContextMenuEntry.GROUP_NAMES;
            int n = IContextMenuEntry.GROUP_NAMES.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                manager.add((IContributionItem)new Separator(element));
                ++n2;
            }
            stringArray = entries;
            n = entries.length;
            n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (entry.isContainer()) {
                    manager.appendToGroup(entry.getGroup(), this.buildSubmenu((IContextMenuEntry)entry));
                } else {
                    manager.appendToGroup(entry.getGroup(), this.buildAction((IContextMenuEntry)entry));
                }
                ++n2;
            }
        }
    }

    private IAction buildAction(final IContextMenuEntry entry) {
        Object action;
        if (entry instanceof IEclipseContextMenuEntry) {
            action = ((IEclipseContextMenuEntry)entry).createAction(this.viewSite);
            action.setEnabled(entry.isEnabled() & action.isEnabled());
        } else {
            action = new Action(entry.getLabel()){

                public void run() {
                    entry.run(TreeViewMenuListener.this.wizardProvider);
                }
            };
            action.setEnabled(entry.isEnabled());
            IStreamResource imageResource = entry.getImage();
            if (imageResource != null) {
                action.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageCache.getImage(this.display, imageResource)));
            }
        }
        return action;
    }

    private IContributionItem buildSubmenu(IContextMenuEntry entry) {
        IContextMenuEntry[] subEntries;
        MenuManager submenu = new MenuManager(entry.getLabel());
        submenu.setRemoveAllWhenShown(false);
        String[] stringArray = IContextMenuEntry.GROUP_NAMES;
        int n = IContextMenuEntry.GROUP_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            submenu.add((IContributionItem)new Separator(element));
            ++n2;
        }
        IContextMenuEntry[] iContextMenuEntryArray = subEntries = entry.getEntries();
        int n3 = subEntries.length;
        n = 0;
        while (n < n3) {
            IContextMenuEntry subEntry = iContextMenuEntryArray[n];
            if (subEntry != null) {
                if (subEntry.isContainer()) {
                    submenu.appendToGroup(subEntry.getGroup(), this.buildSubmenu(subEntry));
                } else {
                    submenu.appendToGroup(subEntry.getGroup(), this.buildAction(subEntry));
                }
            }
            ++n;
        }
        return submenu;
    }
}

