/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.treeviews;

import com.arcway.lib.eclipse.uiframework.treeviews.EclipseTreeViewElementWrapper;
import com.arcway.lib.ui.treeviews.ITreeView;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TreeViewContentProvider
implements ITreeContentProvider {
    private final ITreeView view;

    public TreeViewContentProvider(ITreeView view) {
        this.view = view;
    }

    public Object getRoot() {
        return new EclipseTreeViewElementWrapper(this.view.getInvisibleRoot(), this.view);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof EclipseTreeViewElementWrapper) {
            Object treeViewElement = ((EclipseTreeViewElementWrapper)parentElement).getTreeViewElement();
            Object[] elements = this.view.getChildNodes(treeViewElement);
            if (elements == null) {
                return new EclipseTreeViewElementWrapper[0];
            }
            Object[] result = new Object[elements.length];
            int i = 0;
            while (i < elements.length) {
                result[i] = new EclipseTreeViewElementWrapper(elements[i], this.view);
                ++i;
            }
            return result;
        }
        throw new IllegalArgumentException();
    }

    public Object getParent(Object element) {
        if (element instanceof EclipseTreeViewElementWrapper) {
            Object treeViewElement = ((EclipseTreeViewElementWrapper)element).getTreeViewElement();
            Object parent = this.view.getParentNode(treeViewElement);
            if (parent != null) {
                return new EclipseTreeViewElementWrapper(parent, this.view);
            }
            return null;
        }
        throw new IllegalArgumentException();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof EclipseTreeViewElementWrapper) {
            Object treeViewElement = ((EclipseTreeViewElementWrapper)element).getTreeViewElement();
            return this.view.hasChildNodes(treeViewElement);
        }
        throw new IllegalArgumentException();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

