/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.editors.repository;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.widgets.ImageButton;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.eclipse.resources.DisplayBoundResource;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.ResourceCache;
import com.arcway.lib.resource.URLResource;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.lib.ui.editor.datatype.EditorErrorMessage;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RepositoryEditorInfo {
    private final PresentationContext presentationContext;
    private final Shell infoShell;
    private StyledText txt_headline;
    private Label lbl_text;
    private Composite infoComposite;
    private final Font labelFont;
    private final Color backgroundColor;
    private static final IStreamResource closeImg = new URLResource(ResourceLoader.getURL((Plugin)ARCWAYEclipseLibPlugin.getDefault(), "icons/close.gif"));
    private static final int DEFAULT_MESSAGE_WIDTH = 40;

    public RepositoryEditorInfo(Shell parent, int style, PresentationContext presentationContext) {
        this.presentationContext = presentationContext;
        this.infoShell = new Shell(parent, style);
        this.backgroundColor = parent.getDisplay().getSystemColor(1);
        this.labelFont = (Font)ResourceCache.getInstance((Object)parent.getDisplay(), (Object)new LabelFontForName(parent.getFont().getFontData()[0].getName()), (ResourceCache.IInstanceFactory)new DisplayBoundResource<LabelFontForName, Font>(){

            public Font createInstance(Display display, LabelFontForName resource) {
                return new Font((Device)display, resource.getFontName(), 8, 1);
            }
        });
        this.init();
    }

    private void init() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.infoShell.setLayout((Layout)layout);
        GridData gd = new GridData(16384, 128, true, true);
        Composite comp = new Composite((Composite)this.infoShell, 0x800800);
        comp.setLayoutData((Object)gd);
        comp.setBackground(this.backgroundColor);
        GridLayout headerLayout = new GridLayout(2, false);
        comp.setLayout((Layout)headerLayout);
        gd = new GridData(16384, 0x1000000, true, false);
        this.txt_headline = new StyledText(comp, 0);
        this.txt_headline.setFont(this.labelFont);
        this.txt_headline.setLayoutData((Object)gd);
        gd = new GridData(131072, 0x1000000, false, false);
        ImageButton close = new ImageButton(comp, Messages.getString("EditorInfo.closeShell", this.presentationContext.getLocale()), ImageCache.getImage(this.infoShell.getDisplay(), closeImg), 0x800000);
        close.setLayoutData(gd);
        gd = new GridData(16384, 128, true, true);
        gd.horizontalSpan = 2;
        Composite content = new Composite(comp, 0x800000);
        content.setLayoutData((Object)gd);
        content.setBackground(this.backgroundColor);
        layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.marginLeft = 0;
        layout.marginTop = 10;
        layout.marginBottom = 10;
        content.setLayout((Layout)layout);
        this.lbl_text = new Label(content, 0);
        this.lbl_text.setBackground(this.backgroundColor);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.lbl_text.setLayoutData((Object)gd);
        this.infoComposite = new Composite(content, 0x800000);
        close.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent me) {
            }

            public void mouseDown(MouseEvent me) {
            }

            public void mouseUp(MouseEvent me) {
                RepositoryEditorInfo.this.infoShell.setVisible(false);
            }
        });
        Point preferredSize = this.infoShell.computeSize(200, -1);
        this.infoShell.setSize(preferredSize);
        comp.setFocus();
        comp.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
            }

            public void focusLost(FocusEvent fe) {
                RepositoryEditorInfo.this.infoShell.setVisible(false);
            }
        });
    }

    public void setHeadline(String headline) {
        this.txt_headline.setText(headline);
    }

    public void setText(String text) {
        this.lbl_text.setText(StringUtil.limitParagraphLength((String)text, (int)40));
    }

    public void setInfo(Collection<Tuple<List<String>, IEditorMessage>> allErrors) {
        if (allErrors == null) {
            this.infoComposite.setVisible(false);
        } else {
            Control[] children;
            Control[] controlArray = children = this.infoComposite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.dispose();
                ++n2;
            }
            this.infoComposite.setLayout((Layout)new GridLayout(2, false));
            this.infoComposite.setBackground(this.backgroundColor);
            for (Tuple<List<String>, IEditorMessage> labelAndMessage : allErrors) {
                List labels = (List)labelAndMessage.getT1();
                IEditorMessage error = (IEditorMessage)labelAndMessage.getT2();
                GridData gd = new GridData(131072, 128, false, false);
                StyledText st = new StyledText(this.infoComposite, 0);
                st.setFont(this.labelFont);
                st.setText(EditorErrorMessage.compileLabels((List)labels));
                st.setLayoutData((Object)gd);
                gd = new GridData(16384, 128, true, false);
                Label lbl_errors = new Label(this.infoComposite, 64);
                lbl_errors.setText(StringUtil.limitParagraphLength((String)error.getMessageText(this.presentationContext), (int)40));
                lbl_errors.setBackground(this.backgroundColor);
                lbl_errors.setLayoutData((Object)gd);
            }
            this.infoComposite.layout();
            this.infoComposite.setVisible(true);
        }
    }

    public void setLocationRightAlignment(Point location) {
        this.infoShell.pack();
        this.infoShell.setLocation(location.x - this.infoShell.getBounds().width, location.y);
    }

    public void setLocationLeftAlignment(Point location) {
        this.infoShell.pack();
        this.infoShell.setLocation(location.x, location.y);
    }

    public void openInfoShell() {
        this.infoShell.pack();
        this.infoShell.open();
    }

    public void dispose() {
        if (this.infoShell != null && !this.infoShell.isDisposed()) {
            this.infoShell.close();
            this.infoShell.dispose();
        }
    }

    private class LabelFontForName {
        private final String fontName;

        public LabelFontForName(String fontName) {
            this.fontName = fontName;
        }

        protected String getFontName() {
            return this.fontName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fontName == null ? 0 : this.fontName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LabelFontForName other = (LabelFontForName)obj;
            return !(this.fontName == null ? other.fontName != null : !this.fontName.equals(other.fontName));
        }
    }
}

