/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.editors;

import com.arcway.lib.eclipse.uiframework.IEclipseWindow;
import com.arcway.lib.eclipse.uiframework.editors.EditorInput;
import com.arcway.lib.eclipse.uiframework.shells.EclipseShell;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ErrorEditorPart;

public class EclipseWindow
extends EclipseShell
implements IEclipseWindow {
    private final IWorkbenchPage workbenchPage;

    public EclipseWindow(ExecutionEvent event) throws ExecutionException {
        super(HandlerUtil.getActiveSiteChecked((ExecutionEvent)event).getShell());
        IWorkbenchSite site = HandlerUtil.getActiveSiteChecked((ExecutionEvent)event);
        this.workbenchPage = site.getPage();
    }

    public EclipseWindow(IWorkbenchPage workbenchPage) {
        super(workbenchPage.getWorkbenchWindow().getShell());
        this.workbenchPage = workbenchPage;
    }

    public void openEditor(Object input) throws Exception {
        this.openEditor(input, false);
    }

    public void openEditor(final Object input, final boolean startInEditModeRequested) throws Exception {
        final Exception[] exception = new Exception[1];
        Display display = this.workbenchPage.getWorkbenchWindow().getShell().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    EditorInput editorInput = new EditorInput(input, startInEditModeRequested);
                    IEditorPart editorPart = EclipseWindow.this.workbenchPage.openEditor((IEditorInput)editorInput, "com.arcway.lib.eclipse.editor", true);
                    if (editorPart instanceof ErrorEditorPart) {
                        editorPart.getEditorSite().getPage().closeEditor(editorPart, false);
                    }
                }
                catch (PartInitException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    @Override
    public IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }
}

