/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.dialogs.imports;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayTitleAreaDialog;
import com.arcway.lib.eclipse.gui.viewers.CachingLabelProvider;
import com.arcway.lib.eclipse.uiframework.MacOSXCarbonFormToolkit;
import com.arcway.lib.eclipse.uiframework.dialogs.EclipseDialogWindow;
import com.arcway.lib.eclipse.uiframework.dialogs.imports.DecoratingLabelProvider;
import com.arcway.lib.eclipse.uiframework.dialogs.imports.ImportDialogConstants;
import com.arcway.lib.eclipse.uiframework.dialogs.imports.ImportDialogTabFolder;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.lib.eclipse.uiframework.editors.imports.ICloseVetoChangedListener;
import com.arcway.lib.eclipse.uiframework.editors.imports.ImportEditor;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.ui.dialog.imports.IEditorMessagesChangeListener;
import com.arcway.lib.ui.dialog.imports.IExceptionHandler;
import com.arcway.lib.ui.dialog.imports.IImportDialog;
import com.arcway.lib.ui.dialog.imports.IImportDialogController;
import com.arcway.lib.ui.dialog.imports.IImportDialogModelChangeListener;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.dialog.imports.IModelChangeListener;
import com.arcway.lib.ui.dialog.imports.IModelChangeProvider;
import com.arcway.lib.ui.dialog.imports.ImportDialogController;
import com.arcway.lib.ui.dialog.imports.TabDescription;
import com.arcway.lib.ui.editor.datatype.IEditorMessageSet;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.window.IShell;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImportDialog
extends ArcwayTitleAreaDialog
implements IImportDialog,
IExceptionHandler,
ICloseVetoChangedListener,
IModelChangeProvider {
    private final PresentationContext presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
    private final EclipseDialogWindow eclipseDialogWindow;
    private final IImportModelAccess modelAccess;
    private EEXNotReproducibleSnapshot notReproducibleSnapshot = null;
    private EEXSnapshotClosed snapshotClosed = null;
    private final List<TabDescription> tabDescriptions;
    private final Object singleObjectImportObject;
    private final FormToolkit toolkit;
    private final ImportDialogController dialogController;
    private ImportDialogTabFolder folder;
    private StackLayout stack;
    private ImportEditor currentImportEditor = null;
    private Composite comp_editor;
    private IImportDialogController listener;
    private ListenerKey messageChangeListenerKey = null;
    private ListenerKey modelChangeListenerKey = null;
    private final Collection<IImportDialogModelChangeListener> modelChangeListeners = new ArrayList<IImportDialogModelChangeListener>();

    public static int openImportDialog(EclipseWindow eclipseWindow, Object singleObjectImportObject, List<TabDescription> tabDescriptions, IImportModelAccess modelAccess) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        ImportDialog dialog = new ImportDialog(eclipseWindow, singleObjectImportObject, tabDescriptions, modelAccess);
        int returnValue = dialog.open();
        if (dialog.snapshotClosed != null) {
            throw dialog.snapshotClosed;
        }
        if (dialog.notReproducibleSnapshot != null) {
            throw dialog.notReproducibleSnapshot;
        }
        return returnValue;
    }

    private ImportDialog(EclipseWindow eclipseWindow, Object singleObjectImportObject, List<TabDescription> tabDescriptions, IImportModelAccess modelAccess) {
        super(eclipseWindow.getWorkbenchPage().getWorkbenchWindow().getShell(), false);
        this.eclipseDialogWindow = new EclipseDialogWindow(eclipseWindow, (Dialog)this);
        this.modelAccess = modelAccess;
        this.tabDescriptions = tabDescriptions;
        this.singleObjectImportObject = singleObjectImportObject;
        Display display = eclipseWindow.getWorkbenchPage().getWorkbenchWindow().getShell().getDisplay();
        this.toolkit = MacOSXCarbonFormToolkit.areWeRunningOnMacOSXCarbon() ? new MacOSXCarbonFormToolkit(display) : new FormToolkit(display);
        FormColors colors = this.toolkit.getColors();
        colors.createColor("HIGHLIGHT", ImportDialogConstants.HIGHLIGHT_COLOR);
        colors.setBackground(display.getSystemColor(1));
        this.dialogController = new ImportDialogController((IShell)eclipseWindow, (IImportDialog)this, modelAccess);
        this.addSelectionListener((IImportDialogController)this.dialogController);
        this.messageChangeListenerKey = new ListenerKey();
        this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().addMessagesChangeListener(this.messageChangeListenerKey, new IEditorMessagesChangeListener(){

            public void messagesChanged() {
                ImportDialog.this.callMessageChangeListeners();
            }

            public void dispose() {
                if (ImportDialog.this.messageChangeListenerKey != null) {
                    ImportDialog.this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().removeMessagesChangeListener(ImportDialog.this.messageChangeListenerKey);
                    ImportDialog.this.messageChangeListenerKey = null;
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString("ImportEditor.dialogTitle", this.presentationContext.getLocale()));
        this.setTitle(Messages.getString("ImportEditor.dialogTitle", this.presentationContext.getLocale()));
        this.setMessage(Messages.getString("ImportEdior.dialogMessage", this.presentationContext.getLocale()));
        Composite composite = (Composite)super.createDialogArea(parent);
        SashForm sash_dialogArea = new SashForm(composite, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 1024;
        gd.heightHint = 768;
        sash_dialogArea.setLayoutData((Object)gd);
        sash_dialogArea.setBackground(this.toolkit.getColors().getBackground());
        int numCols = 1;
        if (this.singleObjectImportObject == null) {
            numCols = 2;
        }
        GridLayout areaLayout = new GridLayout(numCols, false);
        areaLayout.horizontalSpacing = 0;
        areaLayout.marginWidth = 0;
        sash_dialogArea.setLayout((Layout)areaLayout);
        if (this.singleObjectImportObject == null) {
            DecoratingLabelProvider decoratinglabelProvider = new DecoratingLabelProvider(shell.getDisplay(), this.modelAccess, this, this.presentationContext);
            final CachingLabelProvider cachingLabelProvider = new CachingLabelProvider(decoratinglabelProvider);
            this.modelChangeListenerKey = new ListenerKey();
            this.modelAccess.addModelChangeListener(this.modelChangeListenerKey, new IModelChangeListener(){

                public void modelChanged() {
                    cachingLabelProvider.clearLabelCaches();
                }

                public void dispose() {
                    ImportDialog.this.removeModelChangeListenerIfRegistered();
                }
            });
            this.folder = new ImportDialogTabFolder((Composite)sash_dialogArea, this, (IImportDialogController)this.dialogController, cachingLabelProvider, this.tabDescriptions);
            gd = new GridData(16384, 128, false, true);
            gd.widthHint = 250;
            gd.verticalSpan = 2;
            this.folder.setLayoutData(gd);
        }
        Composite comp_form = this.toolkit.createComposite((Composite)sash_dialogArea, 0x800800);
        gd = new GridData(4, 128, true, true);
        gd.widthHint = 760;
        comp_form.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp_form.setLayout((Layout)layout);
        this.comp_editor = this.toolkit.createComposite(comp_form, 0x800000);
        gd = new GridData(4, 4, true, true);
        this.comp_editor.setLayoutData((Object)gd);
        this.stack = new StackLayout();
        this.comp_editor.setLayout((Layout)this.stack);
        if (this.singleObjectImportObject == null) {
            sash_dialogArea.setWeights(new int[]{1, 3});
        } else {
            this.topEditor(this.singleObjectImportObject);
        }
        return composite;
    }

    private void removeModelChangeListenerIfRegistered() {
        if (this.modelChangeListenerKey != null) {
            this.modelAccess.removeModelChangeListener(this.modelChangeListenerKey);
            this.modelChangeListenerKey = null;
        }
    }

    protected Control createButtonBar(Composite parent) {
        return this.createButtonBarWithLockButton(parent);
    }

    private Control createButtonBarWithLockButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite.setFont(parent.getFont());
        boolean isWithLockButton = this.modelAccess.getLockAndPermissionProvider().shallEditorsSupportViewMode();
        if (isWithLockButton) {
            Control lockControl = this.createLockControl(composite);
            ((GridData)lockControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
        }
        Control buttonSection = this.dialogCreateButtonBar(composite);
        ((GridData)buttonSection.getLayoutData()).grabExcessHorizontalSpace = true;
        return composite;
    }

    private Control dialogCreateButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        this.updateOkButton();
        return composite;
    }

    private Control createLockControl(Composite parent) {
        Button link = new Button(parent, 0);
        ++((GridLayout)parent.getLayout()).numColumns;
        link.setLayoutData((Object)new GridData(64));
        link.setText(Messages.getString("ImportDialog.UpdateLocks"));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDialog.this.dialogController.updateLocks();
            }
        });
        return link;
    }

    @Override
    protected void dispose() {
        if (this.messageChangeListenerKey != null) {
            this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().removeMessagesChangeListener(this.messageChangeListenerKey);
            this.messageChangeListenerKey = null;
        }
        this.removeModelChangeListenerIfRegistered();
        if (this.folder != null && !this.folder.isDisposed()) {
            this.folder.dispose();
        }
        if (this.currentImportEditor != null && !this.currentImportEditor.isDisposed()) {
            this.currentImportEditor.dispose();
        }
        this.currentImportEditor = null;
    }

    public void topEditor(Object importedObject) {
        Object currentImportedObject = this.getImportedObjectOfCurrentEditor();
        if (currentImportedObject == null || !currentImportedObject.equals(importedObject)) {
            this.openEditor(importedObject);
        }
        this.comp_editor.layout();
    }

    private Object getImportedObjectOfCurrentEditor() {
        Object currentImportedObject = this.currentImportEditor != null ? this.currentImportEditor.getImportedObject() : null;
        return currentImportedObject;
    }

    private void openEditor(Object importedObject) {
        if (this.currentImportEditor != null) {
            this.currentImportEditor.deactivate();
            this.currentImportEditor.removeCloseVetoChangedListener(this);
        }
        ImportEditor newImportEditor = null;
        if (importedObject != null) {
            ImportEditor editor = new ImportEditor(this.eclipseDialogWindow, this.comp_editor, this.toolkit, this, this, this.modelAccess, importedObject, this.presentationContext);
            editor.addCloseVetoChangedListener(this);
            this.stack.topControl = editor;
            newImportEditor = editor;
        } else {
            this.stack.topControl = null;
        }
        if (this.currentImportEditor != null) {
            this.currentImportEditor.dispose();
        }
        this.currentImportEditor = newImportEditor;
    }

    public void addSelectionListener(IImportDialogController selectionListener) {
        this.listener = selectionListener;
    }

    public IImportDialogController getSelectionListener() {
        return this.listener;
    }

    public FormToolkit getFormToolkit() {
        return this.toolkit;
    }

    @Override
    public boolean close() {
        this.dispose();
        return super.close();
    }

    public PresentationContext getCurrentPresentationContext() {
        return this.presentationContext;
    }

    public void snapshotClosed(EEXSnapshotClosed e) {
        this.snapshotClosed = e;
        this.closeDeferred();
    }

    public void handleEEXNotReproducibleSnapshot(EEXNotReproducibleSnapshot e) {
        this.notReproducibleSnapshot = e;
        this.closeDeferred();
    }

    private void closeDeferred() {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ImportDialog.this.getShell().isDisposed()) {
                    ImportDialog.this.close();
                }
            }
        });
    }

    public IEditorMessageSet getMessageSet(Collection<Object> objects) throws EEXNotReproducibleSnapshot {
        return this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().getMessageSetForObjects(objects);
    }

    public void registerModelChangeListener(IImportDialogModelChangeListener modelChangeListener) {
        this.modelChangeListeners.add(modelChangeListener);
    }

    private void callMessageChangeListeners() {
        this.updateOkButton();
        for (IImportDialogModelChangeListener messageChangeListener : this.modelChangeListeners) {
            messageChangeListener.modelChanged();
        }
    }

    private void updateOkButton() {
        try {
            IMessageLevel highestLevel = this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().getMessageSetForAllMessages().getHighestLevel();
            Button okButton = this.getButton(0);
            if (highestLevel != null && highestLevel.isError() || this.currentImportEditor != null && this.currentImportEditor.hasCloseVetos()) {
                okButton.setEnabled(false);
            } else {
                okButton.setEnabled(true);
            }
        }
        catch (EEXNotReproducibleSnapshot e) {
            this.handleEEXNotReproducibleSnapshot(e);
        }
    }

    private void updateCancelButton() {
        Button cancelButton = this.getButton(1);
        cancelButton.setEnabled(this.currentImportEditor != null && !this.currentImportEditor.hasCloseVetos());
    }

    protected void handleShellCloseEvent() {
        if (this.currentImportEditor != null && this.currentImportEditor.hasCloseVetos()) {
            return;
        }
        super.handleShellCloseEvent();
    }

    @Override
    public void closeVetoChanged(ImportEditor importEditor) {
        this.updateOkButton();
        this.updateCancelButton();
    }
}

