/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.dialogs.imports;

import com.arcway.lib.eclipse.gui.viewers.UsableCheckboxTreeViewer;
import com.arcway.lib.eclipse.resources.DecoratedImage;
import com.arcway.lib.eclipse.resources.DecoratedImageCache;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.eclipse.uiframework.dialogs.ContentProvider;
import com.arcway.lib.eclipse.uiframework.dialogs.imports.DecoratingLabelProvider;
import com.arcway.lib.eclipse.uiframework.dialogs.imports.ImportDialogTabFolder;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.dialog.imports.IExceptionHandler;
import com.arcway.lib.ui.dialog.imports.IImportDialogController;
import com.arcway.lib.ui.dialog.imports.IImportDialogModelChangeListener;
import com.arcway.lib.ui.dialog.imports.TabDescription;
import com.arcway.lib.ui.dialog.imports.TreeViewInput;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ImortDialogTab {
    private final IExceptionHandler exceptionHandler;
    private Object lastSelection = null;

    public ImortDialogTab(final ImportDialogTabFolder tabFolder, TabDescription tabDescription, ILabelProvider labelProvider, final IImportDialogController controller) {
        this.exceptionHandler = tabFolder.getExceptionHandler();
        final IStreamResource icon16x16 = tabDescription.getIcon16x16();
        FormToolkit formToolkit = tabFolder.getFormToolkit();
        final Display display = tabFolder.getDisplay();
        final TreeViewInput input = tabDescription.getInput();
        if (!input.getRootObjects().isEmpty()) {
            final CTabItem tab = new CTabItem((CTabFolder)tabFolder, 128);
            tab.setToolTipText(tabDescription.getText());
            if (icon16x16 != null) {
                Image image = ImageCache.getImage(display, icon16x16);
                tab.setImage(image);
            } else {
                tab.setText(tabDescription.getText());
            }
            Composite comp_tree = formToolkit.createComposite((Composite)tabFolder);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 2;
            layout.marginHeight = 0;
            comp_tree.setLayout((Layout)layout);
            final UsableCheckboxTreeViewer treeViewer = new UsableCheckboxTreeViewer(comp_tree, 3, 5, 2048);
            ContentProvider contentProvider = new ContentProvider(input.getParent2Children());
            treeViewer.setContentProvider((IContentProvider)contentProvider);
            treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            treeViewer.setSorter(new ViewerSorter());
            treeViewer.setInput(input.getRootObjects());
            if (tabDescription.showObjectsWithMessagesOnly()) {
                treeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        boolean hide;
                        try {
                            hide = tabFolder.getMessageSet(Collections.singletonList(element)).isEmpty();
                        }
                        catch (EEXNotReproducibleSnapshot e) {
                            ImortDialogTab.this.exceptionHandler.handleEEXNotReproducibleSnapshot(e);
                            hide = true;
                        }
                        return !hide;
                    }
                }});
            }
            treeViewer.expandAll();
            treeViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    try {
                        Object element = event.getElement();
                        boolean currentState = controller.getImportFlag(element);
                        boolean wishedState = event.getChecked();
                        if (currentState != wishedState) {
                            controller.changeImportFlag(element, wishedState);
                        }
                    }
                    catch (EEXNotReproducibleSnapshot e) {
                        ImortDialogTab.this.exceptionHandler.handleEEXNotReproducibleSnapshot(e);
                    }
                }
            });
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object selectedElement = selection.getFirstElement();
                    if (selectedElement != null) {
                        controller.objectSelected(selectedElement);
                        ImortDialogTab.this.lastSelection = selectedElement;
                    }
                }
            });
            Tree tree = treeViewer.getTree();
            tree.setLayoutData((Object)new GridData(1808));
            tab.setControl((Control)comp_tree);
            final Collection allObjects = input.getAllObjects();
            tabFolder.registerModelChangeListener(new IImportDialogModelChangeListener(){

                public void modelChanged() {
                    ImortDialogTab.this.updateDecoratorsAndCheckboxes(tabFolder, controller, icon16x16, display, tab, treeViewer, allObjects);
                }
            });
            this.lastSelection = this.findFirstUnfilteredObject(input, (TreeViewer)treeViewer);
            tabFolder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.item == tab) {
                        if (ImortDialogTab.this.lastSelection == null || ImortDialogTab.this.isFiltered(ImortDialogTab.this.lastSelection, (TreeViewer)treeViewer)) {
                            ImortDialogTab.this.lastSelection = ImortDialogTab.this.findFirstUnfilteredObject(input, (TreeViewer)treeViewer);
                        }
                        treeViewer.setSelection((ISelection)(ImortDialogTab.this.lastSelection != null ? new StructuredSelection(ImortDialogTab.this.lastSelection) : null));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.updateDecoratorsAndCheckboxes(tabFolder, controller, icon16x16, display, tab, treeViewer, allObjects);
        }
    }

    private void updateDecoratorsAndCheckboxes(ImportDialogTabFolder tabFolder, IImportDialogController controller, IStreamResource icon16x16, Display display, CTabItem tab, UsableCheckboxTreeViewer treeViewer, Collection<Object> allObjects) {
        treeViewer.refresh();
        if (icon16x16 != null) {
            Image resultingImage;
            IStreamResource decorator7x8;
            Image baseImage = ImageCache.getImage(display, icon16x16);
            try {
                decorator7x8 = tabFolder.getMessageSet(allObjects).getDecorator7x8();
            }
            catch (EEXNotReproducibleSnapshot e) {
                this.exceptionHandler.handleEEXNotReproducibleSnapshot(e);
                decorator7x8 = null;
            }
            if (decorator7x8 == null) {
                resultingImage = baseImage;
            } else {
                Image decoratorImage = ImageCache.getImage(display, decorator7x8);
                DecoratedImage decoratedImage = new DecoratedImage(baseImage, decoratorImage, DecoratingLabelProvider.MESSAGE_DECORATOR_POSITION);
                resultingImage = DecoratedImageCache.getImage(display, decoratedImage);
            }
            tab.setImage(resultingImage);
        }
        ArrayList<Object> checkedElements = new ArrayList<Object>();
        for (Object object : allObjects) {
            if (!controller.getImportFlag(object)) continue;
            checkedElements.add(object);
        }
        treeViewer.setCheckedElements(checkedElements.toArray());
    }

    private boolean isFiltered(Object item, TreeViewer viewer) {
        if (viewer.getFilters() != null) {
            ViewerFilter[] viewerFilterArray = viewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter.filter((Viewer)viewer, null, new Object[]{item}).length == 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Object findFirstUnfilteredObject(TreeViewInput<?> input, TreeViewer treeViewer) {
        Object[] sortedRootObjects = new ArrayList(input.getRootObjects()).toArray();
        treeViewer.getSorter().sort((Viewer)treeViewer, sortedRootObjects);
        Object[] objectArray = sortedRootObjects;
        int n = sortedRootObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object rootObject = objectArray[n2];
            if (!this.isFiltered(rootObject, treeViewer)) {
                return rootObject;
            }
            ++n2;
        }
        return null;
    }
}

