/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.uiframework.dialogs.imports;

import com.arcway.lib.eclipse.resources.DecoratedImage;
import com.arcway.lib.eclipse.resources.DecoratedImageCache;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.icons.Decorators7x8;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.dialog.imports.IExceptionHandler;
import com.arcway.lib.ui.dialog.imports.IImportModelAccess;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DecoratingLabelProvider<OBJECT_REFERENCE>
implements ILabelProvider,
ILabelDecorator {
    private static final ILogger LOGGER = Logger.getLogger(DecoratingLabelProvider.class);
    private static final int IMPORTMODE_MODIFIED = 2;
    private static final int IMPORTMODE_NEW = 1;
    private final Display display;
    private final IImportModelAccess<?, ?, ?, OBJECT_REFERENCE> modelAccess;
    private final IExceptionHandler exceptionHandler;
    private final PresentationContext presentationContext;
    public static final Alignment MESSAGE_DECORATOR_POSITION = new Alignment(1, 32);
    private static final Alignment MODE_DECORATOR_POSITION = new Alignment(4, 32);

    public DecoratingLabelProvider(Display display, IImportModelAccess<?, ?, ?, OBJECT_REFERENCE> modelAccess, IExceptionHandler exceptionHandler, PresentationContext presentationContext) {
        this.display = display;
        this.modelAccess = modelAccess;
        this.exceptionHandler = exceptionHandler;
        this.presentationContext = presentationContext;
    }

    public Image decorateImage(Image image, Object element) {
        Image decoratedImage;
        Image original = image;
        int importMode = this.modelAccess.getCurrentModelAndModificationsAccessAgent().getImportMode(element);
        try {
            IStreamResource decoratorStreamResource = this.modelAccess.getCurrentModelAndModificationsAccessAgent().getEditorMessageStorage().getMessageSetForObject(element).getDecorator7x8();
            decoratedImage = this.getDecoratedImage(original, decoratorStreamResource, importMode);
        }
        catch (EEXNotReproducibleSnapshot e) {
            decoratedImage = image;
            this.exceptionHandler.handleEEXNotReproducibleSnapshot(e);
        }
        return decoratedImage;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image getImage(Object element) {
        Image image = null;
        try {
            IStreamResource icon16x16 = this.modelAccess.getCurrentModelAndModificationsAccessAgent().getIconForObject16x16(element, this.presentationContext);
            if (icon16x16 != null) {
                image = ImageCache.getImage(this.display, icon16x16);
            }
            if (image != null) {
                image = this.decorateImage(image, element);
            }
            return image;
        }
        catch (EEXSnapshotClosed eSC) {
            LOGGER.error("Snapshot closed when retrieving icon", (Throwable)eSC);
            return null;
        }
        catch (EEXNotReproducibleSnapshot eNRS) {
            LOGGER.error("Not reproducible snapshot when retrieving icon", (Throwable)eNRS);
            return null;
        }
    }

    public String getText(Object element) {
        return this.modelAccess.getCurrentModelAndModificationsAccessAgent().getLabelForImportedObject(element, this.presentationContext);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    private Image getDecoratedImage(Image original, IStreamResource messageDecorator, int importMode) {
        DecoratedImage decoratedImage;
        Image image = original;
        if (importMode == 1) {
            Image modeDecoratorImage = ImageCache.getImage(this.display, Decorators7x8.NEW);
            decoratedImage = new DecoratedImage(original, modeDecoratorImage, MODE_DECORATOR_POSITION);
            image = DecoratedImageCache.getImage(this.display, decoratedImage);
        } else if (importMode == 2) {
            Image modeDecorator = ImageCache.getImage(this.display, Decorators7x8.MODIFIED);
            decoratedImage = new DecoratedImage(original, modeDecorator, MODE_DECORATOR_POSITION);
            image = DecoratedImageCache.getImage(this.display, decoratedImage);
        }
        if (messageDecorator != null) {
            Image messageDecoratorImage = ImageCache.getImage(this.display, messageDecorator);
            decoratedImage = new DecoratedImage(image, messageDecoratorImage, MESSAGE_DECORATOR_POSITION);
            image = DecoratedImageCache.getImage(this.display, decoratedImage);
        }
        return image;
    }

    public void dispose() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

