/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.transfer.old;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class URLTransfer
extends ByteArrayTransfer {
    private static URLTransfer instance = new URLTransfer();
    private static final String[] supportedTypes = new String[]{"UniformResourceLocator", "UniformResourceLocator", "CF_UNICODETEXT", "CF_TEXT"};
    private static final int[] supportedTypeIds = new int[]{49367, 49362, 13, 1};

    public static URLTransfer getInstance() {
        return instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (object == null || !(object instanceof URLType[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            URLType[] data = (URLType[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(out);
                URLType[] uRLTypeArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    URLType element = uRLTypeArray[n2];
                    dataOut.writeBytes(element.getUrl());
                    dataOut.writeBytes("\n");
                    dataOut.writeBytes(element.getText());
                    ++n2;
                }
                byte[] buffer = out.toByteArray();
                dataOut.close();
                super.javaToNative((Object)buffer, transferData);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            URLType myData = null;
            try {
                URLType datum = new URLType();
                byte[] text = new byte[buffer.length];
                int j = 0;
                byte[] byArray = buffer;
                int n = buffer.length;
                int n2 = 0;
                while (n2 < n) {
                    byte element = byArray[n2];
                    if (element != 0) {
                        text[j++] = element;
                    }
                    ++n2;
                }
                String data = new String(text, 0, j);
                int end = data.indexOf("\n");
                if (end >= 0) {
                    datum.setLinkURL(data.substring(0, end++));
                    datum.setText(end == data.length() ? "" : data.substring(end));
                } else {
                    datum.setLinkURL(data);
                    datum.setText("");
                }
                myData = datum;
            }
            catch (Exception e) {
                return null;
            }
            return myData;
        }
        return null;
    }

    protected String[] getTypeNames() {
        return supportedTypes;
    }

    protected int[] getTypeIds() {
        return supportedTypeIds;
    }

    public boolean isSupportedType(TransferData transferData) {
        if (transferData != null) {
            int[] nArray = supportedTypeIds;
            int n = supportedTypeIds.length;
            int n2 = 0;
            while (n2 < n) {
                int element = nArray[n2];
                if (transferData.type == element) {
                    return true;
                }
                ++n2;
            }
        }
        return super.isSupportedType(transferData);
    }

    public class URLType {
        private String url;
        private String text;

        public String toString() {
            return String.valueOf(this.url) + "\n" + this.text;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String linkText) {
            this.text = linkText;
        }

        public String getUrl() {
            return this.url;
        }

        public void setLinkURL(String linkURL) {
            this.url = linkURL;
        }
    }
}

