/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.transfer;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.canonicalstring.CanonicalStringCoDecForData;
import com.arcway.lib.codec.data.codecs.canonicalstring.EXCanonicalStringDecodingFailed;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgent;
import com.arcway.lib.eclipse.transfer.ExByteArrayDecodingFailed;
import com.arcway.lib.eclipse.transfer.ExByteArrayEncodingFailed;
import java.io.UnsupportedEncodingException;

public abstract class SerializableDataTypeTransferAgent
extends AbstractTransferAgent {
    private static final String UTF_8 = "UTF-8";

    public SerializableDataTypeTransferAgent(String dataTypeName) {
        super("$TransferType_SerializableDataTypeTransferAgent" + dataTypeName);
    }

    protected abstract IDataType getDataType();

    @Override
    protected final Object byteArrayToJava(byte[] dataAsByteArray, int dataStartPos, int dataLength) throws ExByteArrayDecodingFailed {
        Object result;
        try {
            IDataType dataType = this.getDataType();
            if (dataType == null) {
                throw new ExByteArrayDecodingFailed("Data type not determined.");
            }
            result = CanonicalStringCoDecForData.decodeFromCanonicalString((IDataType)dataType, (String)new String(dataAsByteArray, dataStartPos, dataLength, UTF_8));
        }
        catch (EXDataCreationFailed e) {
            throw new ExByteArrayDecodingFailed("Could not deserialise data.", e);
        }
        catch (EXCanonicalStringDecodingFailed e) {
            throw new ExByteArrayDecodingFailed("Could not deserialise data.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExByteArrayDecodingFailed("Could not deserialise data.", e);
        }
        return result;
    }

    @Override
    protected final byte[] javaToByteArray(Object dataAsObject) throws ExByteArrayEncodingFailed {
        byte[] result;
        IDataType dataType = this.getDataType();
        if (dataType == null) {
            throw new ExByteArrayEncodingFailed("Data type not determined.");
        }
        try {
            result = CanonicalStringCoDecForData.encodeIntoCanonicalString((IDataType)dataType, (Object)dataAsObject).getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new ExByteArrayEncodingFailed("Could not serialise data: UTF-8 encoding not supported?!", e);
        }
        return result;
    }
}

