/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.transfer;

import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.ExByteArrayDecodingFailed;
import com.arcway.lib.eclipse.transfer.ExByteArrayEncodingFailed;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferContent;
import java.util.ArrayList;
import java.util.Collection;

public class MultipleObjectTransferAgent
extends AbstractTransferAgentForMultipleObjectTransfer {
    private static final String DNDNATIVETYPENAME = "$Multiple Object Transfer";
    private static final byte[] ByteArrayFormatPreamble = new byte[]{65, 82, 67, 87, 65, 89, 32, 32, 67, 79, 67, 75, 80, 73, 84, 32, 70, 79, 82, 77, 65, 84, 32, 32, 48, 48, 48, 48, 48, 48, 48, 49};
    private static MultipleObjectTransferAgent _instance;

    public static synchronized MultipleObjectTransferAgent getInstance() {
        if (_instance == null) {
            _instance = new MultipleObjectTransferAgent(DNDNATIVETYPENAME);
        }
        return _instance;
    }

    protected MultipleObjectTransferAgent(String typeName) {
        super(typeName);
    }

    @Override
    protected byte[] javaToByteArray(Object dataAsObject) throws ExByteArrayEncodingFailed {
        ArrayList<byte[]> compartments = new ArrayList<byte[]>();
        compartments.add(ByteArrayFormatPreamble);
        Collection sourceContents = (Collection)dataAsObject;
        for (MultipleObjectTransferContent sourceContent : sourceContents) {
            AbstractTransferAgentForMultipleObjectTransfer transferAgent = sourceContent.getTransferAgent();
            byte[] data = transferAgent.javaToByteArray(sourceContent.getObjectToTransfer());
            int transferAgentTypeID = transferAgent.getTypeID();
            compartments.add(new byte[]{(byte)(transferAgentTypeID >>> 24 & 0xFF), (byte)(transferAgentTypeID >>> 16 & 0xFF), (byte)(transferAgentTypeID >>> 8 & 0xFF), (byte)(transferAgentTypeID >>> 0 & 0xFF)});
            compartments.add(new byte[]{(byte)(data.length >>> 24 & 0xFF), (byte)(data.length >>> 16 & 0xFF), (byte)(data.length >>> 8 & 0xFF), (byte)(data.length >>> 0 & 0xFF)});
            compartments.add(data);
        }
        int resultlength = 0;
        for (byte[] b : compartments) {
            resultlength += b.length;
        }
        byte[] result = new byte[resultlength];
        int destpos = 0;
        for (byte[] compartment : compartments) {
            System.arraycopy(compartment, 0, result, destpos, compartment.length);
            destpos += compartment.length;
        }
        return result;
    }

    @Override
    protected Object byteArrayToJava(byte[] dataAsByteArray, int dataStartPos, int dataLength) throws ExByteArrayDecodingFailed {
        try {
            if (dataAsByteArray == null) {
                throw new ExByteArrayDecodingFailed("Can not decode <null> array.");
            }
            int preambleCheckLength = Math.min(ByteArrayFormatPreamble.length, dataLength);
            int i = 0;
            while (i < preambleCheckLength) {
                if (ByteArrayFormatPreamble[i] != dataAsByteArray[dataStartPos + i]) {
                    StringBuilder failureMsg = new StringBuilder("Invalid preamble (");
                    int pb = 0;
                    while (pb < preambleCheckLength) {
                        failureMsg.append(dataAsByteArray[dataStartPos + pb]);
                        if (pb < preambleCheckLength - 1) {
                            failureMsg.append(", ");
                        }
                        ++pb;
                    }
                    failureMsg.append(") deviation from expected preamble at byte ");
                    failureMsg.append(i + 1);
                    failureMsg.append(" of ");
                    failureMsg.append(ByteArrayFormatPreamble.length);
                    failureMsg.append(" bytes.");
                    throw new ExByteArrayDecodingFailed(failureMsg.toString());
                }
                ++i;
            }
            if (ByteArrayFormatPreamble.length > dataLength) {
                throw new ExByteArrayDecodingFailed("ByteArray data starts with incomplete preamble: preamble truncated after " + dataLength + " bytes.");
            }
            ArrayList<MultipleObjectTransferContent> sourceContents = new ArrayList<MultipleObjectTransferContent>();
            int readpos = dataStartPos + ByteArrayFormatPreamble.length;
            while (readpos < dataStartPos + dataLength) {
                int transferAgentTypeID = (int)(0x1000000L * ((long)dataAsByteArray[readpos + 0] & 0xFFL) + 65536L * ((long)dataAsByteArray[readpos + 1] & 0xFFL) + 256L * ((long)dataAsByteArray[readpos + 2] & 0xFFL) + 1L * ((long)dataAsByteArray[readpos + 3] & 0xFFL));
                int tranferDataCompartmentLength = (int)(0x1000000L * ((long)dataAsByteArray[(readpos += 4) + 0] & 0xFFL) + 65536L * ((long)dataAsByteArray[readpos + 1] & 0xFFL) + 256L * ((long)dataAsByteArray[readpos + 2] & 0xFFL) + 1L * ((long)dataAsByteArray[readpos + 3] & 0xFFL));
                readpos += 4;
                AbstractTransferAgentForMultipleObjectTransfer transferAgent = AbstractTransferAgentForMultipleObjectTransfer.getAgentByTypeID(transferAgentTypeID);
                if (transferAgent == null) {
                    throw new ExByteArrayDecodingFailed("Could not find transfer agent (id = " + transferAgentTypeID + ") when deserialising multiple object transfer content.");
                }
                sourceContents.add(new MultipleObjectTransferContent(transferAgent.byteArrayToJava(dataAsByteArray, readpos, tranferDataCompartmentLength), transferAgent));
                readpos += tranferDataCompartmentLength;
            }
            return sourceContents;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExByteArrayDecodingFailed("Illegal or incompplete data.", e);
        }
    }
}

