/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.transfer;

import com.arcway.lib.eclipse.transfer.ExByteArrayDecodingFailed;
import com.arcway.lib.eclipse.transfer.ExByteArrayEncodingFailed;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class AbstractTransferAgent
extends ByteArrayTransfer {
    private static final ILogger LOGGER = Logger.getLogger(AbstractTransferAgent.class);
    private final String typeName;
    private final int typeID;

    public static int registerTransferType(String typeName) {
        int transferTypeID = AbstractTransferAgent.registerType((String)typeName);
        if (transferTypeID == 0) {
            LOGGER.error("Unable to register clipboard format \"" + typeName + "\".");
        }
        return transferTypeID;
    }

    public AbstractTransferAgent(String typeName) {
        this.typeName = typeName;
        this.typeID = AbstractTransferAgent.registerTransferType(this.getTypeName());
    }

    protected final int[] getTypeIds() {
        return new int[]{this.getTypeID()};
    }

    protected final String[] getTypeNames() {
        return new String[]{this.getTypeName()};
    }

    protected final int getTypeID() {
        return this.typeID;
    }

    public final void javaToNative(Object object, TransferData transferData) {
        byte[] byteArrayRepresentation = null;
        try {
            byteArrayRepresentation = this.javaToByteArray(object);
        }
        catch (ExByteArrayEncodingFailed e) {
            LOGGER.error("Unable to create ByteArrayEncoding of data (Clipboard) Transfer will fail.", (Throwable)e);
        }
        super.javaToNative((Object)byteArrayRepresentation, transferData);
    }

    public final Object nativeToJava(TransferData transferData) {
        Object java;
        byte[] byteArray = (byte[])super.nativeToJava(transferData);
        if (byteArray == null) {
            java = null;
        } else {
            try {
                java = this.byteArrayToJava(byteArray, 0, byteArray.length);
            }
            catch (ExByteArrayDecodingFailed e) {
                java = null;
                LOGGER.warn("Unable to decode Clipboard contents.", (Throwable)e);
            }
        }
        return java;
    }

    protected final String getTypeName() {
        return this.typeName;
    }

    protected abstract byte[] javaToByteArray(Object var1) throws ExByteArrayEncodingFailed;

    protected abstract Object byteArrayToJava(byte[] var1, int var2, int var3) throws ExByteArrayDecodingFailed;

    protected final Object byteArrayToJava(byte[] dataAsByteArray) throws ExByteArrayDecodingFailed {
        return this.byteArrayToJava(dataAsByteArray, 0, dataAsByteArray.length);
    }
}

