/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.resources;

import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class ResourceDisposer {
    private static final ILogger LOGGER = Logger.getLogger(ResourceDisposer.class);

    public static void markResourceAsSingleton(final Resource resource) {
        Device device;
        if (resource != null && (device = resource.getDevice()) != null) {
            if (device instanceof Display) {
                final Display display = (Display)device;
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (resource instanceof Image) {
                            Image image = (Image)resource;
                            ImageRegistry imageRegistry = ARCWAYEclipseLibPlugin.getDefault().getImageRegistry();
                            imageRegistry.put(UUIDGenerator.getUniqueID(), image);
                        } else {
                            display.disposeExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!resource.isDisposed()) {
                                        try {
                                            resource.dispose();
                                        }
                                        catch (Throwable e) {
                                            LOGGER.error("Exception during disposal of undisposed singelton resource.", e);
                                        }
                                    } else {
                                        LOGGER.warn("Singelton resource was disposed by someone else.");
                                    }
                                }
                            });
                        }
                    }
                });
            } else {
                throw new UnsupportedOperationException("ResourceDisposer can only handle display resources, but not " + device + " resources.");
            }
        }
    }

    private ResourceDisposer() {
    }
}

