/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.resources;

import com.arcway.lib.eclipse.resources.DisplayBoundResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.resource.ResourceCache;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class ImageCache {
    private static final ResourceCache.IInstanceFactory<Display, IStreamResource, Image> instanceFactory = new DisplayBoundResource<IStreamResource, Image>(){

        public Image createInstance(Display display, IStreamResource streamResource) {
            Image image;
            try {
                InputStream inputStream = streamResource.toInputStream();
                image = new Image((Device)display, inputStream);
            }
            catch (SWTException e) {
                image = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
            catch (JvmExternalResourceInteractionException e) {
                image = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
            return image;
        }
    };

    public static Image getImage(Display display, IStreamResource resource) {
        Image image = (Image)ResourceCache.getInstance((Object)display, (Object)resource, instanceFactory);
        assert (!image.isDisposed());
        return image;
    }

    public static ImageDescriptor getImageDescriptor(final IStreamResource resource) {
        ImageDescriptor imageDescriptor = new ImageDescriptor(){
            private SoftReference<ImageData> imageDataCache = null;

            public ImageData getImageData() {
                ImageData imageData = this.imageDataCache != null ? this.imageDataCache.get() : null;
                if (imageData == null) {
                    InputStream inputStream;
                    try {
                        inputStream = resource.toInputStream();
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        inputStream = null;
                    }
                    if (inputStream != null) {
                        try {
                            imageData = new ImageData(inputStream);
                            this.imageDataCache = new SoftReference<ImageData>(imageData);
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                return imageData;
            }
        };
        return imageDescriptor;
    }
}

